/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.vintage_animations.mixin;

import dev.architectury.platform.Platform;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.MirrorModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.pixeldreamstudios.vintage_animations.IAnimatedPlayer;
import net.pixeldreamstudios.vintage_animations.VintageAnimations;
import net.pixeldreamstudios.vintage_animations.compat.FirstPersonModelCompat;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public class LivingEntityMixin {
    @Unique
    private ModifierLayer<IAnimation> vintageAnimations$animationContainer;
    @Unique
    private int vintageAnimations$ctr = 0;
    @Unique
    private boolean vintageAnimations$switchedMainHandLeft = false;
    @Unique
    private boolean vintageAnimations$switchedMainHandRight = true;

    @Inject(method={"swing(Lnet/minecraft/world/InteractionHand;)V"}, at={@At(value="HEAD")})
    private void playAnimation(class_1268 interactionHand, CallbackInfo ci) {
        class_1309 player = (class_1309)this;
        if (player instanceof class_1657 && player.method_37908().method_8608()) {
            class_1799 itemStack = player.method_5998(interactionHand);
            if (itemStack.method_31573(class_3489.field_42612) && VintageAnimations.config.chopAnimation) {
                this.playAnim(player, "chop");
            } else if (itemStack.method_31573(class_3489.field_42614) && VintageAnimations.config.pickAnimation) {
                this.playAnim(player, "pick");
            } else if (itemStack.method_31573(class_3489.field_42615) && VintageAnimations.config.digAnimation) {
                this.playAnim(player, "dig");
            } else if (itemStack.method_31573(class_3489.field_42613) && VintageAnimations.config.tillAnimation) {
                this.playAnim(player, "till");
            }
        }
    }

    @Inject(method={"getAttackAnim"}, at={@At(value="RETURN")}, cancellable=true)
    private void cancelVanillaAttackAnim(float f, CallbackInfoReturnable<Float> cir) {
        class_1309 player = (class_1309)this;
        if (player instanceof class_1657 && player.method_37908().method_8608() && this.vintageAnimations$animationContainer != null && this.vintageAnimations$animationContainer.getAnimation() != null && this.vintageAnimations$animationContainer.getAnimation().isActive()) {
            cir.setReturnValue((Object)Float.valueOf(0.0f));
        }
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void incrCtr(CallbackInfo ci) {
        class_1309 player = (class_1309)this;
        if (player instanceof class_1657 && player.method_37908().method_8608()) {
            if (this.vintageAnimations$animationContainer != null) {
                boolean vintageAnimations$mainHandLeft = ((class_1306)class_310.method_1551().field_1690.method_42552().method_41753()).equals((Object)class_1306.field_6182);
                if (vintageAnimations$mainHandLeft && !this.vintageAnimations$switchedMainHandLeft) {
                    this.vintageAnimations$animationContainer.addModifier((AbstractModifier)new MirrorModifier(true), 0);
                    this.vintageAnimations$switchedMainHandLeft = true;
                    this.vintageAnimations$switchedMainHandRight = false;
                } else if (!vintageAnimations$mainHandLeft && !this.vintageAnimations$switchedMainHandRight) {
                    this.vintageAnimations$animationContainer.removeModifier(0);
                    this.vintageAnimations$switchedMainHandRight = true;
                    this.vintageAnimations$switchedMainHandLeft = false;
                }
            }
            ++this.vintageAnimations$ctr;
            if (this.vintageAnimations$ctr >= 10000) {
                this.vintageAnimations$ctr = 0;
            }
        }
    }

    private void playAnim(class_1309 player, String animName) {
        KeyframeAnimation anim = PlayerAnimationRegistry.getAnimation((class_2960)new class_2960("vintage_animations", animName));
        KeyframeAnimationPlayer animPlayer = new KeyframeAnimationPlayer(anim).setFirstPersonConfiguration(new FirstPersonConfiguration(VintageAnimations.config.showArmsInFirstPerson, VintageAnimations.config.showArmsInFirstPerson && VintageAnimations.config.showOffHandInFirstPerson, true, VintageAnimations.config.showOffHandInFirstPerson));
        animPlayer.setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL);
        this.compatCheck(animPlayer);
        this.vintageAnimations$animationContainer = ((IAnimatedPlayer)player).vintage_animations_getModAnimation();
        if (this.vintageAnimations$ctr >= anim.endTick) {
            this.vintageAnimations$animationContainer.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)5, (Ease)Ease.INOUTEXPO), (IAnimation)animPlayer, true);
            this.vintageAnimations$ctr = 0;
        }
    }

    private void compatCheck(KeyframeAnimationPlayer animPlayer) {
        if (Platform.isModLoaded((String)"firstperson")) {
            new FirstPersonModelCompat(animPlayer);
        }
        if (Platform.isModLoaded((String)"realcamera")) {
            animPlayer.setFirstPersonMode(FirstPersonMode.DISABLED);
        }
    }
}

