/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.handler;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.BreakBlockEvent;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.littlejoys.LittleJoysConfig;
import net.blay09.mods.littlejoys.handler.GoldRushInstance;
import net.blay09.mods.littlejoys.network.protocol.ClientboundGoldRushPacket;
import net.blay09.mods.littlejoys.recipe.GoldRushRecipe;
import net.blay09.mods.littlejoys.recipe.ModRecipeTypes;
import net.blay09.mods.littlejoys.recipe.condition.EventContextImpl;
import net.blay09.mods.littlejoys.stats.ModStats;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1863;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6011;
import net.minecraft.class_8567;

public class GoldRushHandler {
    private static final class_5819 random = class_5819.method_43047();
    private static final Table<class_5321<class_1937>, class_2338, GoldRushInstance> activeGoldRushes = HashBasedTable.create();

    public static void initialize() {
        Balm.getEvents().onEvent(BreakBlockEvent.class, event -> {
            Optional<GoldRushRecipe> optRecipe;
            if (event.getPlayer().method_31549().field_7477) {
                return;
            }
            if (class_1890.method_49189((class_1799)event.getPlayer().method_6047())) {
                return;
            }
            class_1937 level = event.getLevel();
            if (!(level instanceof class_3218)) {
                return;
            }
            class_3218 serverLevel = (class_3218)level;
            GoldRushInstance activeGoldRush = (GoldRushInstance)activeGoldRushes.get((Object)level.method_27983(), (Object)event.getPos());
            if (activeGoldRush == null && (optRecipe = GoldRushHandler.findRecipe(serverLevel, event.getPos(), event.getState())).isPresent()) {
                GoldRushRecipe recipe = optRecipe.get();
                activeGoldRush = new GoldRushInstance(event.getPos(), event.getState(), recipe.lootTable(), (int)Math.floor(20.0f * recipe.seconds()), recipe.maxDropsPerSecond() == -1.0f ? 0 : (int)Math.floor(20.0f / recipe.maxDropsPerSecond()));
                Balm.getNetworking().sendToTracking((class_3218)level, event.getPos(), (Object)new ClientboundGoldRushPacket(event.getPos(), true));
                event.getPlayer().method_7281(ModStats.goldRushesTriggered);
                activeGoldRushes.put((Object)level.method_27983(), (Object)event.getPos(), (Object)activeGoldRush);
            }
            if (activeGoldRush != null) {
                if (activeGoldRush.getDropCooldownTicks() <= 0) {
                    class_2338 pos = activeGoldRush.getPos();
                    class_8567.class_8568 lootParamsBuilder = new class_8567.class_8568((class_3218)level).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)pos)).method_51874(class_181.field_1229, (Object)class_1799.field_8037).method_51877(class_181.field_1228, (Object)level.method_8321(pos));
                    class_2960 lootTableId = activeGoldRush.getLootTable();
                    if (lootTableId != class_39.field_844) {
                        class_8567 lootParams = lootParamsBuilder.method_51874(class_181.field_1224, (Object)level.method_8320(pos)).method_51875(class_173.field_1172);
                        class_52 lootTable = level.method_8503().method_3857().getLootTable(lootTableId);
                        lootTable.method_51878(lootParams).forEach(itemStack -> class_2248.method_9577((class_1937)level, (class_2338)pos, (class_1799)itemStack));
                    }
                    activeGoldRush.setDropCooldownTicks(activeGoldRush.getTicksPerDrop());
                }
                event.setCanceled(true);
            }
        });
        Balm.getEvents().onTickEvent(TickType.ServerLevel, TickPhase.Start, level -> {
            for (GoldRushInstance goldRush : activeGoldRushes.row((Object)level.method_27983()).values()) {
                goldRush.setTicksPassed(goldRush.getTicksPassed() + 1);
                goldRush.setDropCooldownTicks(goldRush.getDropCooldownTicks() - 1);
                if (goldRush.getTicksPassed() < goldRush.getMaxTicks()) continue;
                if (level.method_8320(goldRush.getPos()).equals(goldRush.getInitialState())) {
                    level.method_22352(goldRush.getPos(), true);
                }
                Balm.getNetworking().sendToTracking((class_3218)level, goldRush.getPos(), (Object)new ClientboundGoldRushPacket(goldRush.getPos(), false));
            }
            activeGoldRushes.values().removeIf(it -> it.getTicksPassed() >= it.getMaxTicks());
        });
    }

    private static Optional<GoldRushRecipe> findRecipe(class_3218 level, class_2338 pos, class_2680 state) {
        class_1863 recipeManager = level.method_8433();
        List recipes = recipeManager.method_30027(ModRecipeTypes.goldRushRecipeType);
        ArrayList<GoldRushRecipe> candidates = new ArrayList<GoldRushRecipe>();
        float baseChance = LittleJoysConfig.getActive().goldRush.baseChance;
        float roll = random.method_43057();
        for (GoldRushRecipe recipe : recipes) {
            if (!GoldRushHandler.isValidRecipeFor(recipe, level, pos, state) || !(roll <= baseChance * recipe.chanceMultiplier())) continue;
            candidates.add(recipe);
        }
        return class_6011.method_34986((class_5819)random, candidates);
    }

    private static boolean isValidRecipeFor(GoldRushRecipe recipe, class_3218 level, class_2338 pos, class_2680 state) {
        EventContextImpl context = new EventContextImpl((class_1937)level, pos, state);
        return recipe.eventCondition().test(context);
    }
}

