/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.bloodmoon.procedures;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.mcreator.bloodmoon.network.BloodmoonModVariables;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.DimensionSpecialEffectsManager;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ComputeLightColorBloodmoonProcedure {
    private static float skyLevel = 0.0f;
    private static float blockLevel = 0.0f;
    private static Vector3f skyColor = null;
    private static Vector3f blockColor = null;
    private static final Consumer<Object[]> CONSUMER = params -> {
        int pixelX = (Integer)params[5];
        int pixelY = (Integer)params[6];
        if (pixelX == 0 && pixelY == 0) {
            Minecraft minecraft = Minecraft.m_91087_();
            Entity entity = minecraft.f_91063_.m_109153_().m_90592_();
            if (entity != null) {
                ClientLevel level = minecraft.f_91073_;
                float partialTick = ((Float)params[1]).floatValue();
                Vec3 pos = entity.m_20318_(partialTick);
                ComputeLightColorBloodmoonProcedure.execute(null, (LevelAccessor)level);
            }
        }
        ComputeLightColorBloodmoonProcedure.calculateColor((Vector3f)params[7], pixelX, pixelY);
    };

    private static float calculateBaseLevel(float level) {
        return level * level * (level * -2.0f + 3.0f);
    }

    private static void calculateColor(Vector3f lightColor, int pixelX, int pixelY) {
        if (pixelX == pixelY) {
            return;
        }
        if (pixelX > pixelY) {
            if (blockColor == null) {
                return;
            }
            if (blockLevel == 0.0f) {
                return;
            }
            float level = Math.abs(ComputeLightColorBloodmoonProcedure.calculateBaseLevel((float)pixelX / 15.0f) - ComputeLightColorBloodmoonProcedure.calculateBaseLevel((float)pixelY / 15.0f)) * blockLevel;
            lightColor.set(Mth.m_14036_((float)Mth.m_14179_((float)level, (float)lightColor.x(), (float)blockColor.x()), (float)0.0f, (float)1.0f), Mth.m_14036_((float)Mth.m_14179_((float)level, (float)lightColor.y(), (float)blockColor.y()), (float)0.0f, (float)1.0f), Mth.m_14036_((float)Mth.m_14179_((float)level, (float)lightColor.z(), (float)blockColor.z()), (float)0.0f, (float)1.0f));
        } else {
            if (skyColor == null) {
                return;
            }
            if (skyLevel == 0.0f) {
                return;
            }
            float level = (float)Math.abs(pixelX - pixelY) / 15.0f * skyLevel;
            lightColor.set(Mth.m_14036_((float)Mth.m_14179_((float)level, (float)lightColor.x(), (float)skyColor.x()), (float)0.0f, (float)1.0f), Mth.m_14036_((float)Mth.m_14179_((float)level, (float)lightColor.y(), (float)skyColor.y()), (float)0.0f, (float)1.0f), Mth.m_14036_((float)Mth.m_14179_((float)level, (float)lightColor.z(), (float)skyColor.z()), (float)0.0f, (float)1.0f));
        }
    }

    public static void setBlockColor(int blockColor) {
        ComputeLightColorBloodmoonProcedure.setBlockColor(1.0f, blockColor);
    }

    public static void setBlockColor(float level, int blockColor) {
        blockLevel = Mth.m_14036_((float)level, (float)0.0f, (float)1.0f);
        ComputeLightColorBloodmoonProcedure.blockColor = new Vector3f((float)(blockColor >> 16 & 0xFF) / 255.0f, (float)(blockColor >> 8 & 0xFF) / 255.0f, (float)(blockColor & 0xFF) / 255.0f);
    }

    public static void setSkyColor(int skyColor) {
        ComputeLightColorBloodmoonProcedure.setSkyColor(1.0f, skyColor);
    }

    public static void setSkyColor(float level, int skyColor) {
        skyLevel = Mth.m_14036_((float)level, (float)0.0f, (float)1.0f);
        ComputeLightColorBloodmoonProcedure.skyColor = new Vector3f((float)(skyColor >> 16 & 0xFF) / 255.0f, (float)(skyColor >> 8 & 0xFF) / 255.0f, (float)(skyColor & 0xFF) / 255.0f);
    }

    @SubscribeEvent
    public static void lightColorSetup(FMLClientSetupEvent event) {
        try {
            Field field = DimensionSpecialEffectsManager.class.getDeclaredField("EFFECTS");
            field.setAccessible(true);
            for (DimensionSpecialEffects dimensionSpecialEffects : ((ImmutableMap)field.get(null)).values()) {
                Class<?> effects = dimensionSpecialEffects.getClass();
                ((Set)effects.getField("CUSTOM_LIGHTS").get(null)).add(CONSUMER);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void execute(LevelAccessor world) {
        ComputeLightColorBloodmoonProcedure.execute(null, world);
    }

    private static void execute(@Nullable Event event, LevelAccessor world) {
        if (BloodmoonModVariables.MapVariables.get((LevelAccessor)world).bloodmoonActive) {
            ComputeLightColorBloodmoonProcedure.setSkyColor(0.5f, -3657166);
        }
    }
}

