/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus;

import com.bigdious.risus.client.RisusClientEvents;
import com.bigdious.risus.compat.curios.CuriosCompat;
import com.bigdious.risus.data.BannerPatternTagGenerator;
import com.bigdious.risus.data.BiomeTagsGenerator;
import com.bigdious.risus.data.BlockModelGenerator;
import com.bigdious.risus.data.BlockTagGenerator;
import com.bigdious.risus.data.CraftingGenerator;
import com.bigdious.risus.data.DamageTypeTagGenerator;
import com.bigdious.risus.data.DataMapGenerator;
import com.bigdious.risus.data.EnchantmentTagGenerator;
import com.bigdious.risus.data.EntityTagGenerator;
import com.bigdious.risus.data.FluidTagGenerator;
import com.bigdious.risus.data.ItemModelGenerator;
import com.bigdious.risus.data.ItemTagGenerator;
import com.bigdious.risus.data.LangGenerator;
import com.bigdious.risus.data.LootGenerator;
import com.bigdious.risus.data.ParticleGenerator;
import com.bigdious.risus.data.RegistryDataGenerator;
import com.bigdious.risus.data.RisusAdvancementProvider;
import com.bigdious.risus.data.SoundDefinitionGenerator;
import com.bigdious.risus.data.SpriteReferenceGenerator;
import com.bigdious.risus.data.StructureUpdater;
import com.bigdious.risus.event.RisusEvents;
import com.bigdious.risus.init.RisusAdvancements;
import com.bigdious.risus.init.RisusArmorMaterials;
import com.bigdious.risus.init.RisusBlockEntities;
import com.bigdious.risus.init.RisusBlocks;
import com.bigdious.risus.init.RisusDataAttachments;
import com.bigdious.risus.init.RisusDataComponents;
import com.bigdious.risus.init.RisusDataMaps;
import com.bigdious.risus.init.RisusEntities;
import com.bigdious.risus.init.RisusFluids;
import com.bigdious.risus.init.RisusItems;
import com.bigdious.risus.init.RisusMenuType;
import com.bigdious.risus.init.RisusMobEffects;
import com.bigdious.risus.init.RisusParticles;
import com.bigdious.risus.init.RisusPotions;
import com.bigdious.risus.init.RisusRecipes;
import com.bigdious.risus.init.RisusSoundEvents;
import com.bigdious.risus.init.RisusStructures;
import com.bigdious.risus.init.RisusTab;
import com.bigdious.risus.network.CreateCritParticlePacket;
import com.bigdious.risus.network.OpenBookPacket;
import com.bigdious.risus.network.UnyieldingTotemPacket;
import com.google.common.base.Suppliers;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.BlockEntityTypeAddBlocksEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="risus")
public class Risus {
    public static final String MODID = "risus";
    public static final Supplier<GameRules.Key<GameRules.BooleanValue>> HOLDERS_STEAL_FROM_MONSTERS = Suppliers.memoize(() -> GameRules.register((String)"holdersStealFromMonsters", (GameRules.Category)GameRules.Category.MOBS, (GameRules.Type)GameRules.BooleanValue.create((boolean)false)));
    public static final Supplier<GameRules.Key<GameRules.BooleanValue>> ILLEGAL_LITTERS = Suppliers.memoize(() -> GameRules.register((String)"illegalLitters", (GameRules.Category)GameRules.Category.MOBS, (GameRules.Type)GameRules.BooleanValue.create((boolean)false)));
    public static final Logger LOGGER = LogManager.getLogger();

    public Risus(IEventBus bus, Dist dist) {
        Util.backgroundExecutor().execute(HOLDERS_STEAL_FROM_MONSTERS::get);
        Util.backgroundExecutor().execute(ILLEGAL_LITTERS::get);
        RisusBlockEntities.BLOCK_ENTITIES.register(bus);
        RisusBlocks.BLOCKS.register(bus);
        RisusDataAttachments.ATTACHMENT_TYPES.register(bus);
        RisusArmorMaterials.ARMOR_MATERIALS.register(bus);
        RisusEntities.ENTITIES.register(bus);
        RisusItems.ITEMS.register(bus);
        RisusMobEffects.MOB_EFFECTS.register(bus);
        RisusMenuType.MENU_TYPES.register(bus);
        RisusParticles.PARTICLES.register(bus);
        RisusRecipes.RECIPE_SERIALIZERS.register(bus);
        RisusRecipes.RECIPE_TYPES.register(bus);
        RisusPotions.POTIONS.register(bus);
        RisusEntities.SPAWN_EGGS.register(bus);
        RisusTab.CREATIVE_TABS.register(bus);
        RisusSoundEvents.SOUNDS.register(bus);
        RisusFluids.FLUIDS.register(bus);
        RisusFluids.FLUID_TYPES.register(bus);
        RisusStructures.STRUCTURES.register(bus);
        RisusDataComponents.COMPONENTS.register(bus);
        RisusAdvancements.TRIGGERS.register(bus);
        if (ModList.get().isLoaded("curios")) {
            Risus.loadCuriosCompat(bus);
        }
        bus.addListener(this::registerPackets);
        bus.addListener(this::registerTypes);
        bus.addListener(this::gatherData);
        bus.addListener(RegisterDataMapTypesEvent.class, event -> event.register(RisusDataMaps.LOVER_CONVERSION));
        RisusEvents.initEvents(bus);
        if (dist.isClient()) {
            RisusClientEvents.initEvents(bus);
        }
    }

    public void registerPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID).versioned("1.0.0").optional();
        registrar.playToClient(CreateCritParticlePacket.TYPE, CreateCritParticlePacket.STREAM_CODEC, CreateCritParticlePacket::handle);
        registrar.playToClient(UnyieldingTotemPacket.TYPE, UnyieldingTotemPacket.STREAM_CODEC, UnyieldingTotemPacket::handle);
        registrar.playToServer(OpenBookPacket.TYPE, OpenBookPacket.STREAM_CODEC, (payload, context) -> OpenBookPacket.handle(context));
    }

    public void registerTypes(BlockEntityTypeAddBlocksEvent event) {
        event.modify(BlockEntityType.MOB_SPAWNER, new Block[]{(Block)RisusBlocks.FLESHY_SPAWNER.get()});
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        RegistryDataGenerator datapackProvider = new RegistryDataGenerator(packOutput, event.getLookupProvider());
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        boolean isClient = event.includeClient();
        generator.addProvider(isClient, (DataProvider)new BlockModelGenerator(packOutput, existingFileHelper));
        generator.addProvider(isClient, (DataProvider)new ItemModelGenerator(packOutput, existingFileHelper));
        generator.addProvider(isClient, (DataProvider)new ParticleGenerator(packOutput, existingFileHelper));
        generator.addProvider(isClient, (DataProvider)new SoundDefinitionGenerator(packOutput, existingFileHelper));
        generator.addProvider(isClient, (DataProvider)new SpriteReferenceGenerator(packOutput, event.getLookupProvider(), existingFileHelper));
        generator.addProvider(isClient, (DataProvider)new LangGenerator(packOutput));
        boolean isServer = event.includeServer();
        RegistryDataGenerator registryDataGenerator = new RegistryDataGenerator(packOutput, datapackProvider.getRegistryProvider());
        CompletableFuture lookupProvider = registryDataGenerator.getRegistryProvider();
        generator.addProvider(isServer, (DataProvider)registryDataGenerator);
        generator.addProvider(isServer, (DataProvider)new RisusAdvancementProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(isServer, (DataProvider)new StructureUpdater("structures", packOutput, existingFileHelper));
        generator.addProvider(isServer, (DataProvider)new LootGenerator(packOutput, lookupProvider));
        generator.addProvider(isServer, (DataProvider)new CraftingGenerator(packOutput, lookupProvider));
        generator.addProvider(isServer, (DataProvider)new DataMapGenerator(packOutput, lookupProvider));
        BlockTagGenerator blocktags = new BlockTagGenerator(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(isServer, (DataProvider)blocktags);
        generator.addProvider(isServer, (DataProvider)new BannerPatternTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(isServer, (DataProvider)new BiomeTagsGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(isServer, (DataProvider)new DamageTypeTagGenerator(packOutput, registryDataGenerator.getRegistryProvider(), existingFileHelper));
        generator.addProvider(isServer, (DataProvider)new EnchantmentTagGenerator(packOutput, registryDataGenerator.getRegistryProvider(), existingFileHelper));
        generator.addProvider(isServer, (DataProvider)new EntityTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(isServer, (DataProvider)new FluidTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(isServer, (DataProvider)new ItemTagGenerator(packOutput, lookupProvider, blocktags.contentsGetter(), existingFileHelper));
    }

    private static void loadCuriosCompat(IEventBus bus) {
        bus.addListener(CuriosCompat::registerCuriosCapabilities);
    }

    public static ResourceLocation prefix(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name.toLowerCase(Locale.ROOT));
    }
}

