/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class ActuallyUseableDirectionalBlock
extends DirectionalBlock {
    final MapCodec<ActuallyUseableDirectionalBlock> CODEC = ActuallyUseableDirectionalBlock.simpleCodec(ActuallyUseableDirectionalBlock::new);

    public ActuallyUseableDirectionalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.UP));
    }

    protected MapCodec<? extends ActuallyUseableDirectionalBlock> codec() {
        return this.CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction clicked = context.getClickedFace();
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)clicked);
        if (this.canSurvive(state, (LevelReader)context.getLevel(), context.getClickedPos())) {
            return state;
        }
        for (Direction dir : context.getNearestLookingDirections()) {
            state = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)dir.getOpposite());
            if (!this.canSurvive(state, (LevelReader)context.getLevel(), context.getClickedPos())) continue;
            return state;
        }
        return null;
    }

    protected BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState pState, Mirror mirror) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)mirror.mirror((Direction)pState.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }
}

