/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks;

import com.bigdious.risus.blocks.interfaces.SimpleMultiloggedBlock;
import com.bigdious.risus.init.RisusBlocks;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class BloodweaveBlock
extends PipeBlock
implements SimpleMultiloggedBlock {
    public static final MapCodec<BloodweaveBlock> CODEC = BloodweaveBlock.simpleCodec(BloodweaveBlock::new);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final EnumProperty<SimpleMultiloggedBlock.MultiloggingEnum> FLUIDLOGGED = SimpleMultiloggedBlock.MultiloggingEnum.FLUIDLOGGED;

    public BloodweaveBlock(BlockBehaviour.Properties properties) {
        super(0.3125f, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue(AXIS, (Comparable)Direction.Axis.Y)).setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.EMPTY)));
    }

    protected MapCodec<? extends PipeBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, AXIS, FLUIDLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)pContext.getClickedFace().getAxis())).setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.getFromFluid(fluidstate.getType())));
    }

    public FluidState getFluidState(BlockState state) {
        return ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().defaultFluidState();
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        boolean flag = neighborState.is((Block)this);
        if (state.getValue(FLUIDLOGGED) != SimpleMultiloggedBlock.MultiloggingEnum.EMPTY) {
            accessor.scheduleTick(pos, ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid(), ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().getTickDelay((LevelReader)accessor));
        }
        return (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(flag));
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        entity.makeStuckInBlock(state, new Vec3(0.65, 0.75, 0.65));
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)BloodweaveBlock.rotatePillar(state, rot).setValue((Property)PROPERTY_BY_DIRECTION.get(rot.rotate(Direction.NORTH)), (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)PROPERTY_BY_DIRECTION.get(rot.rotate(Direction.SOUTH)), (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)PROPERTY_BY_DIRECTION.get(rot.rotate(Direction.EAST)), (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)PROPERTY_BY_DIRECTION.get(rot.rotate(Direction.WEST)), (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)PROPERTY_BY_DIRECTION.get(rot.rotate(Direction.UP)), (Comparable)((Boolean)state.getValue((Property)UP)))).setValue((Property)PROPERTY_BY_DIRECTION.get(rot.rotate(Direction.DOWN)), (Comparable)((Boolean)state.getValue((Property)DOWN)));
    }

    public static BlockState rotatePillar(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.getValue(AXIS)) {
                    case X: {
                        yield (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        yield (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(mirror.mirror(Direction.NORTH)), (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)PROPERTY_BY_DIRECTION.get(mirror.mirror(Direction.SOUTH)), (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)PROPERTY_BY_DIRECTION.get(mirror.mirror(Direction.EAST)), (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)PROPERTY_BY_DIRECTION.get(mirror.mirror(Direction.WEST)), (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)PROPERTY_BY_DIRECTION.get(mirror.mirror(Direction.UP)), (Comparable)((Boolean)state.getValue((Property)UP)))).setValue((Property)PROPERTY_BY_DIRECTION.get(mirror.mirror(Direction.DOWN)), (Comparable)((Boolean)state.getValue((Property)DOWN)));
    }

    public boolean isStickyBlock(BlockState state) {
        return true;
    }

    public boolean canStickTo(BlockState state, BlockState other) {
        return other.is(RisusBlocks.BLOODWEAVE);
    }
}

