/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks;

import com.bigdious.risus.init.RisusBlocks;
import com.bigdious.risus.init.RisusMobEffects;
import com.bigdious.risus.init.RisusParticles;
import com.bigdious.risus.init.RisusTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoulFireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class JoyflameFireBlock
extends SoulFireBlock {
    public JoyflameFireBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return JoyflameFireBlock.canSurviveOnBlock(context.getLevel().getBlockState(context.getClickedPos().below())) ? ((Block)RisusBlocks.JOYFLAME_FIRE.get()).defaultBlockState() : Blocks.AIR.defaultBlockState();
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor accessor, BlockPos pos, BlockPos newPos) {
        return this.canSurvive(state, (LevelReader)accessor, pos) ? this.defaultBlockState() : Blocks.AIR.defaultBlockState();
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        block12: {
            block11: {
                BlockPos blockpos;
                BlockState blockstate;
                if (pRandom.nextInt(24) == 0) {
                    pLevel.playLocalSound((double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 1.0f + pRandom.nextFloat(), pRandom.nextFloat() * 0.7f + 0.3f, false);
                }
                if (this.canBurn(blockstate = pLevel.getBlockState(blockpos = pPos.below())) || blockstate.isFaceSturdy((BlockGetter)pLevel, blockpos, Direction.UP)) break block11;
                if (this.canBurn(pLevel.getBlockState(pPos.west()))) {
                    for (int j = 0; j < 2; ++j) {
                        double d3 = (double)pPos.getX() + pRandom.nextDouble() * (double)0.1f;
                        double d8 = (double)pPos.getY() + pRandom.nextDouble();
                        double d13 = (double)pPos.getZ() + pRandom.nextDouble();
                        pLevel.addParticle((ParticleOptions)RisusParticles.FIERY_ORGANIC_PARTICLE.get(), d3, d8, d13, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canBurn(pLevel.getBlockState(pPos.east()))) {
                    for (int k = 0; k < 2; ++k) {
                        double d4 = (double)(pPos.getX() + 1) - pRandom.nextDouble() * (double)0.1f;
                        double d9 = (double)pPos.getY() + pRandom.nextDouble();
                        double d14 = (double)pPos.getZ() + pRandom.nextDouble();
                        pLevel.addParticle((ParticleOptions)RisusParticles.FIERY_ORGANIC_PARTICLE.get(), d4, d9, d14, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canBurn(pLevel.getBlockState(pPos.north()))) {
                    for (int l = 0; l < 2; ++l) {
                        double d5 = (double)pPos.getX() + pRandom.nextDouble();
                        double d10 = (double)pPos.getY() + pRandom.nextDouble();
                        double d15 = (double)pPos.getZ() + pRandom.nextDouble() * (double)0.1f;
                        pLevel.addParticle((ParticleOptions)RisusParticles.FIERY_ORGANIC_PARTICLE.get(), d5, d10, d15, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canBurn(pLevel.getBlockState(pPos.south()))) {
                    for (int i1 = 0; i1 < 2; ++i1) {
                        double d6 = (double)pPos.getX() + pRandom.nextDouble();
                        double d11 = (double)pPos.getY() + pRandom.nextDouble();
                        double d16 = (double)(pPos.getZ() + 1) - pRandom.nextDouble() * (double)0.1f;
                        pLevel.addParticle((ParticleOptions)RisusParticles.FIERY_ORGANIC_PARTICLE.get(), d6, d11, d16, 0.0, 0.0, 0.0);
                    }
                }
                if (!this.canBurn(pLevel.getBlockState(pPos.above()))) break block12;
                for (int j1 = 0; j1 < 2; ++j1) {
                    double d7 = (double)pPos.getX() + pRandom.nextDouble();
                    double d12 = (double)(pPos.getY() + 1) - pRandom.nextDouble() * (double)0.1f;
                    double d17 = (double)pPos.getZ() + pRandom.nextDouble();
                    pLevel.addParticle((ParticleOptions)RisusParticles.FIERY_ORGANIC_PARTICLE.get(), d7, d12, d17, 0.0, 0.0, 0.0);
                }
                break block12;
            }
            for (int i = 0; i < 3; ++i) {
                double d0 = (double)pPos.getX() + pRandom.nextDouble();
                double d1 = (double)pPos.getY() + pRandom.nextDouble() * 0.5 + 0.5;
                double d2 = (double)pPos.getZ() + pRandom.nextDouble();
                pLevel.addParticle((ParticleOptions)RisusParticles.FIERY_ORGANIC_PARTICLE.get(), d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        return JoyflameFireBlock.canSurviveOnBlock(reader.getBlockState(pos.below()));
    }

    public static boolean canSurviveOnBlock(BlockState state) {
        return state.is(RisusTags.Blocks.JOYFLAME_FIRE_BASE_BLOCKS);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        LivingEntity living;
        if (!level.isClientSide() && entity instanceof LivingEntity && (living = (LivingEntity)entity).isAlive() && (living.tickCount % 100 == 0 || !living.hasEffect(RisusMobEffects.EXBURN))) {
            living.addEffect(new MobEffectInstance(RisusMobEffects.EXBURN, 600, 0, false, false, true));
        }
    }
}

