/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MirageBlock
extends Block {
    private final Block mimickedBlock;
    private static final VoxelShape FALLING_COLLISION_SHAPE = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.9f, (double)1.0);

    public MirageBlock(BlockBehaviour.Properties properties, Block mimickedBlock) {
        super(properties);
        this.mimickedBlock = mimickedBlock;
    }

    public Block getMimickedBlock() {
        return this.mimickedBlock;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collision) {
        EntityCollisionContext entitycollisioncontext;
        Entity entity;
        if (collision instanceof EntityCollisionContext && (entity = (entitycollisioncontext = (EntityCollisionContext)collision).getEntity()) != null) {
            if (entity.fallDistance > 2.5f) {
                return FALLING_COLLISION_SHAPE;
            }
            boolean flag = entity instanceof FallingBlockEntity;
            if (flag || MirageBlock.canEntityWalkOnPowderSnow(entity) && collision.isAbove(Shapes.block(), pos, false) && !collision.isDescending()) {
                return super.getCollisionShape(state, getter, pos, collision);
            }
        }
        return Shapes.empty();
    }

    public static boolean canEntityWalkOnPowderSnow(Entity entity) {
        LivingEntity living;
        if (entity.getType().is(EntityTypeTags.POWDER_SNOW_WALKABLE_MOBS)) {
            return true;
        }
        return entity instanceof LivingEntity && (living = (LivingEntity)entity).getItemBySlot(EquipmentSlot.FEET).canWalkOnPowderedSnow(living);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter getter, BlockPos pos) {
        return true;
    }

    public boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return true;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this.mimickedBlock.asItem());
    }
}

