/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks;

import com.bigdious.risus.blocks.interfaces.SimpleMultiloggedBlock;
import com.bigdious.risus.init.RisusSoundEvents;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LlamaSpit;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ZitBlock
extends DirectionalBlock
implements SimpleMultiloggedBlock {
    public static final MapCodec<ZitBlock> CODEC = ZitBlock.simpleCodec(ZitBlock::new);
    public static final BooleanProperty POPPED = BooleanProperty.create((String)"popped");
    public static final EnumProperty<SimpleMultiloggedBlock.MultiloggingEnum> FLUIDLOGGED = SimpleMultiloggedBlock.MultiloggingEnum.FLUIDLOGGED;
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.UP, (Object)Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0), (Object)Direction.DOWN, (Object)Block.box((double)5.0, (double)15.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)5.0, (double)5.0, (double)1.0, (double)11.0, (double)11.0), (Object)Direction.WEST, (Object)Block.box((double)15.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), (Object)Direction.NORTH, (Object)Block.box((double)5.0, (double)5.0, (double)15.0, (double)11.0, (double)11.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)1.0)));

    public ZitBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POPPED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.EMPTY)));
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return AABBS.get(state.getValue((Property)FACING));
    }

    protected boolean hasNeighborSignal(Level level, BlockPos pos, BlockState state) {
        Direction direction = ((Direction)state.getValue((Property)FACING)).getOpposite();
        return level.hasSignal(pos.relative(direction), direction);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos newPos, boolean moving) {
        if (!((Boolean)state.getValue((Property)POPPED)).booleanValue() && this.hasNeighborSignal(level, pos, state)) {
            this.pop(level, state, pos);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POPPED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockpos = pos.relative(direction.getOpposite());
        return reader.getBlockState(blockpos).isFaceSturdy((BlockGetter)reader, blockpos, direction);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getClickedFace())).setValue((Property)POPPED, (Comparable)Boolean.valueOf(false))).setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.getFromFluid(fluidstate.getType())));
    }

    public FluidState getFluidState(BlockState state) {
        return ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().defaultFluidState();
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        if (state.getValue(FLUIDLOGGED) != SimpleMultiloggedBlock.MultiloggingEnum.EMPTY) {
            accessor.scheduleTick(pos, ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid(), ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().getTickDelay((LevelReader)accessor));
        }
        return direction == ((Direction)state.getValue((Property)FACING)).getOpposite() && !state.canSurvive((LevelReader)accessor, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, accessor, pos, neighborPos);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (!((Boolean)state.getValue((Property)POPPED)).booleanValue()) {
            this.pop(level, state, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity pEntity) {
        if (!((Boolean)state.getValue((Property)POPPED)).booleanValue() && this.hasNeighborSignal(level, pos, state)) {
            this.pop(level, state, pos);
        }
    }

    private void pop(Level level, BlockState state, BlockPos pos) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        LlamaSpit spit = new LlamaSpit(EntityType.LLAMA_SPIT, level);
        spit.setPos(Vec3.atCenterOf((Vec3i)pos));
        spit.shoot((double)dir.getStepX() * 10.0, (double)dir.getStepY() * 10.0, (double)dir.getStepZ() * 10.0, 1.5f, 11.0f);
        level.addFreshEntity((Entity)spit);
        level.playSound(null, pos, (SoundEvent)RisusSoundEvents.ZIT_POP.get(), SoundSource.BLOCKS, 1.0f, 1.0f + (level.getRandom().nextFloat() - level.getRandom().nextFloat()) * 0.2f);
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POPPED, (Comparable)Boolean.valueOf(true)));
        level.scheduleTick(pos, (Block)this, 60);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter getter, BlockPos pos) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POPPED, FLUIDLOGGED});
    }
}

