/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks.entity;

import com.bigdious.risus.client.particle.AlterationParticleOptions;
import com.bigdious.risus.init.RisusBlockEntities;
import com.bigdious.risus.init.RisusParticles;
import com.bigdious.risus.init.RisusRecipes;
import com.bigdious.risus.inventory.recipe.AlterationRecipe;
import com.mojang.serialization.DynamicOps;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.ContainerSingleItem;
import org.jetbrains.annotations.Nullable;

public class AlterationCatalystBlockEntity
extends BlockEntity
implements WorldlyContainer,
ContainerSingleItem.BlockContainerSingleItem {
    protected ItemStack item = ItemStack.EMPTY;
    public boolean isCrafting;
    private int craftingCounter = 1;
    public float rotationDegrees;
    private boolean finishedCrafting;
    private int finishedCounter;

    public AlterationCatalystBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RisusBlockEntities.ALTERATION_CATALYST.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AlterationCatalystBlockEntity te) {
        int craftingLength = 100;
        if (te.isCrafting) {
            if (te.getRecipe(level, te.item) == null) {
                te.isCrafting = false;
                te.setChanged();
            }
            ++te.craftingCounter;
        }
        if (level.isClientSide() && te.craftingCounter > 1 && te.craftingCounter < 60) {
            RandomSource random = level.getRandom();
            BlockPos randomPos = pos.offset(Mth.floor((float)(random.nextFloat() * 2.0f * (random.nextBoolean() ? 1.0f : -1.0f))), 2, Mth.floor((float)(random.nextFloat() * 2.0f * (random.nextBoolean() ? 1.0f : -1.0f))));
            double d0 = Mth.sin((float)((float)(te.craftingCounter + 35) * 0.1f)) / 2.0f + 0.5f;
            d0 = (d0 * d0 + d0) * (double)0.3f;
            Vec3 vec3 = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 2.0 + d0, (double)pos.getZ() + 0.5);
            BlockPos blockpos1 = randomPos.subtract((Vec3i)pos);
            float f = -0.5f + random.nextFloat() + (float)blockpos1.getX();
            float f1 = -2.0f + random.nextFloat() + (float)blockpos1.getY();
            float f2 = -0.5f + random.nextFloat() + (float)blockpos1.getZ();
            level.addParticle((ParticleOptions)AlterationParticleOptions.ALTERATION_FADE, vec3.x(), vec3.y(), vec3.z(), (double)f, (double)f1, (double)f2);
        }
        if (te.craftingCounter > craftingLength) {
            te.craftingCounter = 1;
            if (te.isCrafting) {
                AlterationRecipe recipe = te.getRecipe(level, te.item);
                if (recipe != null) {
                    te.item = recipe.assemble(new SingleRecipeInput(te.item), (HolderLookup.Provider)level.registryAccess());
                    te.setChanged();
                    te.finishedCrafting = true;
                    te.finishedCounter = 0;
                    level.playSound(null, pos, SoundEvents.PLAYER_BREATH, SoundSource.BLOCKS, 1.0f, 0.5f);
                }
                te.isCrafting = false;
                te.setChanged();
            }
            te.updateBlock();
        }
        if (te.finishedCrafting) {
            if (te.finishedCounter++ >= 20) {
                te.finishedCrafting = false;
                te.finishedCounter = 0;
            }
            if (level.isClientSide()) {
                for (int i = 0; i < 7; ++i) {
                    level.addParticle((ParticleOptions)RisusParticles.ALTERATION_FINISHED.get(), (double)((float)pos.getX() + 0.15f + level.getRandom().nextFloat() * 0.75f), (double)((float)pos.getY() + 1.0f), (double)((float)pos.getZ() + 0.15f + level.getRandom().nextFloat() * 0.75f), 0.0, (double)0.1f, 0.0);
                }
            }
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.item != null && !this.item.isEmpty()) {
            tag.put("item", this.item.save(registries));
        }
        tag.putBoolean("isCrafting", this.isCrafting);
        tag.putBoolean("finishedCrafting", this.finishedCrafting);
        tag.putInt("counter", this.craftingCounter);
        tag.putFloat("itemRotation", this.rotationDegrees);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.item = tag.contains("item") ? (ItemStack)ItemStack.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("item")).mapOrElse(Function.identity(), e -> ItemStack.EMPTY) : ItemStack.EMPTY;
        this.isCrafting = tag.getBoolean("isCrafting");
        this.finishedCrafting = tag.getBoolean("finishedCrafting");
        this.craftingCounter = tag.getInt("counter");
        this.rotationDegrees = tag.getFloat("itemRotation");
        super.loadAdditional(tag, registries);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        if (this.item != null && !this.item.isEmpty()) {
            Tag reagentTag = this.item.save(pRegistries);
            tag.put("item", reagentTag);
        }
        tag.putInt("counter", this.craftingCounter);
        tag.putBoolean("isCrafting", this.isCrafting);
        tag.putBoolean("finishedCrafting", this.finishedCrafting);
        tag.putFloat("itemRotation", this.rotationDegrees);
        super.saveAdditional(tag, pRegistries);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider pRegistries) {
        super.onDataPacket(net, packet, pRegistries);
        this.handleUpdateTag(packet.getTag() == null ? new CompoundTag() : packet.getTag(), pRegistries);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Nullable
    public AlterationRecipe getRecipe(Level level, ItemStack stack) {
        return level.getRecipeManager().getRecipeFor((RecipeType)RisusRecipes.ALTERATION_RECIPE.get(), (RecipeInput)new SingleRecipeInput(stack), level).map(RecipeHolder::value).orElse(null);
    }

    public void attemptCraft(Level level, ItemStack item) {
        if (this.isCrafting) {
            return;
        }
        this.isCrafting = this.craftingPossible(level, item);
    }

    public boolean craftingPossible(Level level, ItemStack stack) {
        if (this.isCrafting || stack.isEmpty()) {
            return false;
        }
        return this.getRecipe(level, stack) != null;
    }

    public boolean updateBlock() {
        if (this.craftingCounter == 0) {
            this.craftingCounter = 1;
        }
        if (this.getLevel() != null) {
            BlockState state = this.getLevel().getBlockState(this.getBlockPos());
            this.getLevel().sendBlockUpdated(this.getBlockPos(), state, state, 2);
            this.setChanged();
            return true;
        }
        return false;
    }

    public ItemStack splitTheItem(int amount) {
        if (this.isCrafting) {
            return ItemStack.EMPTY;
        }
        return super.splitTheItem(amount);
    }

    public ItemStack getTheItem() {
        return this.item;
    }

    public void setTheItem(ItemStack item) {
        if (this.isCrafting) {
            return;
        }
        this.item = item;
        this.rotationDegrees = this.getLevel().getRandom().nextFloat() * 360.0f;
        this.updateBlock();
        this.attemptCraft(this.getLevel(), item);
    }

    public void setInputItem(ItemStack item) {
        this.setItem(0, item);
        this.setChanged();
    }

    public int[] getSlotsForFace(Direction direction) {
        return new int[]{0};
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction direction) {
        return this.item.isEmpty();
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction direction) {
        return direction == Direction.DOWN && !this.item.isEmpty() && !this.isCrafting;
    }

    public BlockEntity getContainerBlockEntity() {
        return this;
    }
}

