/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks.plantblocks;

import com.bigdious.risus.blocks.plantblocks.RisusGrowingPlantHeadBlock;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class RisusGrowingPlantBlock
extends Block {
    protected final Direction growthDirection;
    protected final boolean scheduleFluidTicks;
    protected final VoxelShape shape;

    protected RisusGrowingPlantBlock(BlockBehaviour.Properties pProperties, Direction pGrowthDirection, VoxelShape pShape, boolean pScheduleFluidTicks) {
        super(pProperties);
        this.growthDirection = pGrowthDirection;
        this.shape = pShape;
        this.scheduleFluidTicks = pScheduleFluidTicks;
    }

    protected abstract MapCodec<? extends RisusGrowingPlantBlock> codec();

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState blockstate = pContext.getLevel().getBlockState(pContext.getClickedPos().relative(this.growthDirection));
        return !blockstate.is((Block)this.getHeadBlock()) && !blockstate.is(this.getBodyBlock()) ? this.getStateForPlacement((LevelAccessor)pContext.getLevel()) : this.getBodyBlock().defaultBlockState();
    }

    public BlockState getStateForPlacement(LevelAccessor pLevel) {
        return this.defaultBlockState();
    }

    protected boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.relative(this.growthDirection.getOpposite());
        BlockState blockstate = pLevel.getBlockState(blockpos);
        return this.canAttachTo(blockstate) && (blockstate.is((Block)this.getHeadBlock()) || blockstate.is(this.getBodyBlock()) || blockstate.isFaceSturdy((BlockGetter)pLevel, blockpos, this.growthDirection));
    }

    protected void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pState.canSurvive((LevelReader)pLevel, pPos)) {
            pLevel.destroyBlock(pPos, true);
        }
    }

    protected boolean canAttachTo(BlockState pState) {
        return true;
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shape;
    }

    protected abstract RisusGrowingPlantHeadBlock getHeadBlock();

    protected abstract Block getBodyBlock();
}

