/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks.plantblocks;

import com.bigdious.risus.blocks.fluid.BloodFluid;
import com.bigdious.risus.blocks.interfaces.OrganicMatterableBlock;
import com.bigdious.risus.blocks.plantblocks.RisusGrowingPlantBlock;
import com.bigdious.risus.blocks.plantblocks.RisusGrowingPlantHeadBlock;
import com.bigdious.risus.init.RisusFluids;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class RisusGrowingPlantBodyBlock
extends RisusGrowingPlantBlock
implements OrganicMatterableBlock {
    protected RisusGrowingPlantBodyBlock(BlockBehaviour.Properties pProperties, Direction pGrowthDirection, VoxelShape pShape, boolean pScheduleFluidTicks) {
        super(pProperties, pGrowthDirection, pShape, pScheduleFluidTicks);
    }

    protected abstract MapCodec<? extends RisusGrowingPlantBodyBlock> codec();

    protected BlockState updateHeadAfterConvertedFromBody(BlockState pHead, BlockState pBody) {
        return pBody;
    }

    protected BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing == this.growthDirection.getOpposite() && !pState.canSurvive((LevelReader)pLevel, pCurrentPos)) {
            pLevel.scheduleTick(pCurrentPos, (Block)this, 1);
        }
        RisusGrowingPlantHeadBlock growingplantheadblock = this.getHeadBlock();
        if (pFacing == this.growthDirection && !pFacingState.is((Block)this) && !pFacingState.is((Block)growingplantheadblock)) {
            return this.updateHeadAfterConvertedFromBody(pState, growingplantheadblock.getStateForPlacement(pLevel));
        }
        if (this.scheduleFluidTicks) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.LAVA, Fluids.LAVA.getTickDelay((LevelReader)pLevel));
            pLevel.scheduleTick(pCurrentPos, (Fluid)RisusFluids.SOURCE_BLOOD.get(), ((BloodFluid.Source)((Object)RisusFluids.SOURCE_BLOOD.get())).getTickDelay((LevelReader)pLevel));
        }
        return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public ItemStack getCloneItemStack(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack((ItemLike)this.getHeadBlock());
    }

    @Override
    public boolean isValidOrganicMatterTarget(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        Optional<BlockPos> optional = this.getHeadPos((BlockGetter)pLevel, pPos, pState.getBlock());
        return optional.isPresent() && this.getHeadBlock().canGrowInto(pLevel.getBlockState(optional.get().relative(this.growthDirection)));
    }

    @Override
    public boolean isOrganicMatterSuccess(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    @Override
    public void performOrganicMatter(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        Optional<BlockPos> optional = this.getHeadPos((BlockGetter)pLevel, pPos, pState.getBlock());
        if (optional.isPresent()) {
            BlockState blockstate = pLevel.getBlockState(optional.get());
            ((RisusGrowingPlantHeadBlock)blockstate.getBlock()).performOrganicMatter(pLevel, pRandom, optional.get(), blockstate);
        }
    }

    private Optional<BlockPos> getHeadPos(BlockGetter pLevel, BlockPos pPos, Block pBlock) {
        return BlockUtil.getTopConnectedBlock((BlockGetter)pLevel, (BlockPos)pPos, (Block)pBlock, (Direction)this.growthDirection, (Block)this.getHeadBlock());
    }

    protected boolean canBeReplaced(BlockState pState, BlockPlaceContext pUseContext) {
        boolean flag = super.canBeReplaced(pState, pUseContext);
        return (!flag || !pUseContext.getItemInHand().is(this.getHeadBlock().asItem())) && flag;
    }

    @Override
    protected Block getBodyBlock() {
        return this;
    }
}

