/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.client.model.entity;

import com.bigdious.risus.entity.Holder;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.HumanoidArm;

public class HolderModel<T extends Holder>
extends HierarchicalModel<T>
implements ArmedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart left_arm;
    private final ModelPart right_arm;

    public HolderModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("head");
        this.left_arm = root.getChild("left_arm");
        this.right_arm = root.getChild("right_arm");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -2.0f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)16.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 10).addBox(-4.0f, -8.0f, -1.0f, 7.0f, 9.0f, 6.0f).texOffs(6, 15).addBox(-6.0f, -5.0f, 2.0f, 4.0f, 6.0f, 4.0f).texOffs(2, 12).addBox(-5.0f, -2.0f, -4.0f, 5.0f, 3.0f, 6.0f).texOffs(5, 14).addBox(0.0f, -11.0f, 0.0f, 4.0f, 5.0f, 4.0f).texOffs(2, 14).addBox(-4.0f, -1.0f, 4.0f, 8.0f, 2.0f, 3.0f).texOffs(1, 18).addBox(-2.0f, 0.0f, -6.0f, 7.0f, 1.0f, 6.0f).texOffs(5, 15).addBox(1.0f, -3.0f, -2.0f, 5.0f, 4.0f, 6.0f).texOffs(4, 21).addBox(-7.0f, 0.0f, -1.0f, 2.0f, 1.0f, 5.0f).texOffs(13, 23).addBox(4.0f, 0.0f, 4.0f, 1.0f, 1.0f, 2.0f), PartPose.offset((float)0.0f, (float)23.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(3, 15).addBox(-1.0f, -1.0f, -7.0f, 2.0f, 2.0f, 8.0f), PartPose.offset((float)3.0f, (float)19.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(3, 15).mirror().addBox(-1.0f, -1.0f, -7.0f, 2.0f, 2.0f, 8.0f).mirror(false), PartPose.offset((float)-4.0f, (float)19.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
    }

    public ModelPart root() {
        return this.root;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.left_arm : this.right_arm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack stack) {
        this.getArm(arm).translateAndRotate(stack);
    }
}

