/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.client.model.entity;

import com.bigdious.risus.entity.Licker;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class LickerModel<T extends Licker>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart deadHead;
    private final ModelPart newHead;
    private final ModelPart fullTongue;
    private final ModelPart tonguePart1;
    private final ModelPart tonguePart2;
    private final ModelPart leg8;
    private final ModelPart leg7;
    private final ModelPart leg6;
    private final ModelPart leg1;
    private final ModelPart leg4;
    private final ModelPart leg2;
    private final ModelPart leg3;
    private final ModelPart leg5;

    public LickerModel(ModelPart root) {
        this.root = root;
        this.deadHead = root.getChild("deadHead");
        this.newHead = root.getChild("newHead");
        this.fullTongue = this.newHead.getChild("fullTongue");
        this.tonguePart1 = this.fullTongue.getChild("tonguePart1");
        this.tonguePart2 = this.tonguePart1.getChild("tonguePart2");
        this.leg8 = root.getChild("leg8");
        this.leg7 = root.getChild("leg7");
        this.leg6 = root.getChild("leg6");
        this.leg1 = root.getChild("leg1");
        this.leg4 = root.getChild("leg4");
        this.leg2 = root.getChild("leg2");
        this.leg3 = root.getChild("leg3");
        this.leg5 = root.getChild("leg5");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("deadHead", CubeListBuilder.create().texOffs(32, 4).addBox(-4.0f, -4.0f, -8.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)3.0f, (float)2.8798f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("body0", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)0.0f, (float)3.1416f, (float)0.0f, (float)0.0f));
        PartDefinition newHead = partdefinition.addOrReplaceChild("newHead", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.9172f, (float)-1.5116f, (float)3.1416f, (float)0.0f, (float)0.0f));
        newHead.addOrReplaceChild("newHeadUp", CubeListBuilder.create().texOffs(0, 28).addBox(-5.0f, 0.0f, -1.0f, 10.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.0828f, (float)2.4884f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition jaw = newHead.addOrReplaceChild("jaw", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-0.0786f, (float)1.819f));
        jaw.addOrReplaceChild("lipLeft", CubeListBuilder.create().texOffs(0, 35).addBox(0.0f, -4.0f, -5.5f, 0.0f, 8.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(0, 35).addBox(8.0f, -4.0f, -5.5f, 0.0f, 8.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)0.8827f, (float)6.7383f, (float)0.1745f, (float)0.0f, (float)0.0f));
        jaw.addOrReplaceChild("newHeadDown", CubeListBuilder.create().texOffs(0, 12).addBox(-5.0f, -4.0f, -1.0f, 10.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.0042f, (float)0.6695f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition fullTongue = newHead.addOrReplaceChild("fullTongue", CubeListBuilder.create().texOffs(37, 41).addBox(-4.0f, 0.0f, -1.0f, 8.0f, 0.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.0828f, (float)2.4884f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition tonguePart1 = fullTongue.addOrReplaceChild("tonguePart1", CubeListBuilder.create().texOffs(42, 32).addBox(-3.0f, 0.0f, 0.0f, 6.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)10.0f, (float)0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition tonguePart2 = tonguePart1.addOrReplaceChild("tonguePart2", CubeListBuilder.create().texOffs(47, 25).addBox(-2.0f, 0.0f, 0.0f, 4.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)9.0f, (float)0.48f, (float)0.0f, (float)0.0f));
        tonguePart2.addOrReplaceChild("tongue4", CubeListBuilder.create().texOffs(52, 20).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)7.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition leg8 = partdefinition.addOrReplaceChild("leg8", CubeListBuilder.create().texOffs(18, 0).addBox(-1.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)1.0f, (float)2.0f, (float)-3.1416f, (float)-0.7854f, (float)-0.7854f));
        PartDefinition lowLeg8 = leg8.addOrReplaceChild("lowLeg8", CubeListBuilder.create().texOffs(0, 44).addBox(-0.25f, -0.5f, -0.5f, 19.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)15.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6545f, (float)-1.6144f));
        lowLeg8.addOrReplaceChild("leg83", CubeListBuilder.create().texOffs(19, 1).addBox(0.0f, -0.5f, -0.5f, 16.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)18.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)-0.9599f));
        PartDefinition leg7 = partdefinition.addOrReplaceChild("leg7", CubeListBuilder.create().texOffs(18, 0).mirror().addBox(-15.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-4.0f, (float)1.0f, (float)2.0f, (float)-3.1416f, (float)0.7854f, (float)0.7854f));
        PartDefinition lowLeg7 = leg7.addOrReplaceChild("lowLeg7", CubeListBuilder.create().texOffs(0, 44).mirror().addBox(-18.75f, -0.5f, -0.5f, 19.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-15.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6545f, (float)1.6144f));
        lowLeg7.addOrReplaceChild("leg73", CubeListBuilder.create().texOffs(19, 1).mirror().addBox(-16.0f, -0.5f, -0.5f, 16.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-18.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f, (float)0.9599f));
        PartDefinition leg6 = partdefinition.addOrReplaceChild("leg6", CubeListBuilder.create().texOffs(18, 0).mirror().addBox(-15.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-4.0f, (float)1.0f, (float)-2.0f, (float)3.1416f, (float)-0.7854f, (float)0.7854f));
        PartDefinition lowLeg6 = leg6.addOrReplaceChild("lowLeg6", CubeListBuilder.create().texOffs(0, 44).mirror().addBox(-18.75f, -0.5f, -0.5f, 19.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-15.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6545f, (float)1.6144f));
        lowLeg6.addOrReplaceChild("leg63", CubeListBuilder.create().texOffs(19, 1).mirror().addBox(-16.0f, -0.5f, -0.5f, 16.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-18.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.9599f));
        PartDefinition leg1 = partdefinition.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(18, 0).addBox(-1.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)1.0f, (float)-2.0f, (float)3.1416f, (float)0.7854f, (float)-0.7854f));
        PartDefinition lowLeg1 = leg1.addOrReplaceChild("lowLeg1", CubeListBuilder.create().texOffs(0, 44).addBox(-0.25f, -0.5f, -0.5f, 19.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)15.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6545f, (float)-1.6144f));
        lowLeg1.addOrReplaceChild("leg13", CubeListBuilder.create().texOffs(19, 1).addBox(0.0f, -0.5f, -0.5f, 16.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)18.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f, (float)-0.9599f));
        PartDefinition leg4 = partdefinition.addOrReplaceChild("leg4", CubeListBuilder.create().texOffs(18, 0).mirror().addBox(-15.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-4.0f, (float)1.0f, (float)1.0f, (float)3.1416f, (float)0.2618f, (float)0.6109f));
        PartDefinition lowLeg4 = leg4.addOrReplaceChild("lowLeg4", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-15.0f, (float)0.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        lowLeg4.addOrReplaceChild("leg42", CubeListBuilder.create().texOffs(0, 44).mirror().addBox(-19.0f, -0.5f, -0.5f, 19.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.7453f));
        lowLeg4.addOrReplaceChild("leg43", CubeListBuilder.create().texOffs(19, 1).addBox(0.0f, 0.0f, -0.5f, 16.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-19.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5672f));
        PartDefinition leg2 = partdefinition.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(18, 0).mirror().addBox(-15.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-4.0f, (float)1.0f, (float)-1.0f, (float)3.1416f, (float)-0.2618f, (float)0.6109f));
        PartDefinition lowLeg2 = leg2.addOrReplaceChild("lowLeg2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-15.0f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        lowLeg2.addOrReplaceChild("leg22", CubeListBuilder.create().texOffs(0, 44).mirror().addBox(-19.0f, -0.5f, -0.5f, 19.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.7453f));
        lowLeg2.addOrReplaceChild("leg23", CubeListBuilder.create().texOffs(19, 1).addBox(0.0f, 0.0f, -0.5f, 16.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-19.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5672f));
        PartDefinition leg3 = partdefinition.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(18, 0).addBox(-1.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)1.0f, (float)-1.0f, (float)3.1416f, (float)0.2618f, (float)-0.6109f));
        PartDefinition lowLeg3 = leg3.addOrReplaceChild("lowLeg3", CubeListBuilder.create(), PartPose.offsetAndRotation((float)15.0f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        lowLeg3.addOrReplaceChild("leg32", CubeListBuilder.create().texOffs(0, 44).addBox(0.0f, -0.5f, -0.5f, 19.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.7453f));
        lowLeg3.addOrReplaceChild("leg33", CubeListBuilder.create().texOffs(19, 1).mirror().addBox(-16.0f, 0.0f, -0.5f, 16.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.0f, (float)-19.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5672f));
        PartDefinition leg5 = partdefinition.addOrReplaceChild("leg5", CubeListBuilder.create().texOffs(18, 0).addBox(-1.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)1.0f, (float)1.0f, (float)3.1416f, (float)-0.2618f, (float)-0.6109f));
        PartDefinition lowLeg5 = leg5.addOrReplaceChild("lowLeg5", CubeListBuilder.create(), PartPose.offsetAndRotation((float)15.0f, (float)0.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        lowLeg5.addOrReplaceChild("leg52", CubeListBuilder.create().texOffs(0, 44).addBox(0.0f, -0.5f, -0.5f, 19.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.7453f));
        lowLeg5.addOrReplaceChild("leg53", CubeListBuilder.create().texOffs(19, 1).mirror().addBox(-16.0f, 0.0f, -0.5f, 16.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.0f, (float)-19.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5672f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        float f3 = -(Mth.cos((float)(limbSwing * 0.6662f * 1.5f + 0.0f)) * 0.4f) * limbSwingAmount;
        float f4 = -(Mth.cos((float)(limbSwing * 0.6662f * 1.5f + (float)Math.PI)) * 0.4f) * limbSwingAmount;
        float f6 = -(Mth.cos((float)(limbSwing * 0.6662f * 1.5f + 4.712389f)) * 0.4f) * limbSwingAmount;
        float f7 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f * 2.0f + 0.0f)) * 0.4f) * limbSwingAmount;
        float f8 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f * 2.0f + (float)Math.PI)) * 0.4f) * limbSwingAmount;
        float f10 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f * 2.0f + 4.712389f)) * 0.4f) * limbSwingAmount;
        this.leg8.yRot += f3;
        this.leg7.yRot += f4;
        this.leg5.yRot += f4;
        this.leg4.yRot -= f3;
        this.leg3.yRot += f6;
        this.leg2.yRot -= f3;
        this.leg1.yRot += f3;
        this.leg6.yRot -= f6;
        this.leg8.zRot += f7;
        this.leg7.zRot -= f8;
        this.leg5.zRot += f8;
        this.leg4.zRot -= f7;
        this.leg3.zRot += f7;
        this.leg2.zRot -= f10;
        this.leg1.zRot += f10;
        this.leg6.zRot -= f7;
        this.newHead.yRot = entity.isAggressive() ? f3 : 0.0f;
        this.newHead.xRot = entity.isAggressive() ? 3.2f - f10 : 3.2f + 0.05f * Mth.sin((float)(ageInTicks * 0.1f + 0.1f));
        this.fullTongue.zRot = !entity.isAggressive() ? 0.0f * Mth.sin((float)(ageInTicks * 0.1f + 0.4f)) : f3;
        this.tonguePart1.zRot = !entity.isAggressive() ? 0.0f * Mth.sin((float)(ageInTicks * 0.1f + 0.4f)) : f3;
        this.tonguePart2.zRot = !entity.isAggressive() ? 0.0f * Mth.sin((float)(ageInTicks * 0.1f + 0.4f)) : f3;
        this.fullTongue.xRot = 0.2f + 0.05f * Mth.sin((float)(ageInTicks * 0.1f + 0.4f));
        this.tonguePart1.xRot = 0.6f + 0.05f * Mth.sin((float)(ageInTicks * 0.1f + 0.4f));
        this.tonguePart2.xRot = 1.0f + 0.05f * Mth.sin((float)(ageInTicks * 0.1f + 0.4f));
        this.deadHead.xRot = 3.2f - 0.05f * Mth.sin((float)(ageInTicks * 0.1f + 0.1f));
    }

    public ModelPart root() {
        return this.root;
    }
}

