/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.client.model.entity;

import com.bigdious.risus.entity.Weaver;
import com.bigdious.risus.entity.animations.WeaverAnimations;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class WeaverModel<T extends Weaver>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart upperJaw;
    private final ModelPart lowerJaw;
    private final ModelPart memoryCore;
    private final ModelPart left_leg1;
    private final ModelPart left_leg2;
    private final ModelPart left_leg3;
    private final ModelPart right_leg1;
    private final ModelPart right_leg2;
    private final ModelPart right_leg3;

    public WeaverModel(ModelPart root) {
        this.root = root;
        ModelPart rightLegs = root.getChild("rightLegs");
        ModelPart leftLegs = root.getChild("leftLegs");
        this.left_leg1 = leftLegs.getChild("left_leg1");
        this.left_leg2 = leftLegs.getChild("left_leg2");
        this.left_leg3 = leftLegs.getChild("left_leg3");
        this.right_leg1 = rightLegs.getChild("right_leg1");
        this.right_leg2 = rightLegs.getChild("right_leg2");
        this.right_leg3 = rightLegs.getChild("right_leg3");
        ModelPart head = root.getChild("head");
        this.upperJaw = head.getChild("upperJaw");
        this.lowerJaw = head.getChild("lowerJaw");
        ModelPart coreHolder = root.getChild("memoryCore");
        this.memoryCore = coreHolder.getChild("memoryShell");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition rightLegs = partdefinition.addOrReplaceChild("rightLegs", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition right_leg1 = rightLegs.addOrReplaceChild("right_leg1", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)-6.0f, (float)2.0f));
        right_leg1.addOrReplaceChild("segment3_r1", CubeListBuilder.create().texOffs(4, 4).addBox(-1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 11.0f), PartPose.offsetAndRotation((float)3.0f, (float)-3.0f, (float)4.0f, (float)-1.1781f, (float)1.1345f, (float)0.0f));
        right_leg1.addOrReplaceChild("segment2_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 7.0f), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)1.0f, (float)0.7418f, (float)0.6545f, (float)0.0f));
        PartDefinition right_leg2 = rightLegs.addOrReplaceChild("right_leg2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-1.0f, (float)-5.0f, (float)2.0f, (float)0.0f, (float)-0.4363f, (float)0.0f));
        right_leg2.addOrReplaceChild("segment3_r2", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -0.6173f, -0.0761f, 1.0f, 1.0f, 10.0f), PartPose.offsetAndRotation((float)3.4226f, (float)-4.0f, (float)3.9063f, (float)-1.1781f, (float)1.1345f, (float)0.0f));
        right_leg2.addOrReplaceChild("segment2_r2", CubeListBuilder.create().texOffs(6, 2).addBox(-1.0f, -0.2627f, -1.6756f, 1.0f, 1.0f, 7.0f), PartPose.offsetAndRotation((float)1.4226f, (float)-1.0f, (float)0.9063f, (float)0.7418f, (float)0.6545f, (float)0.0f));
        PartDefinition right_leg3 = rightLegs.addOrReplaceChild("right_leg3", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-2.0f, (float)-4.0f, (float)2.0f, (float)0.0f, (float)-0.9163f, (float)0.0f));
        right_leg3.addOrReplaceChild("segment3_r3", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -0.6173f, -0.0761f, 1.0f, 1.0f, 9.0f), PartPose.offsetAndRotation((float)3.1846f, (float)-4.0f, (float)4.4021f, (float)-1.1781f, (float)0.2618f, (float)-0.0436f));
        right_leg3.addOrReplaceChild("segment2_r3", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -0.2627f, -1.6756f, 1.0f, 1.0f, 6.0f), PartPose.offsetAndRotation((float)1.1846f, (float)-1.0f, (float)1.4021f, (float)0.7418f, (float)0.6545f, (float)0.0f));
        PartDefinition leftLegs = partdefinition.addOrReplaceChild("leftLegs", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition left_leg1 = leftLegs.addOrReplaceChild("left_leg1", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)-6.0f, (float)-2.0f));
        left_leg1.addOrReplaceChild("segment2_r4", CubeListBuilder.create().texOffs(4, 4).addBox(-1.0f, -1.0f, -10.0f, 1.0f, 1.0f, 11.0f), PartPose.offsetAndRotation((float)3.0f, (float)-3.0f, (float)-4.0f, (float)1.1781f, (float)-1.1345f, (float)0.0f));
        left_leg1.addOrReplaceChild("segment1_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.0f, -6.0f, 1.0f, 1.0f, 7.0f), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)-1.0f, (float)-0.7418f, (float)-0.6545f, (float)0.0f));
        PartDefinition left_leg2 = leftLegs.addOrReplaceChild("left_leg2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-1.0f, (float)-5.0f, (float)-2.0f, (float)0.0f, (float)0.4363f, (float)0.0f));
        left_leg2.addOrReplaceChild("segment2_r5", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -0.6173f, -9.9239f, 1.0f, 1.0f, 10.0f), PartPose.offsetAndRotation((float)3.4226f, (float)-4.0f, (float)-3.9063f, (float)1.1781f, (float)-1.1345f, (float)0.0f));
        left_leg2.addOrReplaceChild("segment1_r2", CubeListBuilder.create().texOffs(0, 3).addBox(-1.0f, -0.2627f, -5.3244f, 1.0f, 1.0f, 7.0f), PartPose.offsetAndRotation((float)1.4226f, (float)-1.0f, (float)-0.9063f, (float)-0.7418f, (float)-0.6545f, (float)0.0f));
        PartDefinition left_leg3 = leftLegs.addOrReplaceChild("left_leg3", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-2.0f, (float)-4.0f, (float)-2.0f, (float)0.0f, (float)0.9163f, (float)0.0f));
        left_leg3.addOrReplaceChild("segment2_r6", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -0.6173f, -8.9239f, 1.0f, 1.0f, 9.0f), PartPose.offsetAndRotation((float)3.1846f, (float)-4.0f, (float)-4.4021f, (float)1.1781f, (float)-0.2618f, (float)-0.0436f));
        left_leg3.addOrReplaceChild("segment1_r3", CubeListBuilder.create().texOffs(16, 3).addBox(-1.0f, -0.2627f, -4.3244f, 1.0f, 1.0f, 6.0f), PartPose.offsetAndRotation((float)1.1846f, (float)-1.0f, (float)-1.4021f, (float)-0.7418f, (float)-0.6545f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(6, 12).addBox(-2.0f, -1.0f, -2.0f, 2.0f, 2.0f, 3.0f), PartPose.offsetAndRotation((float)-0.5f, (float)19.0f, (float)-4.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        head.addOrReplaceChild("upperJaw", CubeListBuilder.create().texOffs(0, 0).addBox(-2.7648f, -0.9389f, 1.5f, 3.0f, 1.0f, 1.0f).texOffs(0, 0).addBox(-2.7648f, -0.9389f, -2.5f, 3.0f, 1.0f, 1.0f).texOffs(0, 0).addBox(-3.7648f, -0.9389f, -1.5f, 1.0f, 1.0f, 3.0f).texOffs(31, 6).addBox(-3.7648f, -0.9389f, 1.5f, 1.0f, 2.0f, 1.0f).texOffs(31, 6).addBox(-3.7648f, -0.9389f, -2.5f, 1.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)-2.0f, (float)-1.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.4363f));
        head.addOrReplaceChild("lowerJaw", CubeListBuilder.create().texOffs(0, 0).addBox(-2.7696f, -0.8415f, 1.5f, 3.0f, 1.0f, 1.0f).texOffs(0, 0).addBox(-2.7696f, -0.8415f, -2.5f, 3.0f, 1.0f, 1.0f).texOffs(0, 0).addBox(-3.7696f, -0.8415f, -1.5f, 1.0f, 1.0f, 3.0f).texOffs(31, 6).addBox(-3.7696f, -0.8415f, 1.5f, 1.0f, 2.0f, 1.0f).texOffs(31, 6).addBox(-3.7696f, -0.8415f, -2.5f, 1.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)-2.0f, (float)1.0f, (float)-0.5f, (float)3.1416f, (float)0.0f, (float)-0.3927f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(4, 12).addBox(0.0f, -8.0f, -1.5f, 4.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        body.addOrReplaceChild("middleSegment_r1", CubeListBuilder.create().texOffs(0, 11).addBox(-3.0f, -2.0f, -2.5f, 6.0f, 4.0f, 5.0f), PartPose.offsetAndRotation((float)-2.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition memoryCore = partdefinition.addOrReplaceChild("memoryCore", CubeListBuilder.create().texOffs(10, 14).addBox(-2.5f, -2.5f, 0.6429f, 5.0f, 5.0f, 1.0f).texOffs(0, 0).addBox(2.0f, 1.5f, 1.6429f, 1.0f, 1.0f, 5.0f).texOffs(0, 0).addBox(2.0f, -2.5f, 1.6429f, 1.0f, 1.0f, 5.0f).texOffs(0, 0).addBox(-3.0f, -2.5f, 1.6429f, 1.0f, 1.0f, 5.0f).texOffs(0, 0).addBox(-3.0f, 1.5f, 1.6429f, 1.0f, 1.0f, 5.0f).texOffs(30, 6).addBox(-0.5f, -0.5f, 4.6429f, 1.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)17.5f, (float)3.3571f, (float)0.2182f, (float)0.0f, (float)0.0f));
        memoryCore.addOrReplaceChild("memoryShell", CubeListBuilder.create().texOffs(30, 0).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)5.1429f, (float)-0.7854f, (float)0.7854f, (float)0.7854f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public ModelPart root() {
        return this.root;
    }

    public void renderToBuffer(PoseStack stack, VertexConsumer builder, int light, int overlay, int color) {
        this.memoryCore.visible = true;
        this.root().render(stack, builder, light, overlay, color);
    }

    public void renderCore(PoseStack stack, VertexConsumer builder, int light, int overlay, int color) {
        this.memoryCore.render(stack, builder, light, overlay, color);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.right_leg1.yRot = 0.0f;
        this.right_leg2.yRot = -0.43633232f;
        this.right_leg3.yRot = -0.91629785f;
        this.right_leg1.zRot = 0.0f;
        this.right_leg2.zRot = 0.0f;
        this.right_leg3.zRot = 0.0f;
        this.left_leg1.yRot = 0.0f;
        this.left_leg2.yRot = 0.43633232f;
        this.left_leg3.yRot = 0.91629785f;
        this.left_leg1.zRot = 0.0f;
        this.left_leg2.zRot = 0.0f;
        this.left_leg3.zRot = 0.0f;
        float f3 = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + 0.0f)) * 0.4f) * limbSwingAmount;
        float f4 = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + (float)Math.PI)) * 0.4f) * limbSwingAmount;
        float f6 = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + 4.712389f)) * 0.4f) * limbSwingAmount;
        float f7 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + 0.0f)) * 0.4f) * limbSwingAmount;
        float f8 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.4f) * limbSwingAmount;
        float f10 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + 4.712389f)) * 0.4f) * limbSwingAmount;
        this.right_leg3.yRot += f3;
        this.left_leg3.yRot -= f3;
        this.right_leg2.yRot += f4;
        this.left_leg2.yRot -= f4;
        this.right_leg1.yRot += f6;
        this.left_leg1.yRot -= f6;
        this.right_leg3.zRot += f7;
        this.left_leg3.zRot -= f7;
        this.right_leg2.zRot += f8;
        this.left_leg2.zRot -= f8;
        this.right_leg1.zRot += f10;
        this.left_leg1.zRot -= f10;
        this.memoryCore.xRot = ageInTicks * 2.0f % 360.0f * ((float)Math.PI / 180);
        this.memoryCore.yRot = ageInTicks * 2.0f % 360.0f * ((float)Math.PI / 180);
        this.memoryCore.zRot = ageInTicks * 2.0f % 360.0f * ((float)Math.PI / 180);
        this.upperJaw.zRot = Mth.sin((float)(ageInTicks * 0.067f)) * 0.1f + 0.17453292f;
        this.lowerJaw.zRot = -Mth.sin((float)(ageInTicks * 0.067f)) * 0.1f + -0.17453292f;
        this.animate(((Weaver)entity).leapAnim, WeaverAnimations.WEAVER_ATTACK, ageInTicks);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        int attackTimer = ((Weaver)entity).getAttackTimer();
        if (attackTimer > 0) {
            this.upperJaw.zRot = 5.0f;
            this.lowerJaw.zRot = -5.0f;
        } else {
            this.upperJaw.zRot = 5.0f;
            this.lowerJaw.zRot = -5.0f;
        }
    }
}

