/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.client.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class BloodBitParticle
extends TextureSheetParticle {
    private final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"risus", (String)"textures/particle/cauldron_boil_particle.png");
    public static final Vec3[] CUBE = new Vec3[]{new Vec3(0.1, -0.01, -0.1), new Vec3(0.1, -0.01, 0.1), new Vec3(-0.1, -0.01, 0.1), new Vec3(-0.1, -0.01, -0.1), new Vec3(-0.1, 0.01, -0.1), new Vec3(-0.1, 0.01, 0.1), new Vec3(0.1, 0.01, 0.1), new Vec3(0.1, 0.01, -0.1)};
    public static final Vec3[] CUBE_NORMALS = new Vec3[]{new Vec3(0.0, 0.0, 0.5), new Vec3(0.0, 0.0, 0.5)};
    private static final ParticleRenderType renderType = (tesselator, textureManager) -> {
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
    };
    protected float scale;
    protected float rotationDirection;
    protected float rotation;
    protected final float rotationOffsetYaw;
    protected final float rotationOffsetPitch;
    protected final float rotationOffsetRoll;

    public BloodBitParticle(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z);
        this.xd = motionX;
        this.yd = motionY;
        this.zd = motionZ;
        this.rotation = 0.0f;
        this.lifetime = (int)(80.0 + (this.random.nextDouble() * 2.0 - 1.0) * 8.0);
        this.rotationOffsetYaw = this.random.nextFloat();
        this.rotationOffsetPitch = this.random.nextFloat();
        this.rotationOffsetRoll = this.random.nextFloat();
        this.setScale(0.2f);
        this.setRotationDirection(this.random.nextFloat() - 0.5f);
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.setSize(scale * 0.5f, scale * 0.5f);
    }

    public void setRotationDirection(float rotationDirection) {
        this.rotationDirection = rotationDirection;
    }

    public void tick() {
        this.rotation = this.rotationDirection * 0.1f + this.rotation;
        super.tick();
    }

    public void render(VertexConsumer builder, Camera renderInfo, float p_225606_3_) {
        Vec3 projectedView = renderInfo.getPosition();
        float lerpX = (float)(Mth.lerp((double)p_225606_3_, (double)this.xo, (double)this.x) - projectedView.x());
        float lerpY = (float)(Mth.lerp((double)p_225606_3_, (double)this.yo, (double)this.y) - projectedView.y());
        float lerpZ = (float)(Mth.lerp((double)p_225606_3_, (double)this.zo, (double)this.z) - projectedView.z());
        int light = 0xF000F0;
        double ageMultiplier = 1.0 - Math.pow(Mth.clamp((float)((float)this.age + p_225606_3_), (float)0.0f, (float)this.lifetime), 3.0) / Math.pow(this.lifetime, 3.0);
        RenderSystem._setShaderTexture((int)0, (ResourceLocation)this.TEXTURE);
        for (int i = 0; i < CUBE.length / 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                Vec3 vec = CUBE[i * 4 + j];
                vec = vec.yRot(this.rotation + this.rotationOffsetYaw).xRot(this.rotation + this.rotationOffsetPitch).zRot(this.rotation + this.rotationOffsetRoll).scale((double)this.scale * ageMultiplier).add((double)lerpX, (double)lerpY, (double)lerpZ);
                Vec3 normal = CUBE_NORMALS[i];
                builder.addVertex((float)vec.x, (float)vec.y, (float)vec.z).setUv(0.0f, 0.0f).setColor(Mth.clamp((float)(this.rCol * 0.8f), (float)0.0f, (float)1.0f), Mth.clamp((float)(this.gCol * 0.8f), (float)0.0f, (float)1.0f), Mth.clamp((float)(this.bCol * 0.8f), (float)0.0f, (float)1.0f), this.alpha).setNormal((float)normal.x, (float)normal.y, (float)normal.z).setUv2(light, light);
            }
        }
    }

    public ParticleRenderType getRenderType() {
        return renderType;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            BloodBitParticle cauldronParticle = new BloodBitParticle(level, x, y, z, xSpeed, ySpeed, zSpeed);
            float colorOffset = level.getRandom().nextFloat() * 0.1f;
            cauldronParticle.setColor(0.025f + colorOffset, 0.05f, 0.05f);
            cauldronParticle.setAlpha(1.0f);
            cauldronParticle.pickSprite(this.spriteSet);
            return cauldronParticle;
        }
    }
}

