/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.client.render;

import com.bigdious.risus.Risus;
import com.bigdious.risus.client.RisusModelLayers;
import com.bigdious.risus.client.model.entity.HolderModel;
import com.bigdious.risus.client.render.layer.HolderFaceLayer;
import com.bigdious.risus.entity.Holder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class HolderRenderer
extends MobRenderer<Holder, HolderModel<Holder>> {
    protected static final ResourceLocation TEXTURE = Risus.prefix("textures/entity/holder.png");

    public HolderRenderer(EntityRendererProvider.Context context) {
        super(context, new HolderModel(context.bakeLayer(RisusModelLayers.HOLDER)), 0.0f);
        this.addLayer((RenderLayer)new HolderItemLayer((RenderLayerParent<Holder, HolderModel<Holder>>)this, context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new HolderFaceLayer(this));
    }

    protected void scale(Holder holder, PoseStack stack, float partialTicks) {
        stack.scale(0.75f, 0.75f, 0.75f);
    }

    public ResourceLocation getTextureLocation(Holder holder) {
        return TEXTURE;
    }

    public static class HolderItemLayer
    extends ItemInHandLayer<Holder, HolderModel<Holder>> {
        private final ItemInHandRenderer itemInHandRenderer;

        public HolderItemLayer(RenderLayerParent<Holder, HolderModel<Holder>> parent, ItemInHandRenderer renderer) {
            super(parent, renderer);
            this.itemInHandRenderer = renderer;
        }

        public void render(PoseStack stack, MultiBufferSource source, int light, Holder holder, float p_117208_, float p_117209_, float p_117210_, float p_117211_, float p_117212_, float p_117213_) {
            ItemStack itemstack1;
            boolean flag = holder.getMainArm() == HumanoidArm.RIGHT;
            ItemStack itemstack = flag ? holder.getOffhandItem() : holder.getMainHandItem();
            ItemStack itemStack = itemstack1 = flag ? holder.getMainHandItem() : holder.getOffhandItem();
            if (!itemstack.isEmpty() || !itemstack1.isEmpty()) {
                stack.pushPose();
                if (((HolderModel)this.getParentModel()).young) {
                    stack.translate(0.0, 0.75, 0.0);
                    stack.scale(0.5f, 0.5f, 0.5f);
                }
                this.renderArmWithItem((LivingEntity)holder, itemstack1, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, stack, source, light);
                this.renderArmWithItem((LivingEntity)holder, itemstack, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, stack, source, light);
                stack.popPose();
            }
        }

        protected void renderArmWithItem(LivingEntity entity, ItemStack item, ItemDisplayContext type, HumanoidArm arm, PoseStack stack, MultiBufferSource source, int light) {
            if (!item.isEmpty()) {
                stack.pushPose();
                ((HolderModel)this.getParentModel()).translateToHand(arm, stack);
                stack.mulPose(Axis.XP.rotationDegrees(180.0f));
                stack.mulPose(Axis.YP.rotationDegrees(180.0f));
                stack.translate(-0.29, -0.25, 0.25);
                boolean flag = entity.getMainArm() == HumanoidArm.LEFT;
                stack.translate(flag ? 0.5 : 0.0625, 0.125, -0.625);
                this.itemInHandRenderer.renderItem(entity, item, type, flag, stack, source, light);
                stack.popPose();
            }
        }
    }
}

