/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.client.render;

import com.bigdious.risus.blocks.entity.RitualBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public class RitualBlockEntityRenderer
implements BlockEntityRenderer<RitualBlockEntity> {
    private final ItemRenderer itemRenderer;
    private float oRot;
    private float rot;

    public RitualBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(RitualBlockEntity entity, float partialTick, PoseStack stack, MultiBufferSource buffers, int light, int overlay) {
        this.updateEntityRotation(entity.getBlockPos(), Minecraft.getInstance().gameRenderer.getMainCamera());
        ItemStack itemstack = entity.getTheItem();
        if (itemstack != ItemStack.EMPTY) {
            stack.pushPose();
            stack.translate(0.5, 2.5, 0.5);
            stack.mulPose(Axis.YP.rotation(-this.rotateTowardsPlayer(partialTick) - 1.5707964f));
            this.handleRotationTimer(entity.getTimer(), stack);
            stack.scale(0.6f, 0.6f, 0.6f);
            this.itemRenderer.renderStatic(itemstack, ItemDisplayContext.FIXED, light, OverlayTexture.NO_OVERLAY, stack, buffers, entity.getLevel(), 0);
            stack.popPose();
        }
    }

    private void handleRotationTimer(int timer, PoseStack stack) {
        stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        if (timer > 20 && timer < 60) {
            stack.translate(0.0, (double)((float)(timer - 20) / 40.0f), 0.0);
            stack.mulPose(Axis.XP.rotationDegrees(90.0f * ((float)(timer - 20) / 40.0f)));
        } else if (timer >= 60 && timer < 100) {
            stack.translate(0.0, 1.0, 0.0);
            stack.mulPose(Axis.XP.rotationDegrees(90.0f));
        }
    }

    public AABB getRenderBoundingBox(RitualBlockEntity entity) {
        return new AABB(entity.getBlockPos()).inflate(1.0).expandTowards(0.0, 1.0, 0.0);
    }

    private void updateEntityRotation(BlockPos pos, Camera camera) {
        float f2;
        this.oRot = this.rot;
        double d0 = camera.getPosition().x - (double)pos.getX() - 0.5;
        double d1 = camera.getPosition().z - (double)pos.getZ() - 0.5;
        float tRot = (float)Mth.atan2((double)d1, (double)d0);
        while (this.rot >= (float)Math.PI) {
            this.rot -= (float)Math.PI * 2;
        }
        while (this.rot < (float)(-Math.PI)) {
            this.rot += (float)Math.PI * 2;
        }
        while (tRot >= (float)Math.PI) {
            tRot -= (float)Math.PI * 2;
        }
        while (tRot < (float)(-Math.PI)) {
            tRot += (float)Math.PI * 2;
        }
        for (f2 = tRot - this.rot; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        this.rot += f2 * 0.4f;
    }

    private float rotateTowardsPlayer(float partialTick) {
        float f1;
        for (f1 = this.rot - this.oRot; f1 >= (float)Math.PI; f1 -= (float)Math.PI * 2) {
        }
        while (f1 < (float)(-Math.PI)) {
            f1 += (float)Math.PI * 2;
        }
        return this.oRot + f1 * partialTick;
    }
}

