/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.client.render.item;

import com.bigdious.risus.client.EntityCache;
import com.bigdious.risus.init.RisusDataComponents;
import com.bigdious.risus.init.RisusEntities;
import com.bigdious.risus.items.LitterItem;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class LitterItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public LitterItemRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext context, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        LivingEntity entity;
        if (stack.getItem() instanceof LitterItem && (entity = EntityCache.fetchEntity((EntityType)RisusEntities.LITTER.get(), (Level)Minecraft.getInstance().level, (BlockState)stack.getOrDefault(RisusDataComponents.BLOCK_STATE, (Object)Blocks.AIR.defaultBlockState()))) != null) {
            this.renderEntity((Entity)entity, context, ms, light);
        }
    }

    private void renderEntity(Entity entity, ItemDisplayContext context, PoseStack stack, int light) {
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaTicks();
        float partialTicksForRender = Minecraft.getInstance().isPaused() ? 0.0f : partialTicks;
        stack.scale(-1.0f, -1.0f, 1.0f);
        stack.translate(-0.5f, -0.2f, 0.0f);
        stack.scale(0.8f, 0.8f, 0.8f);
        stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        boolean hitboxes = dispatcher.shouldRenderHitBoxes();
        dispatcher.setRenderShadow(false);
        dispatcher.setRenderHitBoxes(false);
        MultiBufferSource.BufferSource source = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderSystem.runAsFancy(() -> dispatcher.render(entity, 0.0, 0.0, 0.0, 0.0f, partialTicksForRender, stack, (MultiBufferSource)source, context == ItemDisplayContext.GUI ? 0xF000F0 : light));
        source.endBatch();
        dispatcher.setRenderShadow(true);
        dispatcher.setRenderHitBoxes(hitboxes);
    }
}

