/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.entity;

import com.bigdious.risus.init.RisusDamageTypes;
import com.bigdious.risus.init.RisusFluids;
import com.bigdious.risus.init.RisusItems;
import com.bigdious.risus.init.RisusTags;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidType;

public class Angel
extends Monster {
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING = SynchedEntityData.defineId(Angel.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public Angel(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.xpReward = 0;
    }

    public static AttributeSupplier.Builder attributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.FOLLOW_RANGE, 40.0);
    }

    public void setCharging(boolean charging) {
        this.entityData.set(DATA_IS_CHARGING, (Object)charging);
    }

    public boolean isCharging() {
        return (Boolean)this.entityData.get(DATA_IS_CHARGING);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_CHARGING, (Object)false);
    }

    public boolean canSwimInFluidType(FluidType type) {
        if (type == RisusFluids.BLOOD_FLUID_TYPE.get()) {
            return false;
        }
        return super.canSwimInFluidType(type);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(5, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 50.0f));
        this.goalSelector.addGoal(7, (Goal)new AngelLightningAttackGoal(this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, entity -> Math.abs(entity.getY() - this.getY()) <= 50.0 && !entity.isInvulnerable() && !(entity instanceof ArmorStand) && !entity.getType().is(RisusTags.Entities.OFFSPRING) && !entity.getType().is(RisusTags.Entities.BELOVED)));
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) || source.is(RisusDamageTypes.AXED) || source.getWeaponItem() != null && (source.getWeaponItem().is(RisusTags.Items.WILLFUL_WEAPON) || source.getWeaponItem().is(RisusItems.SCYTHE) || source.getWeaponItem().is(RisusItems.FIRE_SCYTHE) || source.getWeaponItem().is(RisusItems.SOUL_SCYTHE) || source.getWeaponItem().is(RisusItems.CINDERGLEE_SCYTHE) || source.getWeaponItem().is(RisusItems.UNAWAKENED_VESSEL) || source.getWeaponItem().is(RisusItems.CRESCENT_DISASTER) || source.getWeaponItem().is(RisusItems.THOUSAND_BLADE))) {
            return super.hurt(source, Float.MAX_VALUE);
        }
        return false;
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    public boolean removeWhenFarAway(double dist) {
        return false;
    }

    static class AngelLightningAttackGoal
    extends Goal {
        private final Angel angel;
        public int chargeTime;

        public AngelLightningAttackGoal(Angel angel) {
            this.angel = angel;
        }

        public boolean canUse() {
            return this.angel.getTarget() != null && this.angel.level().getDifficulty() != Difficulty.PEACEFUL;
        }

        public void start() {
            this.chargeTime = 0;
        }

        public void stop() {
            this.angel.setCharging(false);
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity livingentity = this.angel.getTarget();
            Level level = this.angel.level();
            if (livingentity != null && livingentity.distanceToSqr((Entity)this.angel) < 4096.0 && this.angel.hasLineOfSight((Entity)livingentity) && level.canSeeSky(livingentity.blockPosition())) {
                ++this.chargeTime;
                if (this.chargeTime == 20) {
                    LightningBolt lightning = new LightningBolt(EntityType.LIGHTNING_BOLT, level);
                    lightning.setPos(livingentity.getX(), livingentity.getEyeY(), livingentity.getZ());
                    level.addFreshEntity((Entity)lightning);
                    this.chargeTime = -40;
                }
            } else if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            this.angel.setCharging(this.chargeTime > 10);
        }
    }
}

