/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.entity;

import com.bigdious.risus.entity.CacheTargetOnClient;
import com.bigdious.risus.init.RisusBlocks;
import com.bigdious.risus.init.RisusDamageTypes;
import com.bigdious.risus.init.RisusSoundEvents;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class Maw
extends Monster
implements CacheTargetOnClient {
    private static final EntityDataAccessor<Integer> DATA_ID_ATTACK_TARGET = SynchedEntityData.defineId(Maw.class, (EntityDataSerializer)EntityDataSerializers.INT);
    @Nullable
    private LivingEntity clientSideCachedAttackTarget;
    @Nullable
    private PrimedTnt eatenTNT;
    private int eatenTNTTimer;
    public boolean hasGutsAssigned;
    public final AnimationState biteAnim = new AnimationState();

    public Maw(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.setYRot(0.0f);
        this.setXRot(0.0f);
        this.xpReward = 0;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_ATTACK_TARGET, (Object)0);
    }

    protected void registerGoals() {
        this.targetSelector.addGoal(1, (Goal)new MawNearestAttackableGoal((Mob)this, LivingEntity.class, false, LivingEntity::attackable));
    }

    public static AttributeSupplier.Builder attributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 300.0).add(Attributes.ATTACK_DAMAGE, 40.0).add(Attributes.KNOCKBACK_RESISTANCE, 4.0);
    }

    public void tick() {
        if (this.firstTick && this.level().getBlockState(this.blockPosition().below()).is(RisusBlocks.MAW_GUTS)) {
            this.hasGutsAssigned = true;
        }
        if (this.tickCount % 60 == 0 && !this.firstTick && this.hasGutsAssigned && !this.level().getBlockState(this.blockPosition().below()).is(RisusBlocks.MAW_GUTS)) {
            this.kill();
        }
        super.tick();
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.eatenTNT != null) {
            ++this.eatenTNTTimer;
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.position().x(), this.position().y() + 0.5, this.position().z(), 2, (double)0.1f, (double)0.1f, (double)0.1f, 0.0);
            if (this.eatenTNTTimer >= 60) {
                this.hasGutsAssigned = false;
                this.hurt(Explosion.getDefaultDamageSource((Level)this.level(), (Entity)this.eatenTNT), Float.MAX_VALUE);
                this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 3.0f, Level.ExplosionInteraction.NONE);
            }
        }
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (this.hasGutsAssigned) {
            return !source.is(DamageTypeTags.IS_EXPLOSION) && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY);
        }
        return super.isInvulnerableTo(source);
    }

    public boolean isNoGravity() {
        return this.isDeadOrDying() || super.isNoGravity();
    }

    public boolean canBeSeenAsEnemy() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    public void knockback(double x, double y, double z) {
    }

    public boolean removeWhenFarAway(double dist) {
        return false;
    }

    public boolean attackable() {
        return false;
    }

    protected void pushEntities() {
        List list = this.level().getEntities((Entity)this, this.getBoundingBox(), EntitySelector.pushableBy((Entity)this).or(entity -> entity instanceof PrimedTnt).and(EntitySelector.NO_CREATIVE_OR_SPECTATOR));
        if (!list.isEmpty()) {
            int i = this.level().getGameRules().getInt(GameRules.RULE_MAX_ENTITY_CRAMMING);
            if (i > 0 && list.size() > i - 1 && this.random.nextInt(4) == 0) {
                int j = 0;
                for (Entity entity2 : list) {
                    if (entity2.isPassenger()) continue;
                    ++j;
                }
                if (j > i - 1) {
                    this.hurt(this.level().damageSources().cramming(), 6.0f);
                }
            }
            for (Entity entity3 : list) {
                this.doPush(entity3);
            }
        }
    }

    protected void doPush(Entity entity) {
        LivingEntity living;
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).attackable() && entity.level().getDifficulty() != Difficulty.PEACEFUL) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                living.setLastHurtByPlayer((Player)FakePlayerFactory.getMinecraft((ServerLevel)server));
            }
            if (entity.hurt(new DamageSource((Holder)this.level().registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(RisusDamageTypes.GLUTTONY)), (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue())) {
                this.doHurtTarget((Entity)living);
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)66);
        } else if (entity instanceof PrimedTnt) {
            PrimedTnt tnt;
            this.eatenTNT = tnt = (PrimedTnt)entity;
            tnt.discard();
        }
    }

    protected void tickDeath() {
        super.tickDeath();
        if (this.deathTime == 20 && !this.level().isClientSide() && this.level().getBlockState(this.blockPosition().below()).is((Block)RisusBlocks.MAW_GUTS.get())) {
            this.level().destroyBlock(this.blockPosition().below(), true);
            this.playSound((SoundEvent)RisusSoundEvents.MAW_GUTS_SHATTER.get());
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 66) {
            this.biteAnim.start(this.tickCount);
        }
        super.handleEntityEvent(id);
    }

    public void setActiveAttackTarget(int target) {
        this.entityData.set(DATA_ID_ATTACK_TARGET, (Object)target);
    }

    @Override
    @Nullable
    public LivingEntity getCachedAttackTarget() {
        return this.clientSideCachedAttackTarget;
    }

    @Override
    public void setCachedAttackTarget(@Nullable LivingEntity living) {
        this.clientSideCachedAttackTarget = living;
    }

    @Override
    public int getDataTarget() {
        return (Integer)this.getEntityData().get(DATA_ID_ATTACK_TARGET);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> accessor) {
        super.onSyncedDataUpdated(accessor);
        if (DATA_ID_ATTACK_TARGET.equals(accessor)) {
            this.clientSideCachedAttackTarget = null;
        }
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    private static class MawNearestAttackableGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        public MawNearestAttackableGoal(Mob mob, Class<LivingEntity> attack, boolean needsLOS, Predicate<LivingEntity> predicate) {
            super(mob, attack, needsLOS, predicate);
        }

        public void start() {
            super.start();
            ((Maw)this.mob).setActiveAttackTarget(this.target.getId());
        }

        public void stop() {
            super.stop();
            ((Maw)this.mob).setActiveAttackTarget(0);
        }
    }
}

