/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.entity;

import com.bigdious.risus.init.RisusBlocks;
import com.bigdious.risus.init.RisusEntities;
import com.bigdious.risus.init.RisusItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class RisusBoat
extends Boat {
    private static final EntityDataAccessor<Integer> BOAT_TYPE = SynchedEntityData.defineId(RisusBoat.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public RisusBoat(EntityType<? extends Boat> type, Level level) {
        super(type, level);
        this.blocksBuilding = true;
    }

    public RisusBoat(Level level, double x, double y, double z) {
        this((EntityType<? extends Boat>)((EntityType)RisusEntities.BOAT.get()), level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    public Type getRisusBoatType() {
        return Type.byId((Integer)this.getEntityData().get(BOAT_TYPE));
    }

    public Item getDropItem() {
        switch (this.getRisusBoatType().ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: 
        }
        return (Item)RisusItems.BONDKNOT_BOAT.get();
    }

    public void setRisusBoatType(Type boatType) {
        this.getEntityData().set(BOAT_TYPE, (Object)boatType.ordinal());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BOAT_TYPE, (Object)Type.BONDKNOT.ordinal());
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putString("Type", this.getRisusBoatType().getName());
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("Type", 8)) {
            this.setRisusBoatType(Type.getTypeFromString(compound.getString("Type")));
        }
    }

    public static enum Type {
        BONDKNOT((Block)RisusBlocks.BONDKNOT_PLANKS.get(), "bondknot");

        private final String name;
        private final Block block;

        private Type(Block block, String name) {
            this.name = name;
            this.block = block;
        }

        public String getName() {
            return this.name;
        }

        public Block asPlank() {
            return this.block;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int id) {
            Type[] aRisusBoatEntity$type = Type.values();
            if (id < 0 || id >= aRisusBoatEntity$type.length) {
                id = 0;
            }
            return aRisusBoatEntity$type[id];
        }

        public static Type getTypeFromString(String nameIn) {
            Type[] boatTypeArray;
            for (Type type : boatTypeArray = Type.values()) {
                if (!type.getName().equals(nameIn)) continue;
                return type;
            }
            return boatTypeArray[0];
        }
    }
}

