/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.entity.projectile;

import com.bigdious.risus.init.RisusDamageTypes;
import com.bigdious.risus.init.RisusEntities;
import com.bigdious.risus.init.RisusParticles;
import com.bigdious.risus.init.RisusSoundEvents;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class BloodSlash
extends Projectile {
    private static final EntityDataAccessor<Byte> ID_POWER = SynchedEntityData.defineId(BloodSlash.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> ID_PIERCING = SynchedEntityData.defineId(BloodSlash.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    @Nullable
    private IntOpenHashSet piercingIgnoreEntityIds;
    private float baseDamage;
    @Nullable
    private ItemStack weapon = null;

    public BloodSlash(EntityType<BloodSlash> type, Level level) {
        super(type, level);
    }

    public BloodSlash(Level level, LivingEntity owner, @Nullable ItemStack weapon) {
        super((EntityType)RisusEntities.BLOODSLASH.get(), level);
        this.setOwner((Entity)owner);
        this.setPos(owner.getX(), owner.getEyeY() - (double)0.1f, owner.getZ());
        this.baseDamage = 12.0f;
        this.weapon = weapon;
        if (weapon != null) {
            this.getEntityData().set(ID_POWER, (Object)((byte)weapon.getEnchantmentLevel(level.registryAccess().holderOrThrow(Enchantments.POWER))));
            this.getEntityData().set(ID_PIERCING, (Object)((byte)weapon.getEnchantmentLevel(level.registryAccess().holderOrThrow(Enchantments.PIERCING))));
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ID_POWER, (Object)0);
        builder.define(ID_PIERCING, (Object)0);
    }

    public byte getPierceLevel() {
        return (Byte)this.getEntityData().get(ID_PIERCING);
    }

    public void tick() {
        super.tick();
        HitResult blockResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
        HitResult entityResult = BloodSlash.getEntityHitResult(this.position(), (Entity)this, this::canHitEntity, this.getDeltaMovement(), this.level(), 0.3f, ClipContext.Block.COLLIDER);
        if (entityResult.getType() == HitResult.Type.ENTITY && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)entityResult)) {
            this.hitTargetOrDeflectSelf(entityResult);
        } else if (blockResult.getType() == HitResult.Type.BLOCK && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)blockResult)) {
            this.onHit(blockResult);
        }
        this.checkInsideBlocks();
        Vec3 vec3 = this.getDeltaMovement();
        double d0 = this.getX() + vec3.x;
        double d1 = this.getY() + vec3.y;
        double d2 = this.getZ() + vec3.z;
        this.updateRotation();
        this.setDeltaMovement(vec3.scale((double)0.99f));
        this.applyGravity();
        this.setPos(d0, d1, d2);
        this.level().addParticle((ParticleOptions)RisusParticles.BLOODSLASH_TRAIL.get(), true, this.getX(), this.getRandomY() - 1.5 + Math.random() * 2.8, this.getZ(), 0.0, 0.0, 0.0);
        if (this.tickCount % 40 == 0) {
            this.playSound((SoundEvent)RisusSoundEvents.BLOOD_SLASH_WHOOSH.get());
        }
        if (this.tickCount > 70) {
            this.kill();
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        float damage = this.baseDamage;
        damage += (float)((Byte)this.getEntityData().get(ID_POWER)).byteValue();
        Entity entity1 = this.getOwner();
        DamageSource damagesource = this.damageSources().source(RisusDamageTypes.BLOODSLASH, (Entity)(entity1 == null ? this : entity1));
        if (this.getPierceLevel() > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercingIgnoreEntityIds.size() >= this.getPierceLevel() + 1) {
                this.discard();
                return;
            }
            this.piercingIgnoreEntityIds.add(entity.getId());
        }
        if (entity.hurt(damagesource, damage)) {
            if (entity instanceof LivingEntity) {
                float f;
                Level level;
                LivingEntity livingentity = (LivingEntity)entity;
                if (this.weapon != null && (level = this.level()) instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)level;
                    f = EnchantmentHelper.modifyKnockback((ServerLevel)serverlevel, (ItemStack)this.weapon, (Entity)entity, (DamageSource)damagesource, (float)0.0f);
                } else {
                    f = 0.0f;
                }
                double d0 = f;
                if (d0 > 0.0) {
                    double d1 = Math.max(0.0, 1.0 - livingentity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
                    Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale(d0 * 0.6 * d1);
                    if (vec3.lengthSqr() > 0.0) {
                        entity.push(vec3.x, 0.1, vec3.z);
                    }
                }
                if ((level = this.level()) instanceof ServerLevel) {
                    ServerLevel serverlevel1 = (ServerLevel)level;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverlevel1, (Entity)livingentity, (DamageSource)damagesource, (ItemStack)this.getWeaponItem());
                }
            }
            if (this.getPierceLevel() <= 0) {
                this.discard();
            }
        }
    }

    protected boolean canHitEntity(Entity target) {
        return super.canHitEntity(target) && (this.piercingIgnoreEntityIds == null || !this.piercingIgnoreEntityIds.contains(target.getId()));
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.discard();
    }

    private static HitResult getEntityHitResult(Vec3 pos, Entity projectile, Predicate<Entity> filter, Vec3 deltaMovement, Level level, float margin, ClipContext.Block clipContext) {
        EntityHitResult hitresult1;
        AABB entityHitbox = projectile.getBoundingBox().inflate(0.0, 1.25, 0.0).move(0.0, -0.25, 0.0);
        Vec3 vec3 = pos.add(deltaMovement);
        BlockHitResult hitresult = level.clip(new ClipContext(pos, vec3, clipContext, ClipContext.Fluid.NONE, projectile));
        if (hitresult.getType() != HitResult.Type.MISS) {
            vec3 = hitresult.getLocation();
        }
        if ((hitresult1 = ProjectileUtil.getEntityHitResult((Level)level, (Entity)projectile, (Vec3)pos, (Vec3)vec3, (AABB)entityHitbox.expandTowards(deltaMovement).inflate(1.0), filter, (float)1.3f)) != null) {
            hitresult = hitresult1;
        }
        return hitresult;
    }
}

