/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.entity.projectile;

import com.bigdious.risus.init.RisusDamageTypes;
import com.bigdious.risus.init.RisusEntities;
import com.bigdious.risus.init.RisusItems;
import com.bigdious.risus.init.RisusSoundEvents;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownAxe
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.defineId(ThrownAxe.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.defineId(ThrownAxe.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Byte> ID_SHARPNESS = SynchedEntityData.defineId(ThrownAxe.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> ID_FIRE_ASPECT = SynchedEntityData.defineId(ThrownAxe.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private boolean dealtDamage;
    private boolean shouldSpin = true;
    public int spinTickCount;
    public int clientSideReturnAxeTickCount;

    public ThrownAxe(EntityType<ThrownAxe> type, Level level) {
        super(type, level);
    }

    public ThrownAxe(Level level, LivingEntity owner, ItemStack pPickupItemStack) {
        super((EntityType)RisusEntities.THROWN_AXE.get(), owner, level, pPickupItemStack, null);
        this.entityData.set(ID_LOYALTY, (Object)this.getLoyaltyFromItem(pPickupItemStack));
        this.entityData.set(ID_SHARPNESS, (Object)((byte)pPickupItemStack.getEnchantmentLevel(level.registryAccess().holderOrThrow(Enchantments.SHARPNESS))));
        this.entityData.set(ID_FIRE_ASPECT, (Object)((byte)pPickupItemStack.getEnchantmentLevel(level.registryAccess().holderOrThrow(Enchantments.FIRE_ASPECT))));
        this.entityData.set(ID_FOIL, (Object)pPickupItemStack.hasFoil());
    }

    private byte getLoyaltyFromItem(ItemStack p_345571_) {
        byte by;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            by = (byte)Mth.clamp((int)EnchantmentHelper.getTridentReturnToOwnerAcceleration((ServerLevel)serverlevel, (ItemStack)p_345571_, (Entity)this), (int)0, (int)127);
        } else {
            by = 0;
        }
        return by;
    }

    public boolean shouldSpin() {
        return this.shouldSpin;
    }

    public void tick() {
        if (this.level().isClientSide() && this.shouldSpin()) {
            ++this.spinTickCount;
        }
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.getOwner();
        byte i = (Byte)this.entityData.get(ID_LOYALTY);
        if (i > 0 && (this.dealtDamage || this.isNoPhysics()) && entity != null) {
            if (!this.isAcceptableReturnOwner()) {
                if (!this.level().isClientSide() && this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            } else {
                this.setNoPhysics(true);
                Vec3 vec3 = entity.getEyePosition().subtract(this.position());
                this.setPosRaw(this.getX(), this.getY() + vec3.y() * 0.015 * (double)i, this.getZ());
                if (this.level().isClientSide()) {
                    this.yOld = this.getY();
                }
                double d0 = 0.05 * (double)i;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(vec3.normalize().scale(d0)));
                if (this.clientSideReturnAxeTickCount == 0) {
                    this.playSound((SoundEvent)RisusSoundEvents.CRESCENT_DISASTER_RETURN.get(), 10.0f, 1.0f);
                }
                ++this.clientSideReturnAxeTickCount;
            }
        }
        super.tick();
    }

    private boolean isAcceptableReturnOwner() {
        Entity entity = this.getOwner();
        return entity != null && entity.isAlive() && (!(entity instanceof ServerPlayer) || !entity.isSpectator());
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)RisusItems.CRESCENT_DISASTER.get());
    }

    public boolean isFoil() {
        return (Boolean)this.entityData.get(ID_FOIL);
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 p_37575_, Vec3 p_37576_) {
        return this.dealtDamage ? null : super.findHitEntity(p_37575_, p_37576_);
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.shouldSpin = false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(ID_LOYALTY, (Object)0);
        pBuilder.define(ID_SHARPNESS, (Object)0);
        pBuilder.define(ID_FIRE_ASPECT, (Object)0);
        pBuilder.define(ID_FOIL, (Object)false);
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        Entity entity1 = this.getOwner();
        DamageSource damagesource = this.damageSources().source(RisusDamageTypes.AXED, (Entity)(entity1 == null ? this : entity1));
        this.dealtDamage = true;
        if (entity.hurt(damagesource, (Byte)this.entityData.get(ID_SHARPNESS) < 1 ? 9.0f : 9.0f + (0.5f * (float)((Byte)this.entityData.get(ID_SHARPNESS)).byteValue() + 0.5f))) {
            if (entity.getType() == EntityType.ENDERMAN) {
                return;
            }
            if ((Byte)this.entityData.get(ID_FIRE_ASPECT) > 0) {
                entity.igniteForSeconds((float)((Byte)this.entityData.get(ID_FIRE_ASPECT) * 80));
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)entity;
                if (entity1 instanceof LivingEntity) {
                    this.doPostHurtEffects(livingentity1);
                }
                this.doPostHurtEffects(livingentity1);
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
        float f1 = 1.0f;
        this.playSound((SoundEvent)RisusSoundEvents.CRESCENT_DISASTER_HIT.get(), f1, 1.0f);
        this.shouldSpin = false;
    }

    protected boolean tryPickup(Player player) {
        switch (this.random.nextInt(999)) {
            case 1: {
                player.displayClientMessage((Component)Component.translatable((String)"entity.risus.thrown_axe.message1").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED)), true);
                break;
            }
            case 2: {
                player.displayClientMessage((Component)Component.translatable((String)"entity.risus.thrown_axe.message2").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED)), true);
                break;
            }
            case 3: {
                player.displayClientMessage((Component)Component.translatable((String)"entity.risus.thrown_axe.message3").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED)), true);
                break;
            }
            case 4: {
                player.displayClientMessage((Component)Component.translatable((String)"entity.risus.thrown_axe.message4").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED)), true);
                break;
            }
            case 5: {
                player.displayClientMessage((Component)Component.translatable((String)"entity.risus.thrown_axe.message5").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED)), true);
                break;
            }
            case 6: {
                player.displayClientMessage((Component)Component.translatable((String)"entity.risus.thrown_axe.message6").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED)), true);
                break;
            }
            case 7: {
                player.displayClientMessage((Component)Component.translatable((String)"entity.risus.thrown_axe.message7").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED)), true);
                break;
            }
            case 8: {
                player.displayClientMessage((Component)Component.translatable((String)"entity.risus.thrown_axe.message8").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED)), true);
                break;
            }
            case 9: {
                player.displayClientMessage((Component)Component.translatable((String)"entity.risus.thrown_axe.message9").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED)), true);
                break;
            }
            case 10: {
                player.displayClientMessage((Component)Component.translatable((String)"entity.risus.thrown_axe.message10").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED)), true);
                break;
            }
            case 11: {
                player.displayClientMessage((Component)Component.translatable((String)"entity.risus.thrown_axe.message11").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED)), true);
                break;
            }
            case 12: {
                player.displayClientMessage((Component)Component.translatable((String)"entity.risus.thrown_axe.message12").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED)), true);
                break;
            }
            case 13: {
                player.displayClientMessage((Component)Component.translatable((String)"entity.risus.thrown_axe.message13").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED)), true);
                break;
            }
            case 14: {
                player.displayClientMessage((Component)Component.translatable((String)"entity.risus.thrown_axe.message14").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED)), true);
                break;
            }
            case 15: {
                player.displayClientMessage((Component)Component.translatable((String)"entity.risus.thrown_axe.message15").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED)), true);
                break;
            }
            case 16: {
                player.displayClientMessage((Component)Component.translatable((String)"entity.risus.thrown_axe.message16").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED)), true);
                break;
            }
            case 17: {
                player.displayClientMessage((Component)Component.translatable((String)"entity.risus.thrown_axe.message17").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED)), true);
                break;
            }
            case 18: {
                player.displayClientMessage((Component)Component.translatable((String)"entity.risus.thrown_axe.message18").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED)), true);
                break;
            }
            case 19: {
                player.displayClientMessage((Component)Component.translatable((String)"entity.risus.thrown_axe.message19").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED)), true);
                break;
            }
            case 20: {
                player.displayClientMessage((Component)Component.translatable((String)"entity.risus.thrown_axe.message20").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED)), true);
                break;
            }
            case 21: {
                player.displayClientMessage((Component)Component.translatable((String)"entity.risus.thrown_axe.message21").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED)), true);
                break;
            }
            case 22: {
                player.displayClientMessage((Component)Component.translatable((String)"entity.risus.thrown_axe.message0").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED)), true);
                break;
            }
        }
        return super.tryPickup(player) || this.isNoPhysics() && this.ownedBy((Entity)player) && player.getInventory().add(this.getPickupItem());
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return (SoundEvent)RisusSoundEvents.CRESCENT_DISASTER_HIT_GROUND.get();
    }

    public void playerTouch(Player player) {
        if (this.ownedBy((Entity)player) || this.getOwner() == null) {
            super.playerTouch(player);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.dealtDamage = tag.getBoolean("DealtDamage");
        this.entityData.set(ID_LOYALTY, (Object)this.getLoyaltyFromItem(this.getPickupItemStackOrigin()));
        this.entityData.set(ID_SHARPNESS, (Object)((byte)this.getPickupItemStackOrigin().getEnchantmentLevel(this.level().registryAccess().holderOrThrow(Enchantments.SHARPNESS))));
        this.entityData.set(ID_FIRE_ASPECT, (Object)((byte)this.getPickupItemStackOrigin().getEnchantmentLevel(this.level().registryAccess().holderOrThrow(Enchantments.FIRE_ASPECT))));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("DealtDamage", this.dealtDamage);
    }

    public void tickDespawn() {
        byte i = (Byte)this.entityData.get(ID_LOYALTY);
        if (this.pickup != AbstractArrow.Pickup.ALLOWED || i <= 0) {
            super.tickDespawn();
        }
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }
}

