/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.init;

import com.bigdious.risus.init.RisusSoundEvents;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.JukeboxSong;
import net.neoforged.neoforge.registries.DeferredHolder;

public class RisusJukeboxSongs {
    public static final ResourceKey<JukeboxSong> RAK = RisusJukeboxSongs.create("rak");
    public static final ResourceKey<JukeboxSong> REGN = RisusJukeboxSongs.create("regn");
    public static final ResourceKey<JukeboxSong> FEIGR = RisusJukeboxSongs.create("feigr");
    public static final ResourceKey<JukeboxSong> MORK = RisusJukeboxSongs.create("mork");

    private static ResourceKey<JukeboxSong> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.JUKEBOX_SONG, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"risus", (String)name));
    }

    private static void register(BootstrapContext<JukeboxSong> context, ResourceKey<JukeboxSong> key, DeferredHolder<SoundEvent, SoundEvent> sound, float length, int output) {
        context.register(key, (Object)new JukeboxSong(sound, (Component)Component.translatable((String)Util.makeDescriptionId((String)"jukebox_song", (ResourceLocation)key.location())), length, output));
    }

    public static void bootstrap(BootstrapContext<JukeboxSong> context) {
        RisusJukeboxSongs.register(context, RAK, RisusSoundEvents.MUSIC_DISC_RAK, 135.0f, 15);
        RisusJukeboxSongs.register(context, REGN, RisusSoundEvents.MUSIC_DISC_REGN, 121.0f, 14);
        RisusJukeboxSongs.register(context, FEIGR, RisusSoundEvents.MUSIC_DISC_FEIGR, 82.0f, 10);
        RisusJukeboxSongs.register(context, MORK, RisusSoundEvents.MUSIC_DISC_MORK, 67.0f, 7);
    }
}

