/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.items;

import com.bigdious.risus.Risus;
import com.bigdious.risus.entity.LightningResistantItemEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BloodFeatherItem
extends Item {
    public BloodFeatherItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemAttributeModifiers createBloodFeatherAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.GRAVITY, new AttributeModifier(Risus.prefix("gravity_modifier"), -0.6, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.ANY).add(Attributes.SAFE_FALL_DISTANCE, new AttributeModifier(Risus.prefix("safe_fall_distance_modifier"), 4.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.ANY).build();
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(Level level, Entity location, ItemStack stack) {
        LightningResistantItemEntity entity = new LightningResistantItemEntity(level, location.getX(), location.getY(), location.getZ(), stack);
        entity.setDeltaMovement(location.getDeltaMovement());
        entity.setDefaultPickUpDelay();
        return entity;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.risus.blood_feather").withStyle(ChatFormatting.GRAY));
    }
}

