/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.items;

import com.bigdious.risus.Risus;
import com.bigdious.risus.blocks.BaseRotatableBlock;
import com.bigdious.risus.entity.Litter;
import com.bigdious.risus.init.RisusBlocks;
import com.bigdious.risus.init.RisusSoundEvents;
import com.bigdious.risus.init.RisusTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ConcentrationCoreItem
extends Item {
    private static final BlockPattern RITUAL = BlockPatternBuilder.start().aisle(new String[]{"   y   "}).aisle(new String[]{"ye z ny"}).aisle(new String[]{" yxBxy "}).aisle(new String[]{"ys z wy"}).aisle(new String[]{"   y   "}).where('n', BlockInWorld.hasState(state -> state.is((Block)RisusBlocks.CURVED_RITUAL_BLOCK.get()) && state.getValue((Property)BaseRotatableBlock.FACING) == Direction.NORTH)).where('e', BlockInWorld.hasState(state -> state.is((Block)RisusBlocks.CURVED_RITUAL_BLOCK.get()) && state.getValue((Property)BaseRotatableBlock.FACING) == Direction.EAST)).where('s', BlockInWorld.hasState(state -> state.is((Block)RisusBlocks.CURVED_RITUAL_BLOCK.get()) && state.getValue((Property)BaseRotatableBlock.FACING) == Direction.SOUTH)).where('w', BlockInWorld.hasState(state -> state.is((Block)RisusBlocks.CURVED_RITUAL_BLOCK.get()) && state.getValue((Property)BaseRotatableBlock.FACING) == Direction.WEST)).where('y', BlockInWorld.hasState(state -> state.is((Block)RisusBlocks.LINEAR_RITUAL_BLOCK.get()) && state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y)).where('z', BlockInWorld.hasState(state -> state.is((Block)RisusBlocks.LINEAR_RITUAL_BLOCK.get()) && state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Z)).where('x', BlockInWorld.hasState(state -> state.is((Block)RisusBlocks.LINEAR_RITUAL_BLOCK.get()) && state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.X)).where('B', BlockInWorld.hasState(state -> state.is(RisusTags.Blocks.LITTER_ALLOWED_LIGHT_BLOCKS) || state.is(RisusTags.Blocks.ILLEGAL_LITTER_ALLOWED_LIGHT_BLOCKS))).build();
    private static final BlockPattern RITUAL_SIDEWAYS = BlockPatternBuilder.start().aisle(new String[]{" y y "}).aisle(new String[]{" wys "}).aisle(new String[]{"  z  "}).aisle(new String[]{"yxBxy"}).aisle(new String[]{"  z  "}).aisle(new String[]{" nye "}).aisle(new String[]{" y y "}).where('n', BlockInWorld.hasState(state -> state.is((Block)RisusBlocks.CURVED_RITUAL_BLOCK.get()) && state.getValue((Property)BaseRotatableBlock.FACING) == Direction.NORTH)).where('e', BlockInWorld.hasState(state -> state.is((Block)RisusBlocks.CURVED_RITUAL_BLOCK.get()) && state.getValue((Property)BaseRotatableBlock.FACING) == Direction.EAST)).where('s', BlockInWorld.hasState(state -> state.is((Block)RisusBlocks.CURVED_RITUAL_BLOCK.get()) && state.getValue((Property)BaseRotatableBlock.FACING) == Direction.SOUTH)).where('w', BlockInWorld.hasState(state -> state.is((Block)RisusBlocks.CURVED_RITUAL_BLOCK.get()) && state.getValue((Property)BaseRotatableBlock.FACING) == Direction.WEST)).where('y', BlockInWorld.hasState(state -> state.is((Block)RisusBlocks.LINEAR_RITUAL_BLOCK.get()) && state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y)).where('z', BlockInWorld.hasState(state -> state.is((Block)RisusBlocks.LINEAR_RITUAL_BLOCK.get()) && state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Z)).where('x', BlockInWorld.hasState(state -> state.is((Block)RisusBlocks.LINEAR_RITUAL_BLOCK.get()) && state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.X)).where('B', BlockInWorld.hasState(state -> state.is(RisusTags.Blocks.LITTER_ALLOWED_LIGHT_BLOCKS) || state.is(RisusTags.Blocks.ILLEGAL_LITTER_ALLOWED_LIGHT_BLOCKS))).build();

    public ConcentrationCoreItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPattern.BlockPatternMatch ritual;
        BlockPos pos;
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        if ((state.is(RisusTags.Blocks.LITTER_ALLOWED_LIGHT_BLOCKS) || level.getGameRules().getBoolean(Risus.ILLEGAL_LITTERS.get()) && state.is(RisusTags.Blocks.ILLEGAL_LITTER_ALLOWED_LIGHT_BLOCKS)) && (ritual = this.getUsedRitual(level, pos)) != null) {
            level.setBlockAndUpdate(pos, Blocks.GLASS.defaultBlockState());
            ParticleUtils.spawnParticlesOnBlockFaces((Level)level, (BlockPos)pos.above(), (ParticleOptions)ParticleTypes.END_ROD, (IntProvider)UniformInt.of((int)3, (int)7));
            level.playSound(null, context.getClickedPos(), (SoundEvent)RisusSoundEvents.CONCENTRATION_CORE_LITTER.get(), SoundSource.PLAYERS);
            Litter summonedLitter = new Litter(level, context.getPlayer());
            summonedLitter.setLightBlockState(state);
            summonedLitter.moveTo(Vec3.atBottomCenterOf((Vec3i)pos.above()));
            level.addFreshEntity((Entity)summonedLitter);
            for (int x = 0; x < ritual.getWidth(); ++x) {
                for (int y = 0; y < ritual.getHeight(); ++y) {
                    for (int z = 0; z < ritual.getDepth(); ++z) {
                        BlockInWorld worldBlock = ritual.getBlock(x, y, z);
                        if (!worldBlock.getState().is(RisusBlocks.CURVED_RITUAL_BLOCK) && !worldBlock.getState().is(RisusBlocks.LINEAR_RITUAL_BLOCK)) continue;
                        level.setBlockAndUpdate(worldBlock.getPos(), ((Block)RisusBlocks.ASHEN_REMAINS.get()).defaultBlockState());
                        level.addDestroyBlockEffect(worldBlock.getPos(), ((Block)RisusBlocks.ASHEN_REMAINS.get()).defaultBlockState());
                    }
                }
            }
            context.getItemInHand().consume(1, (LivingEntity)context.getPlayer());
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useOn(context);
    }

    @Nullable
    private BlockPattern.BlockPatternMatch getUsedRitual(Level level, BlockPos pos) {
        BlockPattern.BlockPatternMatch normal = RITUAL.find((LevelReader)level, pos);
        if (normal != null) {
            return normal;
        }
        return RITUAL_SIDEWAYS.find((LevelReader)level, pos);
    }
}

