/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.items;

import com.bigdious.risus.init.RisusSoundEvents;
import com.bigdious.risus.init.RisusTags;
import com.bigdious.risus.items.ToothknockerItem;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;

public class GoldFistItem
extends ToothknockerItem {
    public GoldFistItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        RandomSource random = RandomSource.create();
        Level level = entity.level();
        int i = random.nextInt(9);
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (entity.getType() != EntityType.PLAYER && !entity.getType().is(RisusTags.Entities.CANT_BE_STOLEN_FROM)) {
                int rand = random.nextInt(20);
                if (rand >= 4) return super.onLeftClickEntity(stack, player, entity);
                EquipmentSlot slot = EquipmentSlot.values()[rand + 2];
                if (!target.hasItemInSlot(slot)) return super.onLeftClickEntity(stack, player, entity);
                ItemEntity item = new ItemEntity(level, player.getX(), player.getY(), player.getZ(), target.getItemBySlot(slot));
                level.addFreshEntity((Entity)item);
                if (!item.isAddedToLevel()) return super.onLeftClickEntity(stack, player, entity);
                level.playSound(player, player.getOnPos(), (SoundEvent)RisusSoundEvents.STRIPPER_STRIP.get(), SoundSource.PLAYERS);
                target.setItemSlot(slot, ItemStack.EMPTY);
                return super.onLeftClickEntity(stack, player, entity);
            }
        }
        if (!(entity instanceof Player)) return super.onLeftClickEntity(stack, player, entity);
        Player playertarget = (Player)entity;
        if (player.getUUID() == UUID.fromString("4b455c5e-d81f-441c-906e-768708f6ca32")) {
            playertarget.getInventory().dropAll();
            level.playSound(player, player.getOnPos(), (SoundEvent)RisusSoundEvents.STRIPPER_STRIP.get(), SoundSource.PLAYERS);
            player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.DARK_RED) + "Your items are being repossessed due to outstanding debt.")));
            return super.onLeftClickEntity(stack, player, entity);
        }
        if (playertarget.getInventory().getItem(i).isEmpty()) return super.onLeftClickEntity(stack, player, entity);
        ItemEntity item = new ItemEntity(level, player.getX(), player.getY(), player.getZ(), playertarget.getInventory().getItem(i));
        level.addFreshEntity((Entity)item);
        if (!item.isAddedToLevel()) return super.onLeftClickEntity(stack, player, entity);
        level.playSound(player, player.getOnPos(), (SoundEvent)RisusSoundEvents.STRIPPER_STRIP.get(), SoundSource.PLAYERS);
        playertarget.getInventory().setItem(i, ItemStack.EMPTY);
        return super.onLeftClickEntity(stack, player, entity);
    }
}

