/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.items;

import com.bigdious.risus.Risus;
import com.bigdious.risus.blocks.BaseRotatableBlock;
import com.bigdious.risus.blocks.entity.RitualBlockEntity;
import com.bigdious.risus.init.RisusBlocks;
import com.bigdious.risus.init.RisusItems;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;

public class ScytheItem
extends SwordItem {
    public static final Function<Block, BlockPattern> RITUAL = block -> BlockPatternBuilder.start().aisle(new String[]{"     f     "}).aisle(new String[]{"     z     "}).aisle(new String[]{"    nye    "}).aisle(new String[]{"    fzf    "}).aisle(new String[]{"  nfnyefe  "}).aisle(new String[]{"fxyxybyxyxf"}).aisle(new String[]{"  wfwysfs  "}).aisle(new String[]{"    fzf    "}).aisle(new String[]{"    wys    "}).aisle(new String[]{"     z     "}).aisle(new String[]{"     f     "}).where('n', BlockInWorld.hasState(state -> state.is((Block)RisusBlocks.CURVED_RITUAL_BLOCK.get()) && state.getValue((Property)BaseRotatableBlock.FACING) == Direction.NORTH)).where('e', BlockInWorld.hasState(state -> state.is((Block)RisusBlocks.CURVED_RITUAL_BLOCK.get()) && state.getValue((Property)BaseRotatableBlock.FACING) == Direction.EAST)).where('s', BlockInWorld.hasState(state -> state.is((Block)RisusBlocks.CURVED_RITUAL_BLOCK.get()) && state.getValue((Property)BaseRotatableBlock.FACING) == Direction.SOUTH)).where('w', BlockInWorld.hasState(state -> state.is((Block)RisusBlocks.CURVED_RITUAL_BLOCK.get()) && state.getValue((Property)BaseRotatableBlock.FACING) == Direction.WEST)).where('y', BlockInWorld.hasState(state -> state.is((Block)RisusBlocks.LINEAR_RITUAL_BLOCK.get()) && state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y)).where('z', BlockInWorld.hasState(state -> state.is((Block)RisusBlocks.LINEAR_RITUAL_BLOCK.get()) && state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Z)).where('x', BlockInWorld.hasState(state -> state.is((Block)RisusBlocks.LINEAR_RITUAL_BLOCK.get()) && state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.X)).where('f', BlockInWorld.hasState(state -> state.is(block))).where('b', BlockInWorld.hasState(state -> state.is(RisusBlocks.BLOOD_FLUID_BLOCK) || state.is(RisusBlocks.RITUAL))).build();
    public static final Map<Block, Pair<Block, ItemLike>> RITUAL_CONVERSIONS = Map.of(Blocks.CAMPFIRE, Pair.of((Object)Blocks.FIRE, RisusItems.FIRE_SCYTHE), Blocks.SOUL_CAMPFIRE, Pair.of((Object)Blocks.SOUL_FIRE, RisusItems.SOUL_SCYTHE), (Block)RisusBlocks.JOYFLAME_CAMPFIRE.get(), Pair.of((Object)((Block)RisusBlocks.JOYFLAME_FIRE.get()), RisusItems.CINDERGLEE_SCYTHE));
    private final TagKey<Enchantment> allowedEnchants;

    public ScytheItem(Tier material, TagKey<Enchantment> allowedEnchants, Item.Properties properties) {
        super(material, properties);
        this.allowedEnchants = allowedEnchants;
    }

    public static ItemAttributeModifiers createScytheAttributes(Tier tier, int damage, float speed) {
        return SwordItem.createAttributes((Tier)tier, (int)damage, (float)speed).withModifierAdded(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(Risus.prefix("range_modifier"), 1.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.SWEEPING_DAMAGE_RATIO, new AttributeModifier(Risus.prefix("range_modifier"), 1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
    }

    public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(this.allowedEnchants);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(this.allowedEnchants);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        BlockState blockstate = level.getBlockState(blockpos);
        Player player = context.getPlayer();
        ItemStack scythe = player.getMainHandItem();
        if (!scythe.is(RisusItems.SCYTHE)) {
            return super.useOn(context);
        }
        if (RITUAL_CONVERSIONS.containsKey(blockstate.getBlock()) && ((Boolean)blockstate.getValue((Property)CampfireBlock.LIT)).booleanValue() && RITUAL.apply((Block)RITUAL_CONVERSIONS.get(blockstate.getBlock()).getFirst()).find((LevelReader)level, blockpos.below()) != null) {
            level.setBlockAndUpdate(blockpos.below(), ((Block)RisusBlocks.RITUAL.get()).defaultBlockState());
            BlockEntity blockEntity = level.getBlockEntity(blockpos.below());
            if (blockEntity instanceof RitualBlockEntity) {
                RitualBlockEntity ritual = (RitualBlockEntity)blockEntity;
                ritual.setTheItem(scythe.consumeAndReturn(1, (LivingEntity)context.getPlayer()));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static class ItemExtensions
    implements IClientItemExtensions {
        public static final ItemExtensions INSTANCE = new ItemExtensions();

        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
            return HumanoidModel.ArmPose.valueOf((String)"RISUS_SCYTHE");
        }
    }
}

