/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.items;

import com.bigdious.risus.Risus;
import com.bigdious.risus.entity.projectile.BloodSlash;
import com.bigdious.risus.init.RisusDamageTypes;
import com.bigdious.risus.init.RisusSoundEvents;
import com.bigdious.risus.init.RisusTags;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;

public class ThousandBladeItem
extends SwordItem {
    public ThousandBladeItem(Tier material, Item.Properties properties) {
        super(material, properties);
    }

    public static ItemAttributeModifiers createThousandBladeAttributes(Tier tier, int damage, float speed) {
        return SwordItem.createAttributes((Tier)tier, (int)damage, (float)speed).withModifierAdded(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(Risus.prefix("knockback_res_modifier"), 0.1, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(Risus.prefix("range_modifier"), 1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.MOVEMENT_SPEED, new AttributeModifier(Risus.prefix("speed_modifier"), (double)-0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), EquipmentSlotGroup.MAINHAND);
    }

    public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(RisusTags.Enchantments.THOUSAND_BLADE_ALLOWED_ENCHANTS);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.getDamageValue() >= itemstack.getMaxDamage() - 1) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(RisusTags.Enchantments.THOUSAND_BLADE_ALLOWED_ENCHANTS);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int useTicks) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int i = this.getUseDuration(stack, entity) - useTicks;
            if (i >= 20) {
                if (!level.isClientSide()) {
                    stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                    if (stack.getEnchantmentLevel(level.registryAccess().holderOrThrow(Enchantments.MULTISHOT)) > 0) {
                        player.hurt(entity.damageSources().source(RisusDamageTypes.VAMPIRISM), 3.0f);
                        BloodSlash slash = new BloodSlash(level, (LivingEntity)player, stack);
                        BloodSlash slash1 = new BloodSlash(level, (LivingEntity)player, stack);
                        BloodSlash slash2 = new BloodSlash(level, (LivingEntity)player, stack);
                        slash.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.3f, 1.0f);
                        slash1.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() + 10.0f, 0.0f, 1.3f, 1.0f);
                        slash2.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() - 10.0f, 0.0f, 1.3f, 1.0f);
                        level.addFreshEntity((Entity)slash);
                        level.addFreshEntity((Entity)slash1);
                        level.addFreshEntity((Entity)slash2);
                        level.playSound(null, (Entity)entity, (SoundEvent)RisusSoundEvents.THOUSAND_BLADE_SLASH.get(), SoundSource.NEUTRAL, 1.0f, 0.6f);
                    } else {
                        player.hurt(entity.damageSources().source(RisusDamageTypes.VAMPIRISM), 1.0f);
                        BloodSlash slash = new BloodSlash(level, (LivingEntity)player, stack);
                        slash.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.3f, 1.0f);
                        level.addFreshEntity((Entity)slash);
                        level.playSound(null, (Entity)entity, (SoundEvent)RisusSoundEvents.THOUSAND_BLADE_SLASH.get(), SoundSource.NEUTRAL, 1.0f, 0.6f);
                    }
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public static class ItemExtensions
    implements IClientItemExtensions {
        public static final ItemExtensions INSTANCE = new ItemExtensions();

        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
            return HumanoidModel.ArmPose.valueOf((String)"RISUS_THOUSAND_BLADE");
        }
    }
}

