/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.network;

import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CreateCritParticlePacket(int entityID, int duration, float entityEyeHeight, ParticleOptions particle) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CreateCritParticlePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"risus", (String)"create_crit_particle"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CreateCritParticlePacket> STREAM_CODEC = CustomPacketPayload.codec(CreateCritParticlePacket::write, CreateCritParticlePacket::new);

    public CreateCritParticlePacket(RegistryFriendlyByteBuf buf) {
        this(buf.readInt(), buf.readInt(), buf.readFloat(), (ParticleOptions)ParticleTypes.STREAM_CODEC.decode((Object)buf));
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.entityID());
        buf.writeInt(this.duration());
        buf.writeFloat(this.entityEyeHeight());
        ParticleTypes.STREAM_CODEC.encode((Object)buf, (Object)this.particle());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CreateCritParticlePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity entity = Minecraft.getInstance().level.getEntity(packet.entityID());
            if (entity != null) {
                Minecraft.getInstance().particleEngine.createTrackingEmitter(entity, packet.particle(), packet.duration());
            }
        });
    }
}

