/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.config.HordeConfig;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.world.spawner.UndeadSpawner;

public class HordeMobsCommand {
    public HordeMobsCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"undeadnights").then(Commands.literal((String)"horde_mobs").then(Commands.literal((String)"remove_all").executes(command -> this.removeMobs((CommandSourceStack)command.getSource())))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"undeadnights").then(Commands.literal((String)"horde_mobs").then(Commands.literal((String)"print_config").executes(command -> this.printConfig((CommandSourceStack)command.getSource())))));
    }

    private int removeMobs(CommandSourceStack source) throws CommandSyntaxException {
        int count = 0;
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.command_remove_horde_mobs"));
        }
        for (UUID hordeMobUUID : UndeadNights.serverState.spawnedHordeMobs.stream().toList()) {
            ++count;
            Entity entity2 = (Entity)source.getLevel().getEntities().get(hordeMobUUID);
            if (entity2 != null) {
                entity2.discard();
                continue;
            }
            UndeadNights.serverState.hordeMobsToRemove.add(hordeMobUUID);
        }
        if (MainConfig.getPrintDebugMessages()) {
            UndeadNights.LOGGER.info("{} horde mobs removed or marked for removal", (Object)count);
        }
        return 0;
    }

    private int printConfig(CommandSourceStack source) throws CommandSyntaxException {
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (HordeConfig.getReadingConfigFailed()) {
                serverPlayer.sendSystemMessage((Component)Component.literal((String)"Reading the horde mob config failed!\nSpawning 15 default horde zombies instead.").withStyle(ChatFormatting.YELLOW));
                return 0;
            }
            StringBuilder message = new StringBuilder("Variant: " + HordeConfig.getConfigVariant() + "\n");
            if (HordeConfig.getConfigVariant() == 1) {
                message.append("defaultHordeMob: ").append(HordeConfig.getDefaultHordeMob().mobId()).append("\n");
                if (!HordeConfig.getHordeMobs().isEmpty()) {
                    for (HordeConfig.MobSpawnData hordeMob : HordeConfig.getHordeMobs()) {
                        message.append(hordeMob.mobId()).append(" chance: ").append(hordeMob.chance()).append("\n");
                    }
                }
            } else if (!HordeConfig.getHordeMobs().isEmpty()) {
                for (HordeConfig.MobSpawnData hordeMob : HordeConfig.getHordeMobs()) {
                    message.append(hordeMob.mobId());
                    if (hordeMob.countMin() >= hordeMob.countMax()) {
                        message.append(" count: ").append(hordeMob.countMin()).append("\n");
                        continue;
                    }
                    message.append(" count: ").append(hordeMob.countMin()).append("-").append(hordeMob.countMax()).append("\n");
                }
            }
            serverPlayer.sendSystemMessage((Component)Component.literal((String)message.toString()));
            if (UndeadSpawner.invalidHordeMobEntry) {
                serverPlayer.sendSystemMessage((Component)Component.literal((String)"A horde mob entry in the horde mob config could not be read!\nA default horde zombie will be spawned instead.").withStyle(ChatFormatting.YELLOW));
            }
        }
        return 0;
    }
}

