/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.config.MainConfig;

public class SpawnHordeCommand {
    public static boolean spawnHorde = false;
    public static Collection<? extends Entity> entities = null;

    public SpawnHordeCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"undeadnights").then(Commands.literal((String)"spawn_horde").executes(command -> this.spawnHorde((CommandSourceStack)command.getSource()))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"undeadnights").then(Commands.literal((String)"spawn_horde").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).executes(command -> this.spawnHorde((CommandSourceStack)command.getSource(), EntityArgument.getEntities((CommandContext)command, (String)"targets"))))));
    }

    private int spawnHorde(CommandSourceStack source) throws CommandSyntaxException {
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (UndeadNights.globalSpawnCounter < MainConfig.getHordeMobsSpawnCap()) {
                spawnHorde = true;
                serverPlayer.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.command_spawn_horde_all"));
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("Command to spawn hordes for all players issued.");
                }
            } else {
                serverPlayer.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.spawn_cap_reached"));
            }
        }
        return 0;
    }

    private int spawnHorde(CommandSourceStack source, Collection<? extends Entity> pTargets) throws CommandSyntaxException {
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (UndeadNights.globalSpawnCounter < MainConfig.getHordeMobsSpawnCap()) {
                spawnHorde = true;
                entities = pTargets;
                serverPlayer.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.command_spawn_horde"));
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("Command to spawn hordes for certain players issued.");
                }
            } else {
                serverPlayer.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.spawn_cap_reached"));
            }
        }
        return 0;
    }
}

