/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.world.spawner;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.command.SpawnHordeCommand;
import net.petemc.undeadnights.config.HordeConfig;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.entity.DemolitionZombieEntity;
import net.petemc.undeadnights.entity.HordeZombieEntity;
import net.petemc.undeadnights.entity.ModEntities;
import net.petemc.undeadnights.sound.UndeadNightsSounds;
import net.petemc.undeadnights.util.StateSaverAndLoader;
import org.jetbrains.annotations.NotNull;

public class UndeadSpawner
implements CustomSpawner {
    public static boolean invalidHordeMobEntry = false;
    private double x = 0.0;
    private double z = 0.0;
    private double d = 0.0;

    private boolean checkSpawnLocation(ServerLevel level, double x, double y, double z) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(x, y, z);
        BlockState blockState = level.getBlockState((BlockPos)mutable);
        Block block = blockState.getBlock();
        boolean doesNotblockMovement = block != Blocks.COBWEB && block != Blocks.BAMBOO_SAPLING;
        boolean notWater = true;
        if (!MainConfig.getHordeWavesCanSpawnInWater()) {
            notWater = !blockState.getFluidState().is(FluidTags.WATER);
        }
        boolean notLeaves = true;
        if (!MainConfig.getHordeWavesCanSpawnOnTrees()) {
            notLeaves = !(blockState.getBlock() instanceof LeavesBlock);
        }
        return doesNotblockMovement && notLeaves && notWater;
    }

    private BlockPos getBlockPosWithDistance(BlockPos pos, Level level, int distanceMin, int distanceMax) {
        RandomSource random = level.random;
        double _d = 0.0;
        double _x = 0.0;
        double _z = 0.0;
        _d = random.nextIntBetweenInclusive(distanceMin, distanceMax);
        _x = random.nextIntBetweenInclusive(0, (int)_d);
        if (_x == 0.0) {
            _z = _d;
        } else {
            _z = Math.sqrt(_d * _d - _x * _x);
            if (random.nextBoolean()) {
                _x *= -1.0;
            }
        }
        if (random.nextBoolean()) {
            _z *= -1.0;
        }
        return new BlockPos(pos.getX() + (int)_x, level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.getX() + (int)_x, pos.getZ() + (int)_z), pos.getZ() + (int)_z);
    }

    private void spawnHordeMob(ServerLevel level, RandomSource randomSource, BlockPos pos, Player player, HordeConfig.MobSpawnData mobSpawnData) {
        Optional optMobType = BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)mobSpawnData.mobId()));
        if (optMobType.isEmpty()) {
            invalidHordeMobEntry = true;
            UndeadNights.LOGGER.warn("Spawning entry {} from the config file failed! Spawning default horde zombie instead.", (Object)mobSpawnData.mobId());
            optMobType = BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)"undeadnights:horde_zombie"));
            if (optMobType.isEmpty()) {
                UndeadNights.LOGGER.error("Spawning default horde zombie {} failed!", (Object)mobSpawnData.mobId());
                return;
            }
        }
        EntityType mobType = (EntityType)((Holder.Reference)optMobType.get()).value();
        Mob mob = (Mob)mobType.create((Level)level, EntitySpawnReason.NATURAL);
        int deltaX = randomSource.nextInt(8);
        int deltaZ = randomSource.nextInt(8);
        assert (mob != null);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(pos.getX(), pos.getY() - 1, pos.getZ());
        BlockState blockState = level.getBlockState((BlockPos)mutable);
        int y = 0;
        if (blockState.getFluidState().is(FluidTags.WATER)) {
            y = level.getHeight(Heightmap.Types.WORLD_SURFACE, pos.getX() + deltaX, pos.getZ() + deltaZ);
        }
        y = MainConfig.getHordeWavesCanSpawnOnTrees() ? level.getHeight(Heightmap.Types.MOTION_BLOCKING, pos.getX() + deltaX, pos.getZ() + deltaZ) : level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.getX() + deltaX, pos.getZ() + deltaZ);
        mob.setPos((double)(pos.getX() + deltaX), (double)y, (double)(pos.getZ() + deltaZ));
        if (MainConfig.getPersistentMobs()) {
            mob.setPersistenceRequired();
        }
        if (mobSpawnData.mobId().equals("undeadnights:demolition_zombie")) {
            String str = mobSpawnData.extra();
            String[] strA = str.split(":");
            if (strA[0].equals("tnt")) {
                try {
                    int numberTnt = Integer.parseInt(strA[1]);
                    if (numberTnt > 64) {
                        numberTnt = 64;
                    }
                    DemolitionZombieEntity demolitionZombie = (DemolitionZombieEntity)mob;
                    demolitionZombie.setNumberTnt(numberTnt);
                }
                catch (Exception e) {
                    UndeadNights.LOGGER.warn("extraSpawnInfo for {} has non valid value, using default TNT stack size!", (Object)mobSpawnData.mobId());
                }
            } else {
                UndeadNights.LOGGER.warn("extraSpawnInfo for {} could be read, using default TNT stack size!", (Object)mobSpawnData.mobId());
            }
        }
        DifficultyInstance localDifficulty = level.getCurrentDifficultyAt(player.blockPosition());
        try {
            mob.finalizeSpawn((ServerLevelAccessor)level, localDifficulty, EntitySpawnReason.NATURAL, (SpawnGroupData)new Zombie.ZombieGroupData(false, false));
            mob.setTarget((LivingEntity)player);
            UndeadNights.serverState.spawnedHordeMobs.add(mob.getUUID());
            if (!(mobSpawnData.mobId().equals("undeadnights:horde_zombie") || mobSpawnData.mobId().equals("undeadnights:elite_zombie") || mobSpawnData.mobId().equals("undeadnights:demolition_zombie"))) {
                Objects.requireNonNull(mob.getAttribute(Attributes.FOLLOW_RANGE)).setBaseValue(128.0);
                mob.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal(mob, Player.class, false, false));
            }
            level.addFreshEntity((Entity)mob);
        }
        catch (Exception e) {
            invalidHordeMobEntry = true;
            UndeadNights.LOGGER.warn("Spawning entry {} from the config file failed! Spawning default horde zombie instead.", (Object)mobSpawnData.mobId());
            HordeZombieEntity hZombie = new HordeZombieEntity(ModEntities.HORDE_ZOMBIE.get(), (Level)level);
            hZombie.setPos(pos.getX() + deltaX, level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.getX() + deltaX, pos.getZ() + deltaZ), pos.getZ() + deltaZ);
            if (MainConfig.getPersistentMobs()) {
                hZombie.setPersistenceRequired();
            }
            hZombie.finalizeSpawn((ServerLevelAccessor)level, localDifficulty, EntitySpawnReason.NATURAL, null);
            hZombie.setTarget((LivingEntity)player);
            UndeadNights.serverState.spawnedHordeMobs.add(hZombie.getUUID());
            level.addFreshEntity((Entity)hZombie);
        }
    }

    public int spawnHorde(ServerLevel level, ServerPlayer player, RandomSource randomSource) {
        int randomValue = 0;
        BlockPos pos = player.blockPosition();
        boolean foundHordeSpawnLocation = false;
        int currentHordeCounter = UndeadNights.globalSpawnCounter;
        for (int i = 0; i < 20; ++i) {
            if (this.d == 0.0) {
                this.d = randomSource.nextIntBetweenInclusive(MainConfig.getDistanceMin(), MainConfig.getDistanceMax());
                this.x = randomSource.nextIntBetweenInclusive(0, (int)this.d);
                if (this.x == 0.0) {
                    this.z = this.d;
                } else {
                    this.z = Math.sqrt(this.d * this.d - this.x * this.x);
                    if (randomSource.nextBoolean()) {
                        this.x *= -1.0;
                    }
                }
                if (randomSource.nextBoolean()) {
                    this.z *= -1.0;
                }
            }
            pos = player.blockPosition().offset((int)this.x, 0, (int)this.z);
            foundHordeSpawnLocation = this.checkSpawnLocation(level, (pos = new BlockPos(pos.getX(), level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.getX(), pos.getZ()), pos.getZ())).getX(), pos.getY() - 1, pos.getZ());
            if (foundHordeSpawnLocation) {
                if (!MainConfig.getPrintDebugMessages()) break;
                UndeadNights.LOGGER.info("It took {} tries to find a valid Horde spawn location for player: {}", (Object)(i + 1), (Object)player.getName().getString());
                break;
            }
            this.d = 0.0;
            this.x = 0.0;
            this.z = 0.0;
        }
        if (!foundHordeSpawnLocation) {
            UndeadNights.LOGGER.info("Could not find a valid Horde spawn location for player: {}", (Object)player.getName().getString());
            return -1;
        }
        if (MainConfig.getPrintDebugMessages()) {
            UndeadNights.LOGGER.info("Spawning Horde for player: {}", (Object)player.getName().getString());
        }
        boolean spawnCapReached = false;
        if (HordeConfig.getConfigVariant() == 1) {
            if (MainConfig.getPrintDebugMessages()) {
                UndeadNights.LOGGER.info("Horde config variant 1 detected.");
            }
            int waveMobCounter = 0;
            block1: while (waveMobCounter < HordeConfig.getMaxWaveSize()) {
                if (!HordeConfig.getHordeMobs().isEmpty()) {
                    for (HordeConfig.MobSpawnData mobSpawnData : HordeConfig.getHordeMobs()) {
                        if (UndeadNights.globalSpawnCounter < MainConfig.getHordeMobsSpawnCap()) {
                            randomValue = randomSource.nextIntBetweenInclusive(1, 100);
                            this.spawnHordeMob(level, randomSource, pos, (Player)player, randomValue > 100 - mobSpawnData.chance() ? mobSpawnData : HordeConfig.getDefaultHordeMob());
                            if (++waveMobCounter < HordeConfig.getMaxWaveSize()) continue;
                            this.d = 0.0;
                            continue block1;
                        }
                        waveMobCounter = HordeConfig.getMaxWaveSize();
                        spawnCapReached = true;
                        this.d = 0.0;
                        continue block1;
                    }
                    continue;
                }
                this.spawnHordeMob(level, randomSource, pos, (Player)player, HordeConfig.getDefaultHordeMob());
                ++waveMobCounter;
            }
        }
        if (HordeConfig.getConfigVariant() == 2) {
            if (MainConfig.getPrintDebugMessages()) {
                UndeadNights.LOGGER.info("Horde config variant 2 detected.");
            }
            for (HordeConfig.MobSpawnData mobSpawnData : HordeConfig.getHordeMobs()) {
                int mobCount = 0;
                mobCount = mobSpawnData.countMin() >= mobSpawnData.countMax() ? mobSpawnData.countMin() : randomSource.nextInt(mobSpawnData.countMin(), mobSpawnData.countMax());
                for (int i = 0; i < mobCount; ++i) {
                    this.spawnHordeMob(level, randomSource, pos, (Player)player, mobSpawnData);
                    if (UndeadNights.globalSpawnCounter < MainConfig.getHordeMobsSpawnCap()) continue;
                    spawnCapReached = true;
                    break;
                }
                if (UndeadNights.globalSpawnCounter < MainConfig.getHordeMobsSpawnCap()) continue;
                spawnCapReached = true;
                break;
            }
        }
        if (currentHordeCounter != UndeadNights.globalSpawnCounter) {
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), UndeadNightsSounds.HORDE_SCREAM.get(), SoundSource.HOSTILE, 4.0f, 1.0f);
            player.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.horde_spawned").withStyle(ChatFormatting.RED));
            if (MainConfig.getPrintDebugMessages()) {
                UndeadNights.LOGGER.info("A Horde has spanned!");
            }
        }
        this.d = 0.0;
        if (spawnCapReached) {
            UndeadNights.LOGGER.info("Spawncap reached, {} Horde Zombies are already loaded into this world.", (Object)MainConfig.getHordeMobsSpawnCap());
            return -1;
        }
        return 0;
    }

    public int tick(@NotNull ServerLevel level, boolean spawnMonsters, boolean spawnAnimals) {
        Object player3;
        long normalizedTimeOfDay;
        if (!spawnMonsters || !MainConfig.getUndeadNightsEnabled()) {
            return 0;
        }
        if (level.dimension() != Level.OVERWORLD) {
            return 0;
        }
        if (UndeadNights.serverState == null) {
            UndeadNights.serverState = StateSaverAndLoader.getServerState(level.getServer());
            if (UndeadNights.serverState.getLastMaxDaysCounter() != MainConfig.getDaysBetweenHordeNights()) {
                UndeadNights.serverState.setDaysCounter(MainConfig.getDaysBetweenHordeNights());
                UndeadNights.serverState.setLastMaxDaysCounter(MainConfig.getDaysBetweenHordeNights());
            }
            if (MainConfig.getPrintDebugMessages()) {
                UndeadNights.LOGGER.info("INIT DaysCounter: {} LastMaxDaysCounter: {}", (Object)UndeadNights.serverState.getDaysCounter(), (Object)UndeadNights.serverState.getLastMaxDaysCounter());
                UndeadNights.LOGGER.info("INIT HordeNight: {} SpawnZombies: {} RespawnZombies: {}", new Object[]{UndeadNights.serverState.getHordeNight(), UndeadNights.serverState.getSpawnZombies(), UndeadNights.serverState.getRespawnZombies()});
            }
        }
        boolean itIsNight = (normalizedTimeOfDay = level.getDayTime() - level.getDayTime() / 24000L * 24000L) >= 12000L && normalizedTimeOfDay < 22500L;
        RandomSource randomSource = level.random;
        int randomValue = 0;
        if (SpawnHordeCommand.spawnHorde) {
            SpawnHordeCommand.spawnHorde = false;
            if (SpawnHordeCommand.entities != null) {
                ServerPlayer serverPlayer;
                var9_8 = SpawnHordeCommand.entities.stream().toList().iterator();
                while (var9_8.hasNext() && (!((player3 = (Entity)var9_8.next()) instanceof ServerPlayer) || this.spawnHorde(level, serverPlayer = (ServerPlayer)player3, randomSource) != -1)) {
                }
                SpawnHordeCommand.entities = null;
            } else {
                var9_8 = level.getPlayers(LivingEntity::isAlive).iterator();
                while (var9_8.hasNext() && this.spawnHorde(level, (ServerPlayer)(player3 = (ServerPlayer)var9_8.next()), randomSource) != -1) {
                }
            }
        }
        if (itIsNight) {
            boolean nightIsStarting;
            if (UndeadNights.serverState.getRespawnZombies() && UndeadNights.serverState.getHordeNight() && MainConfig.getSpawnAdditionalWaves()) {
                if (UndeadNights.serverState.getTickCounter() > 0) {
                    UndeadNights.serverState.setTickCounter(UndeadNights.serverState.getTickCounter() - 1);
                    return 0;
                }
                UndeadNights.serverState.setTickCounter(MainConfig.getCooldownBetweenWaves() * 20);
                randomValue = randomSource.nextIntBetweenInclusive(1, 100);
                if (randomValue > 100 - MainConfig.getChanceForAdditionalWaves()) {
                    if (MainConfig.getPrintDebugMessages()) {
                        UndeadNights.LOGGER.info("New Wave, randomValue was: {}", (Object)randomValue);
                    }
                    UndeadNights.serverState.setSpawnZombies(true);
                    UndeadNights.serverState.setRespawnZombies(false);
                } else {
                    if (MainConfig.getPrintDebugMessages()) {
                        UndeadNights.LOGGER.info("RandomValue: {}", (Object)randomValue);
                    }
                    return 0;
                }
            }
            boolean bl = nightIsStarting = level.getDayTime() % 12000L == 0L && level.getDayTime() % 24000L != 0L;
            if (nightIsStarting && UndeadNights.serverState.getDaysCounter() >= 1) {
                UndeadNights.serverState.setDaysCounter(UndeadNights.serverState.getDaysCounter() - 1);
                if (UndeadNights.serverState.getDaysCounter() > 0 && MainConfig.getSendHordeNightsCountdownMessage()) {
                    for (ServerPlayer player2 : level.getPlayers(LivingEntity::isAlive)) {
                        if (UndeadNights.serverState.getDaysCounter() > 1) {
                            player2.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.nights_remaining", (Object[])new Object[]{String.valueOf(UndeadNights.serverState.getDaysCounter())}));
                            continue;
                        }
                        player2.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.last_nights"));
                    }
                }
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("Night is coming, NormalizedTimeOfDay: {}, TimeOfDay: {} DaysCounter: {}", new Object[]{normalizedTimeOfDay, level.getDayTime(), UndeadNights.serverState.getDaysCounter()});
                }
            }
            if (UndeadNights.serverState.getDaysCounter() > 0 && !UndeadNights.serverState.getHordeNight()) {
                if (MainConfig.getSpawnStrayHordeZombies() && UndeadNights.globalSpawnCounter < MainConfig.getHordeMobsSpawnCap()) {
                    if (UndeadNights.serverState.getTickCounter() > 0) {
                        UndeadNights.serverState.setTickCounter(UndeadNights.serverState.getTickCounter() - 1);
                        return 0;
                    }
                    UndeadNights.serverState.setTickCounter(100);
                    if (!(randomSource.nextFloat() < 0.03f)) {
                        return 0;
                    }
                    for (ServerPlayer player2 : level.getPlayers(LivingEntity::isAlive)) {
                        BlockPos pos = this.getBlockPosWithDistance(player2.blockPosition(), (Level)level, MainConfig.getDistanceMin(), MainConfig.getDistanceMax());
                        if (!this.checkSpawnLocation(level, pos.getX(), pos.getY() - 1, pos.getZ())) {
                            return 0;
                        }
                        this.spawnHordeMob(level, randomSource, pos, (Player)player2, new HordeConfig.MobSpawnData("undeadnights:horde_zombie", 100, 0, 0, "none"));
                        if (!MainConfig.getPrintDebugMessages()) continue;
                        UndeadNights.LOGGER.info("A stray horde zombie spawned!");
                    }
                }
                return 0;
            }
            if (nightIsStarting) {
                randomValue = randomSource.nextIntBetweenInclusive(1, 100);
                if (randomValue <= 100 - MainConfig.getChanceForHordeNight()) {
                    return 0;
                }
                UndeadNights.serverState.setHordeNight(true);
                UndeadNights.serverState.setSpawnZombies(true);
                for (ServerPlayer player2 : level.getPlayers(LivingEntity::isAlive)) {
                    player2.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.horde_night").withStyle(ChatFormatting.RED));
                }
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("The coming night is a Horde Night, HordeNight: {}", (Object)UndeadNights.serverState.getHordeNight());
                }
            }
            if (UndeadNights.serverState.getSpawnZombies() && UndeadNights.serverState.getHordeNight() && normalizedTimeOfDay >= 12542L) {
                ServerPlayer player2;
                player3 = level.getPlayers(LivingEntity::isAlive).iterator();
                while (player3.hasNext() && this.spawnHorde(level, player2 = (ServerPlayer)player3.next(), randomSource) != -1) {
                }
                UndeadNights.serverState.setTickCounter(MainConfig.getCooldownBetweenWaves() * 20);
                UndeadNights.serverState.setSpawnZombies(false);
                UndeadNights.serverState.setRespawnZombies(true);
                UndeadNights.serverState.setDaysCounter(MainConfig.getDaysBetweenHordeNights());
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("Spawned Waves for every player: DaysCounter: {} GlobalSpawnCounter: {} Spawn: {}, respawn: {}", new Object[]{UndeadNights.serverState.getDaysCounter(), UndeadNights.globalSpawnCounter, UndeadNights.serverState.getSpawnZombies(), UndeadNights.serverState.getRespawnZombies()});
                }
                this.d = 0.0;
                this.x = 0.0;
                this.z = 0.0;
            }
        } else {
            if (UndeadNights.serverState.getHordeNight()) {
                for (Object player3 : level.getPlayers(LivingEntity::isAlive)) {
                    player3.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.horde_night_over"));
                }
                UndeadNights.serverState.setDaysCounter(MainConfig.getDaysBetweenHordeNights());
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("The Night of the Undead is over, TimeOfDay: {} DaysCounter: {} GlobalSpawnCounter: {}", new Object[]{level.getDayTime(), UndeadNights.serverState.getDaysCounter(), UndeadNights.globalSpawnCounter});
                }
            }
            UndeadNights.serverState.setHordeNight(false);
            UndeadNights.serverState.setSpawnZombies(true);
            UndeadNights.serverState.setRespawnZombies(false);
        }
        return 0;
    }
}

