/*
 * Decompiled with CFR 0.152.
 */
package net.inventive_mods.inventive_inventory.features.profiles;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.inventive_mods.inventive_inventory.features.profiles.SavedSlot;
import net.inventive_mods.inventive_inventory.util.Converter;
import net.inventive_mods.inventive_inventory.util.InteractionHandler;
import net.minecraft.class_1799;

public class Profile {
    private int id;
    private final class_1799 displayStack;
    private final List<SavedSlot> savedSlots;
    private String name;
    private String key;

    public Profile(int id, String name, String key, List<SavedSlot> savedSlots) {
        this.id = id;
        this.name = name;
        this.key = key;
        this.savedSlots = savedSlots;
        this.displayStack = InteractionHandler.getAnyHandStack().method_7972();
    }

    public Profile(int id, String name, String key, List<SavedSlot> savedSlots, class_1799 displayStack) {
        this.id = id;
        this.name = name;
        this.key = key;
        this.savedSlots = savedSlots;
        this.displayStack = displayStack.method_7972();
    }

    public Profile(int id, String name, String key, JsonObject displayStack, JsonArray savedSlots) {
        this.id = id;
        this.name = name;
        this.key = key;
        this.displayStack = Converter.jsonToItemStack(displayStack);
        this.savedSlots = Converter.jsonToSavedSlots(savedSlots);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public List<SavedSlot> getSavedSlots() {
        return this.savedSlots;
    }

    public class_1799 getDisplayStack() {
        return this.displayStack;
    }

    public JsonObject getAsJsonObject() {
        JsonObject jsonProfile = new JsonObject();
        jsonProfile.addProperty("id", (Number)this.id);
        jsonProfile.addProperty("name", this.name);
        jsonProfile.addProperty("key", this.key);
        jsonProfile.add("display_stack", (JsonElement)Converter.itemStackToJson(this.displayStack));
        JsonArray jsonArray = new JsonArray();
        for (SavedSlot savedSlot : this.savedSlots) {
            JsonObject savedSlotMap = new JsonObject();
            savedSlotMap.addProperty("slot", (Number)savedSlot.slot());
            savedSlotMap.add("stack", (JsonElement)Converter.itemStackToJson(savedSlot.stack()));
            jsonArray.add((JsonElement)savedSlotMap);
        }
        jsonProfile.add("saved_slots", (JsonElement)jsonArray);
        return jsonProfile;
    }
}

