/*
 * Decompiled with CFR 0.152.
 */
package net.inventive_mods.inventive_inventory.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.inventive_mods.inventive_inventory.InventiveInventory;

public class FileHandler {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static void createFile(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createFile(path, new FileAttribute[0]);
        }
    }

    public static JsonObject get(Path path) {
        JsonObject jsonObject = new JsonObject();
        try {
            jsonObject = JsonParser.parseReader((Reader)new FileReader(path.toFile())).getAsJsonObject();
        }
        catch (FileNotFoundException | IllegalStateException exception) {
            // empty catch block
        }
        return jsonObject;
    }

    public static void write(Path path, JsonElement jsonElement) {
        try (FileWriter file = new FileWriter(path.toFile());){
            file.write(gson.toJson(jsonElement));
        }
        catch (IOException e) {
            InventiveInventory.LOGGER.error("Could not write configurations to file!");
        }
    }
}

