/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.capability;

import com.google.common.collect.Lists;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.advancements.KKLevelUpTrigger;
import online.kingdomkeys.kingdomkeys.api.item.IKeychain;
import online.kingdomkeys.kingdomkeys.capability.IGlobalCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.integration.epicfight.enums.DualChoices;
import online.kingdomkeys.kingdomkeys.integration.epicfight.enums.SingleChoices;
import online.kingdomkeys.kingdomkeys.item.KKAccessoryItem;
import online.kingdomkeys.kingdomkeys.item.KKArmorItem;
import online.kingdomkeys.kingdomkeys.item.KKPotionItem;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.PauldronItem;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;
import online.kingdomkeys.kingdomkeys.leveling.Stat;
import online.kingdomkeys.kingdomkeys.lib.LevelStats;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.lib.SoAState;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCShowOverlayPacket;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.reactioncommands.ModReactionCommands;
import online.kingdomkeys.kingdomkeys.reactioncommands.ReactionCommand;
import online.kingdomkeys.kingdomkeys.shotlock.ModShotlocks;
import online.kingdomkeys.kingdomkeys.shotlock.Shotlock;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeRegistry;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class PlayerCapabilities
implements IPlayerCapabilities {
    private int level = 1;
    private int exp = 0;
    private int expGiven = 0;
    private int maxHp = 20;
    private int remainingExp = 0;
    private int reflectTicks = 0;
    private int reflectLevel = 0;
    private int magicCasttime = 0;
    private int magicCooldown = 0;
    private int munny = 0;
    private int antipoints = 0;
    private int aerialDodgeTicks;
    private int synthLevel = 1;
    private int synthExp;
    private int remainingSynthExp = 0;
    private BlockPos airStepPos = new BlockPos(0, 0, 0);
    Stat strength = new Stat("strength", 1.0);
    Stat magic = new Stat("magic", 1.0);
    Stat defense = new Stat("defense", 1.0);
    Stat maxAP = new Stat("max_ap", 0.0);
    private String driveForm = DriveForm.NONE.toString();
    LinkedHashMap<String, int[]> driveForms = new LinkedHashMap();
    LinkedHashSet<String> visibleDriveforms = new LinkedHashSet();
    LinkedHashMap<String, int[]> magicList = new LinkedHashMap();
    List<String> shotlockList = new ArrayList<String>();
    List<Utils.ShotlockPosition> shotlockEnemies;
    boolean hasShotMaxShotlock = false;
    List<ResourceLocation> recipeList = new ArrayList<ResourceLocation>();
    LinkedHashMap<String, int[]> abilityMap = new LinkedHashMap();
    private TreeMap<ResourceLocation, Integer> materials = new TreeMap();
    List<String> reactionList = new ArrayList<String>();
    List<String> partyList = new ArrayList<String>();
    String equippedShotlock = "";
    LinkedHashMap<Integer, String> shortcutsMap = new LinkedHashMap();
    private double mp = 0.0;
    private double maxMP = 0.0;
    private double dp = 0.0;
    private double maxDP = 1000.0;
    private double fp = 0.0;
    private double focus = 100.0;
    private double maxFocus = 100.0;
    private boolean recharge;
    private boolean reflectActive;
    private boolean isGliding;
    private boolean hasJumpedAerealDodge = false;
    private Vec3 returnPos = Vec3.f_82478_;
    private ResourceKey<Level> returnDim = Level.f_46428_;
    SoAState soAState = SoAState.NONE;
    SoAState choice = SoAState.NONE;
    SoAState sacrifice = SoAState.NONE;
    private BlockPos choicePedestal = new BlockPos(0, 0, 0);
    private BlockPos sacrificePedestal = new BlockPos(0, 0, 0);
    private List<String> messages = new ArrayList<String>();
    private List<String> bfMessages = new ArrayList<String>();
    private List<String> dfMessages = new ArrayList<String>();
    private Utils.OrgMember alignment = Utils.OrgMember.NONE;
    private int hearts = 0;
    private Set<ItemStack> weaponUnlocks = new HashSet<ItemStack>();
    private int limitCooldownTicks = 0;
    private ItemStack equippedWeapon = ItemStack.f_41583_;
    private Map<ResourceLocation, ItemStack> equippedKeychains = new HashMap<ResourceLocation, ItemStack>();
    private Map<Integer, ItemStack> equippedItems = new HashMap<Integer, ItemStack>();
    private Map<Integer, ItemStack> equippedAccessories = new HashMap<Integer, ItemStack>();
    private Map<Integer, ItemStack> equippedArmors = new HashMap<Integer, ItemStack>();
    private Map<Integer, ItemStack> equippedKBArmors = new HashMap<Integer, ItemStack>();
    private int maxAccessories = 0;
    private int maxArmors = 0;
    private int armorColor = 0xFFFFFF;
    private boolean armorGlint = true;
    private SingleChoices singleStyle = SingleChoices.SORA;
    private DualChoices dualStyle = DualChoices.KH2_ROXAS_DUAL;
    private boolean respawnROD = false;
    private int notifColor = 0xFFFFFF;
    private Map<UUID, Instant> discoveredSavePoints = new HashMap<UUID, Instant>();
    Utils.castMagic castMagic = null;

    public CompoundTag serializeNBT() {
        CompoundTag storage = new CompoundTag();
        storage.m_128405_("level", this.getLevel());
        storage.m_128405_("experience", this.getExperience());
        storage.m_128405_("experience_given", this.getExperienceGiven());
        this.strength.serialize(storage);
        this.magic.serialize(storage);
        this.defense.serialize(storage);
        this.maxAP.serialize(storage);
        storage.m_128405_("max_hp", this.getMaxHP());
        storage.m_128347_("mp", this.getMP());
        storage.m_128347_("max_mp", this.getMaxMP());
        storage.m_128347_("focus", this.getFocus());
        storage.m_128347_("max_focus", this.getMaxFocus());
        storage.m_128379_("recharge", this.getRecharge());
        storage.m_128347_("dp", this.getDP());
        storage.m_128347_("max_dp", this.getMaxDP());
        storage.m_128347_("fp", this.getFP());
        storage.m_128359_("drive_form", this.getActiveDriveForm());
        storage.m_128405_("anti_points", this.getAntiPoints());
        storage.m_128405_("reflect_ticks", this.getReflectTicks());
        storage.m_128405_("reflect_level", this.getReflectLevel());
        storage.m_128379_("reflect_active", this.getReflectActive());
        storage.m_128405_("munny", this.getMunny());
        storage.m_128344_("soa_state", this.getSoAState().get());
        storage.m_128344_("soa_choice", this.getChosen().get());
        storage.m_128344_("soa_sacrifice", this.getSacrificed().get());
        CompoundTag returnCompound = new CompoundTag();
        Vec3 pos = this.getReturnLocation();
        returnCompound.m_128347_("x", pos.f_82479_);
        returnCompound.m_128347_("y", pos.f_82480_);
        returnCompound.m_128347_("z", pos.f_82481_);
        storage.m_128365_("soa_return_pos", (Tag)returnCompound);
        storage.m_128359_("soa_return_dim", this.getReturnDimension().m_135782_().toString());
        CompoundTag choicePedestalCompound = new CompoundTag();
        BlockPos choicePos = this.getChoicePedestal();
        choicePedestalCompound.m_128405_("x", choicePos.m_123341_());
        choicePedestalCompound.m_128405_("y", choicePos.m_123342_());
        choicePedestalCompound.m_128405_("z", choicePos.m_123343_());
        storage.m_128365_("soa_choice_pedestal", (Tag)choicePedestalCompound);
        CompoundTag sacrificePedestalCompound = new CompoundTag();
        BlockPos sacrificePos = this.getSacrificePedestal();
        sacrificePedestalCompound.m_128405_("x", sacrificePos.m_123341_());
        sacrificePedestalCompound.m_128405_("y", sacrificePos.m_123342_());
        sacrificePedestalCompound.m_128405_("z", sacrificePos.m_123343_());
        storage.m_128365_("soa_sacrifice_pedestal", (Tag)sacrificePedestalCompound);
        CompoundTag recipes = new CompoundTag();
        for (ResourceLocation resourceLocation : this.getKnownRecipeList()) {
            recipes.m_128359_(resourceLocation.toString(), resourceLocation.toString());
        }
        storage.m_128365_("recipes", (Tag)recipes);
        CompoundTag magics = new CompoundTag();
        for (Map.Entry<String, int[]> entry : this.getMagicsMap().entrySet()) {
            magics.m_128385_(entry.getKey(), entry.getValue());
        }
        storage.m_128365_("magics", (Tag)magics);
        CompoundTag compoundTag = new CompoundTag();
        for (String string : this.getShotlockList()) {
            compoundTag.m_128405_(string, 0);
        }
        storage.m_128365_("shotlocks", (Tag)compoundTag);
        storage.m_128359_("equipped_shotlock", this.getEquippedShotlock());
        CompoundTag compoundTag2 = new CompoundTag();
        for (Map.Entry<String, int[]> entry : this.getDriveFormMap().entrySet()) {
            compoundTag2.m_128385_(entry.getKey(), entry.getValue());
        }
        storage.m_128365_("drive_forms", (Tag)compoundTag2);
        CompoundTag compoundTag3 = new CompoundTag();
        for (String string : this.getVisibleDriveForms()) {
            compoundTag3.m_128359_(string, "");
        }
        storage.m_128365_("visible_drive_forms", (Tag)compoundTag3);
        CompoundTag compoundTag4 = new CompoundTag();
        for (Map.Entry<String, int[]> entry : this.getAbilityMap().entrySet()) {
            compoundTag4.m_128385_(entry.getKey(), entry.getValue());
        }
        storage.m_128365_("abilities", (Tag)compoundTag4);
        CompoundTag compoundTag5 = new CompoundTag();
        this.getEquippedKeychains().forEach((form, chain) -> keychains.m_128365_(form.toString(), (Tag)chain.serializeNBT()));
        storage.m_128365_("keychains", (Tag)compoundTag5);
        CompoundTag compoundTag6 = new CompoundTag();
        this.getEquippedItems().forEach((slot, item) -> items.m_128365_(slot.toString(), (Tag)item.serializeNBT()));
        storage.m_128365_("items", (Tag)compoundTag6);
        CompoundTag accessories = new CompoundTag();
        this.getEquippedAccessories().forEach((slot, accessory) -> accessories.m_128365_(slot.toString(), (Tag)accessory.serializeNBT()));
        storage.m_128365_("accessories", (Tag)accessories);
        CompoundTag kbArmors = new CompoundTag();
        this.getEquippedKBArmors().forEach((slot, kbArmor) -> kbArmors.m_128365_(slot.toString(), (Tag)kbArmor.serializeNBT()));
        storage.m_128365_("kbarmors", (Tag)kbArmors);
        CompoundTag armors = new CompoundTag();
        this.getEquippedArmors().forEach((slot, armor) -> armors.m_128365_(slot.toString(), (Tag)armor.serializeNBT()));
        storage.m_128365_("armors", (Tag)armors);
        storage.m_128405_("max_accessories", this.getMaxAccessories());
        storage.m_128405_("max_armors", this.getMaxArmors());
        storage.m_128405_("hearts", this.getHearts());
        storage.m_128405_("org_alignment", this.getAlignmentIndex());
        storage.m_128365_("org_equipped_weapon", (Tag)this.getEquippedWeapon().serializeNBT());
        CompoundTag unlockedWeapons = new CompoundTag();
        this.getWeaponsUnlocked().forEach(weapon -> unlockedWeapons.m_128365_(Utils.getItemRegistryName(weapon.m_41720_()).toString(), (Tag)weapon.serializeNBT()));
        storage.m_128365_("org_weapons_unlocked", (Tag)unlockedWeapons);
        CompoundTag parties = new CompoundTag();
        for (int i = 0; i < this.getPartiesInvited().size(); ++i) {
            parties.m_128405_(this.getPartiesInvited().get(i), i);
        }
        storage.m_128365_("parties", (Tag)parties);
        CompoundTag mats = new CompoundTag();
        for (Map.Entry<ResourceLocation, Integer> entry : this.getMaterialMap().entrySet()) {
            mats.m_128405_(entry.getKey().toString(), entry.getValue().intValue());
            if (mats.m_128451_(entry.getKey().toString()) != 0 || entry.getKey() == null) continue;
            mats.m_128473_(entry.getKey().toString());
        }
        storage.m_128365_("materials", (Tag)mats);
        storage.m_128405_("limitCooldownTicks", this.getLimitCooldownTicks());
        CompoundTag shortcuts = new CompoundTag();
        for (Map.Entry<Integer, String> entry : this.getShortcutsMap().entrySet()) {
            shortcuts.m_128359_(entry.getKey().toString(), entry.getValue());
        }
        storage.m_128365_("shortcuts", (Tag)shortcuts);
        storage.m_128405_("synth_level", this.synthLevel);
        storage.m_128405_("synth_exp", this.synthExp);
        storage.m_128359_("single_style", this.singleStyle.toString());
        storage.m_128359_("dual_style", this.dualStyle.toString());
        storage.m_128405_("armor_color", this.armorColor);
        storage.m_128379_("armor_glint", this.armorGlint);
        storage.m_128379_("respawn_rod", this.respawnROD);
        storage.m_128405_("notif_color", this.notifColor);
        CompoundTag compoundTag7 = new CompoundTag();
        Vec3 vec3 = this.getAirStep().m_252807_();
        returnCompound.m_128347_("x", vec3.f_82479_);
        returnCompound.m_128347_("y", vec3.f_82480_);
        returnCompound.m_128347_("z", vec3.f_82481_);
        storage.m_128365_("airstep_pos_compound", (Tag)compoundTag7);
        CompoundTag savePoints = new CompoundTag();
        this.discoveredSavePoints.forEach((uuid, instant) -> {
            CompoundTag timeTag = new CompoundTag();
            timeTag.m_128356_("second", instant.getEpochSecond());
            timeTag.m_128405_("nano", instant.getNano());
            savePoints.m_128365_(uuid.toString(), (Tag)timeTag);
        });
        storage.m_128365_("save_points", (Tag)savePoints);
        return storage;
    }

    public void deserializeNBT(CompoundTag nbt) {
        int boost;
        this.setLevel(nbt.m_128451_("level"));
        this.setExperience(nbt.m_128451_("experience"));
        this.setExperienceGiven(nbt.m_128451_("experience_given"));
        this.strength = Stat.deserializeNBT("strength", nbt);
        if (nbt.m_128441_("boost_strength")) {
            boost = nbt.m_128451_("boost_strength");
            nbt.m_128473_("boost_strength");
            this.strength.addModifier("legacy_boosts", boost, false, false);
        }
        this.magic = Stat.deserializeNBT("magic", nbt);
        if (nbt.m_128441_("boost_magic")) {
            boost = nbt.m_128451_("boost_magic");
            nbt.m_128473_("boost_magic");
            this.magic.addModifier("legacy_boosts", boost, false, false);
        }
        this.defense = Stat.deserializeNBT("defense", nbt);
        if (nbt.m_128441_("boost_defense")) {
            boost = nbt.m_128451_("boost_defense");
            nbt.m_128473_("boost_defense");
            this.defense.addModifier("legacy_boosts", boost, false, false);
        }
        this.maxAP = Stat.deserializeNBT("max_ap", nbt);
        if (nbt.m_128441_("boost_max_ap")) {
            boost = nbt.m_128451_("boost_max_ap");
            nbt.m_128473_("boost_max_ap");
            this.maxAP.addModifier("legacy_boosts", boost, false, false);
        }
        this.setMaxHP(nbt.m_128451_("max_hp"));
        this.setMP(nbt.m_128459_("mp"));
        this.setMaxMP(nbt.m_128459_("max_mp"));
        this.setFocus(nbt.m_128459_("focus"));
        this.setMaxFocus(nbt.m_128459_("max_focus"));
        this.setRecharge(nbt.m_128471_("recharge"));
        this.setDP(nbt.m_128459_("dp"));
        this.setMaxDP(nbt.m_128459_("max_dp"));
        this.setFP(nbt.m_128459_("fp"));
        this.setActiveDriveForm(nbt.m_128461_("drive_form"));
        this.setAntiPoints(nbt.m_128451_("anti_points"));
        this.setReflectTicks(nbt.m_128451_("reflect_ticks"), nbt.m_128451_("reflect_level"));
        this.setReflectActive(nbt.m_128471_("reflect_active"));
        this.setMunny(nbt.m_128451_("munny"));
        this.setSoAState(SoAState.fromByte(nbt.m_128445_("soa_state")));
        this.setChoice(SoAState.fromByte(nbt.m_128445_("soa_choice")));
        this.setSacrifice(SoAState.fromByte(nbt.m_128445_("soa_sacrifice")));
        CompoundTag returnCompound = nbt.m_128469_("soa_return_pos");
        this.setReturnLocation(new Vec3(returnCompound.m_128459_("x"), returnCompound.m_128459_("y"), returnCompound.m_128459_("z")));
        this.setReturnDimension((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("soa_return_dim"))));
        CompoundTag choicePedestal = nbt.m_128469_("soa_choice_pedestal");
        this.setChoicePedestal(new BlockPos(choicePedestal.m_128451_("x"), choicePedestal.m_128451_("y"), choicePedestal.m_128451_("z")));
        CompoundTag sacrificePedestal = nbt.m_128469_("soa_sacrifice_pedestal");
        this.setSacrificePedestal(new BlockPos(sacrificePedestal.m_128451_("x"), sacrificePedestal.m_128451_("y"), sacrificePedestal.m_128451_("z")));
        for (String key2 : nbt.m_128469_("recipes").m_128431_()) {
            this.getKnownRecipeList().add(new ResourceLocation(key2));
        }
        Collections.sort(this.recipeList);
        for (String magicName : nbt.m_128469_("magics").m_128431_()) {
            int[] array;
            if (nbt.m_128469_("magics").m_128425_(magicName, 99)) {
                KingdomKeys.LOGGER.info("Converting " + magicName + " data");
                array = new int[]{nbt.m_128469_("magics").m_128451_(magicName), 0};
            } else {
                array = nbt.m_128469_("magics").m_128465_(magicName);
            }
            if (!ModMagic.registry.get().containsKey(new ResourceLocation(magicName))) continue;
            this.getMagicsMap().put(magicName, array);
        }
        for (String key2 : nbt.m_128469_("shotlocks").m_128431_()) {
            if (!ModShotlocks.registry.get().containsKey(new ResourceLocation(key2))) continue;
            this.getShotlockList().add(key2);
        }
        this.setEquippedShotlock(nbt.m_128461_("equipped_shotlock"));
        for (String driveFormName : nbt.m_128469_("drive_forms").m_128431_()) {
            if (!ModDriveForms.registry.get().containsKey(new ResourceLocation(driveFormName))) continue;
            this.getDriveFormMap().put(driveFormName, nbt.m_128469_("drive_forms").m_128465_(driveFormName));
        }
        for (String driveFormName : nbt.m_128469_("visible_drive_forms").m_128431_()) {
            if (!ModDriveForms.registry.get().containsKey(new ResourceLocation(driveFormName))) continue;
            this.getVisibleDriveForms().add(driveFormName);
        }
        for (String abilityName : nbt.m_128469_("abilities").m_128431_()) {
            if (!ModAbilities.registry.get().containsKey(new ResourceLocation(abilityName))) continue;
            this.getAbilityMap().put(abilityName, nbt.m_128469_("abilities").m_128465_(abilityName));
        }
        CompoundTag keychainsNBT = nbt.m_128469_("keychains");
        keychainsNBT.m_128431_().forEach(chain -> this.setNewKeychain(new ResourceLocation(chain), ItemStack.m_41712_((CompoundTag)keychainsNBT.m_128469_(chain))));
        CompoundTag itemsNBT = nbt.m_128469_("items");
        itemsNBT.m_128431_().forEach(slot -> this.setNewItem(Integer.parseInt(slot), ItemStack.m_41712_((CompoundTag)itemsNBT.m_128469_(slot))));
        CompoundTag accessoriesNBT = nbt.m_128469_("accessories");
        accessoriesNBT.m_128431_().forEach(slot -> this.setNewAccessory(Integer.parseInt(slot), ItemStack.m_41712_((CompoundTag)accessoriesNBT.m_128469_(slot))));
        CompoundTag kbArmorsNBT = nbt.m_128469_("kbarmors");
        kbArmorsNBT.m_128431_().forEach(slot -> this.setNewKBArmor(Integer.parseInt(slot), ItemStack.m_41712_((CompoundTag)kbArmorsNBT.m_128469_(slot))));
        CompoundTag armorsNBT = nbt.m_128469_("armors");
        armorsNBT.m_128431_().forEach(slot -> this.setNewArmor(Integer.parseInt(slot), ItemStack.m_41712_((CompoundTag)armorsNBT.m_128469_(slot))));
        this.setMaxAccessories(nbt.m_128451_("max_accessories"));
        this.setMaxArmors(nbt.m_128451_("max_armors"));
        this.setHearts(nbt.m_128451_("hearts"));
        this.setAlignment(nbt.m_128451_("org_alignment"));
        this.equipWeapon(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("org_equipped_weapon")));
        CompoundTag unlocksCompound = nbt.m_128469_("org_weapons_unlocked");
        unlocksCompound.m_128431_().forEach(key -> this.unlockWeapon(ItemStack.m_41712_((CompoundTag)unlocksCompound.m_128469_(key))));
        for (String key3 : nbt.m_128469_("parties").m_128431_()) {
            this.getPartiesInvited().add(key3);
        }
        for (String mat : nbt.m_128469_("materials").m_128431_()) {
            this.getMaterialMap().put(new ResourceLocation(mat), nbt.m_128469_("materials").m_128451_(mat));
        }
        this.setLimitCooldownTicks(nbt.m_128451_("limitCooldownTicks"));
        for (String s : nbt.m_128469_("shortcuts").m_128431_()) {
            int shortcutPos = Integer.parseInt(s);
            this.getShortcutsMap().put(shortcutPos, nbt.m_128469_("shortcuts").m_128461_("" + shortcutPos));
        }
        this.setSynthLevel(nbt.m_128451_("synth_level"));
        this.setSynthExperience(nbt.m_128451_("synth_exp"));
        String s = nbt.m_128461_("single_style");
        if (!s.equals("")) {
            this.setSingleStyle(SingleChoices.valueOf(s));
        }
        if (!(s = nbt.m_128461_("dual_style")).equals("")) {
            this.setDualStyle(DualChoices.valueOf(s));
        }
        this.setArmorColor(nbt.m_128451_("armor_color"));
        this.setArmorGlint(nbt.m_128471_("armor_glint"));
        this.setRespawnROD(nbt.m_128471_("respawn_rod"));
        this.setNotifColor(nbt.m_128451_("notif_color"));
        CompoundTag airStepCompound = nbt.m_128469_("airstep_pos_compound");
        this.setAirStep(new BlockPos((int)airStepCompound.m_128459_("x"), (int)airStepCompound.m_128459_("y"), (int)airStepCompound.m_128459_("z")));
        CompoundTag savePoints = nbt.m_128469_("save_points");
        for (String key4 : savePoints.m_128431_()) {
            UUID uuid = UUID.fromString(key4);
            CompoundTag time = savePoints.m_128469_(key4);
            this.addDiscoveredSavePoint(uuid, Instant.ofEpochSecond(time.m_128454_("second"), time.m_128451_("nano")));
        }
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public int getExperience() {
        return this.exp;
    }

    @Override
    public void setExperience(int exp) {
        this.exp = exp;
    }

    @Override
    public void addExperience(Player player, int exp, boolean shareXP, boolean sound) {
        if (player != null && this.getSoAState() == SoAState.COMPLETE && this.level < 100) {
            Party party = ModCapabilities.getWorld(player.m_9236_()).getPartyFromMember(player.m_20148_());
            if (party != null && shareXP) {
                double sharedXP = (double)exp * (ModConfigs.partyXPShare / 100.0 * 2.0);
                if (sharedXP > 0.0) {
                    for (Party.Member member : party.getMembers()) {
                        for (ResourceKey worldKey : player.m_9236_().m_7654_().m_129784_()) {
                            Player ally = player.m_20194_().m_129880_(worldKey).m_46003_(member.getUUID());
                            if (ally == null || ally == player) continue;
                            ModCapabilities.getPlayer(ally).addExperience(ally, (int)sharedXP, false, true);
                            PacketHandler.sendTo(new SCSyncCapabilityPacket(ModCapabilities.getPlayer(ally)), (ServerPlayer)ally);
                        }
                    }
                }
                if (this.getNumberOfAbilitiesEquipped("kingdomkeys:ability_experience_boost") > 0 && player.m_21223_() <= player.m_21233_() / 2.0f) {
                    exp *= 1 + this.getNumberOfAbilitiesEquipped("kingdomkeys:ability_experience_boost");
                }
                this.exp += exp;
            } else {
                if (this.getNumberOfAbilitiesEquipped("kingdomkeys:ability_experience_boost") > 0 && player.m_21223_() <= player.m_21233_() / 2.0f && shareXP) {
                    exp *= 1 + this.getNumberOfAbilitiesEquipped("kingdomkeys:ability_experience_boost");
                }
                this.exp += exp;
            }
            while (this.getExpNeeded(this.getLevel(), this.exp) <= 0 && this.getLevel() != 100) {
                this.setLevel(this.getLevel() + 1);
                if (player instanceof ServerPlayer) {
                    ServerPlayer svPlayer = (ServerPlayer)player;
                    KKLevelUpTrigger.TRIGGER_LEVELUP.trigger(svPlayer, this.getLevel());
                }
                this.levelUpStatsAndDisplayMessage(player, sound);
                PacketHandler.sendTo(new SCShowOverlayPacket("levelup", player.m_20148_(), player.m_5446_().getString(), this.getLevel(), this.getNotifColor(), this.getMessages()), (ServerPlayer)player);
            }
            PacketHandler.sendTo(new SCShowOverlayPacket("exp"), (ServerPlayer)player);
        }
    }

    @Override
    public int getExperienceGiven() {
        return this.expGiven;
    }

    @Override
    public void setExperienceGiven(int exp) {
        this.expGiven = exp;
    }

    @Override
    public int getStrength(boolean combined) {
        return (int)(combined ? ((ModConfigs.allowBoosts ? this.strength.getStat() : this.strength.get()) + (double)Utils.getAccessoriesStat(this, "str") + (double)(this.getRecharge() ? this.getNumberOfAbilitiesEquipped("kingdomkeys:ability_berserk_charge") * 2 : 0)) * (double)ModConfigs.statsMultiplier.get(0).intValue() / 100.0 : this.strength.get());
    }

    @Override
    public void setStrength(int level) {
        this.strength.set(level);
    }

    @Override
    public int getMagic(boolean combined) {
        return (int)(combined ? ((ModConfigs.allowBoosts ? this.magic.getStat() : this.magic.get()) + (double)Utils.getAccessoriesStat(this, "mag")) * (double)ModConfigs.statsMultiplier.get(1).intValue() / 100.0 : this.magic.get());
    }

    @Override
    public void setMagic(int level) {
        this.magic.set(level);
    }

    @Override
    public int getDefense(boolean combined) {
        return (int)(combined ? ((ModConfigs.allowBoosts ? this.defense.getStat() : this.defense.get()) + (double)Utils.getArmorsStat(this, "def")) * (double)ModConfigs.statsMultiplier.get(2).intValue() / 100.0 : this.defense.get());
    }

    @Override
    public void setDefense(int level) {
        this.defense.set(level);
    }

    @Override
    public int getExpNeeded(int level, int currentExp) {
        if (level == 100) {
            return 0;
        }
        double nextLevel = ((double)level + 300.0 * Math.pow(2.0, (double)level / 7.0)) * ((double)level * 0.25);
        this.remainingExp = (int)nextLevel - currentExp;
        return this.remainingExp;
    }

    @Override
    public void addStrength(int str) {
        this.strength.add(str);
        this.messages.add("stats.levelUpStr");
    }

    @Override
    public Stat getStrengthStat() {
        return this.strength;
    }

    @Override
    public void setStrengthStat(Stat stat) {
        this.strength = stat;
    }

    @Override
    public void addMagic(int mag) {
        this.magic.add(mag);
        this.messages.add("stats.levelUpMag");
    }

    @Override
    public Stat getMagicStat() {
        return this.magic;
    }

    @Override
    public void setMagicStat(Stat stat) {
        this.magic = stat;
    }

    @Override
    public void addDefense(int def) {
        this.defense.add(def);
        this.messages.add("stats.levelUpDef");
    }

    @Override
    public Stat getDefenseStat() {
        return this.defense;
    }

    @Override
    public void setDefenseStat(Stat stat) {
        this.defense = stat;
    }

    @Override
    public int getMaxHP() {
        return this.maxHp;
    }

    @Override
    public void setMaxHP(int hp) {
        this.maxHp = hp;
    }

    @Override
    public void addMaxHP(int hp) {
        this.maxHp += hp;
        this.messages.add("stats.levelUpHP");
    }

    @Override
    public int getMaxAP(boolean combined) {
        return (int)(combined ? this.maxAP.getStat() + (double)this.getAccessoriesAP("ap") : this.maxAP.get());
    }

    @Override
    public Stat getMaxAPStat() {
        return this.maxAP;
    }

    @Override
    public void setMaxAPStat(Stat stat) {
        this.maxAP = stat;
    }

    private int getAccessoriesAP(String type) {
        int res = 0;
        for (Map.Entry<Integer, ItemStack> accessory : this.getEquippedAccessories().entrySet()) {
            Object object;
            if (ItemStack.m_41728_((ItemStack)accessory.getValue(), (ItemStack)ItemStack.f_41583_) || !((object = accessory.getValue().m_41720_()) instanceof KKAccessoryItem)) continue;
            KKAccessoryItem a = (KKAccessoryItem)object;
            switch (type) {
                case "ap": {
                    res += a.getAp();
                    break;
                }
                case "str": {
                    res += a.getStr();
                    break;
                }
                case "mag": {
                    res += a.getMag();
                }
            }
        }
        return res;
    }

    @Override
    public void setMaxAP(int ap) {
        this.maxAP.set(ap);
    }

    @Override
    public void addMaxAP(int ap) {
        this.maxAP.add(ap);
        this.messages.add("stats.levelUpAP");
    }

    @Override
    public List<String> getMessages() {
        return this.messages;
    }

    @Override
    public void clearMessages() {
        this.getMessages().clear();
    }

    @Override
    public List<String> getBFMessages() {
        return this.bfMessages;
    }

    @Override
    public void clearBFMessages() {
        this.getBFMessages().clear();
    }

    @Override
    public void setBFMessages(List<String> messages) {
        this.bfMessages = messages;
    }

    @Override
    public List<String> getDFMessages() {
        return this.dfMessages;
    }

    @Override
    public void clearDFMessages() {
        this.getDFMessages().clear();
    }

    @Override
    public void setDFMessages(List<String> messages) {
        this.dfMessages = messages;
    }

    @Override
    public void levelUpStatsAndDisplayMessage(Player player, boolean sound) {
        this.getMessages().clear();
        LevelStats.applyStatsForLevel(this.level, player, this);
        Party party = ModCapabilities.getWorld(player.m_9236_()).getPartyFromMember(player.m_20148_());
        if (party != null) {
            for (Party.Member member : party.getMembers()) {
                for (ResourceKey worldKey : player.m_9236_().m_7654_().m_129784_()) {
                    Player ally = player.m_20194_().m_129880_(worldKey).m_46003_(member.getUUID());
                    if (ally == null || ally == player) continue;
                    PacketHandler.sendTo(new SCShowOverlayPacket("levelup", player.m_20148_(), player.m_5446_().getString(), this.getLevel(), this.getNotifColor(), this.getMessages()), (ServerPlayer)ally);
                    PacketHandler.syncToAllAround(player, this);
                }
            }
        }
        if (sound) {
            player.m_9236_().m_6263_((Player)null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.levelup.get(), SoundSource.MASTER, 0.5f, 1.0f);
        }
        player.m_21051_(Attributes.f_22276_).m_22100_((double)this.getMaxHP());
        PacketHandler.sendTo(new SCSyncCapabilityPacket(ModCapabilities.getPlayer(player)), (ServerPlayer)player);
        PacketHandler.syncToAllAround(player, this);
        AABB radius = new AABB(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_20185_() + 1.0, player.m_20186_() + 1.0, player.m_20189_() + 1.0).m_82377_(50.0, 50.0, 50.0);
        List tamedAnimals = player.m_9236_().m_45971_(TamableAnimal.class, TargetingConditions.m_148353_(), (LivingEntity)player, radius);
        if (!tamedAnimals.isEmpty()) {
            tamedAnimals.forEach(tamableAnimal -> {
                IGlobalCapabilities animalData = ModCapabilities.getGlobal((LivingEntity)tamableAnimal);
                animalData.setLevel(this.getLevel());
                Utils.applyMobLevel((LivingEntity)tamableAnimal, this.level);
                tamableAnimal.m_5634_(tamableAnimal.m_21233_());
            });
        }
    }

    @Override
    public void setMessages(List<String> messages) {
        this.messages = messages;
    }

    @Override
    public void displayDriveFormLevelUpMessage(Player player, String driveForm) {
        String name;
        Ability a;
        this.getBFMessages().clear();
        this.getDFMessages().clear();
        this.dfMessages.add("stats.levelUpFG");
        DriveForm form = (DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(driveForm));
        String driveformAbility = form.getDFAbilityForLevel(this.getDriveFormLevel(driveForm));
        String baseAbility = form.getBaseAbilityForLevel(this.getDriveFormLevel(driveForm));
        if (driveformAbility != null && !driveformAbility.equals("")) {
            a = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(driveformAbility));
            name = a.getTranslationKey();
            if (a.getType() == Ability.AbilityType.GROWTH) {
                int level = this.getEquippedAbilityLevel(driveformAbility)[0] + 2;
                name = new StringBuilder(name).insert(name.lastIndexOf(46), "_" + level).toString();
            }
            this.dfMessages.add("A_" + name);
        }
        if (baseAbility != null && !baseAbility.equals("")) {
            a = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(baseAbility));
            name = a.getTranslationKey();
            if (a.getType() == Ability.AbilityType.GROWTH) {
                name = new StringBuilder(name).insert(name.lastIndexOf(46), "_" + (this.getEquippedAbilityLevel(baseAbility)[0] + 1)).toString();
            }
            this.addAbility(baseAbility, name, true);
        }
        player.m_9236_().m_6263_((Player)null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.levelup.get(), SoundSource.MASTER, 0.5f, 1.0f);
        PacketHandler.sendTo(new SCShowOverlayPacket("drivelevelup", driveForm), (ServerPlayer)player);
    }

    @Override
    public double getDP() {
        return this.dp;
    }

    @Override
    public void setDP(double dp) {
        this.dp = dp;
    }

    @Override
    public void addDP(double dp) {
        this.dp = Utils.clamp(this.dp + dp, 0.0, this.maxDP);
    }

    @Override
    public void remDP(double dp) {
        this.dp = Utils.clamp(this.dp - dp, 0.0, this.maxDP);
    }

    @Override
    public double getMaxDP() {
        return this.maxDP;
    }

    @Override
    public void setMaxDP(double dp) {
        this.maxDP = Math.min(this.maxDP + dp, 1000.0);
    }

    @Override
    public double getFP() {
        return this.fp;
    }

    @Override
    public void setFP(double fp) {
        this.fp = fp;
    }

    @Override
    public void addFP(double fp) {
        double max = 200 + Utils.getDriveFormLevel(this.getDriveFormMap(), this.getActiveDriveForm()) * 100;
        this.fp = Math.min(this.fp + fp, max);
    }

    @Override
    public void remFP(double fp) {
        this.fp = Math.max(this.fp - fp, 0.0);
    }

    @Override
    public void setActiveDriveForm(String form) {
        this.driveForm = form;
    }

    @Override
    public String getActiveDriveForm() {
        return this.driveForm;
    }

    @Override
    public LinkedHashMap<String, int[]> getDriveFormMap() {
        return this.driveForms;
    }

    @Override
    public void setDriveFormMap(LinkedHashMap<String, int[]> map) {
        this.driveForms = map;
    }

    @Override
    public LinkedHashSet<String> getVisibleDriveForms() {
        return this.visibleDriveforms;
    }

    @Override
    public void setVisibleDriveForms(LinkedHashSet<String> forms) {
        this.visibleDriveforms = forms;
    }

    @Override
    public void addVisibleDriveForm(String form) {
        if (!this.visibleDriveforms.contains(form)) {
            this.visibleDriveforms.add(form);
        }
    }

    @Override
    public void remVisibleDriveForm(String form) {
        if (this.visibleDriveforms.contains(form)) {
            this.visibleDriveforms.remove(form);
        }
    }

    @Override
    public int getDriveFormLevel(String name) {
        return this.driveForms.containsKey(name) ? this.driveForms.get(name)[0] : 0;
    }

    @Override
    public void setDriveFormLevel(String name, int level) {
        DriveForm form = (DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(name));
        if (name.equals(DriveForm.NONE.toString()) || name.equals(DriveForm.SYNCH_BLADE.toString())) {
            this.driveForms.put(name, new int[]{level, 1});
        } else if (level == 0) {
            this.driveForms.remove(name);
        } else if (level <= form.getMaxLevel()) {
            int experience = form.getLevelUpCost(level);
            this.driveForms.put(name, new int[]{level, experience});
        }
    }

    @Override
    public int getDriveFormExp(String name) {
        return this.driveForms.get(name)[1];
    }

    @Override
    public void setDriveFormExp(Player player, String name, int exp) {
        DriveForm form = (DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(name));
        int oldLevel = this.getDriveFormLevel(name);
        int driveLevel = form.getLevelFromExp(exp);
        if (driveLevel <= form.getMaxLevel()) {
            this.driveForms.put(name, new int[]{driveLevel, exp});
            if (driveLevel > oldLevel) {
                this.displayDriveFormLevelUpMessage(player, name);
                if (driveLevel == form.getMaxLevel()) {
                    this.setMaxDP(this.getMaxDP() + 100.0);
                }
                PacketHandler.sendTo(new SCSyncCapabilityPacket(this), (ServerPlayer)player);
            }
        }
    }

    @Override
    public void addDriveFormExperience(String drive, ServerPlayer player, int value) {
        DriveForm form = (DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(drive));
        int oldLevel = this.getDriveFormLevel(drive);
        int driveLevel = form.getLevelFromExp(this.exp + value);
        if (driveLevel <= form.getMaxLevel()) {
            this.driveForms.put(drive, new int[]{driveLevel, this.exp + value});
            if (driveLevel > oldLevel) {
                this.displayDriveFormLevelUpMessage((Player)player, drive);
                if (driveLevel == form.getMaxLevel()) {
                    this.setMaxDP(this.getMaxDP() + 100.0);
                }
                PacketHandler.sendTo(new SCSyncCapabilityPacket(this), player);
            }
        }
    }

    @Override
    public int getAntiPoints() {
        return this.antipoints;
    }

    @Override
    public void setAntiPoints(int points) {
        this.antipoints = points;
    }

    @Override
    public double getMP() {
        return this.mp;
    }

    @Override
    public void setMP(double mp) {
        this.mp = mp;
    }

    @Override
    public void addMP(double mp) {
        this.mp = Utils.clamp(this.mp + mp, 0.0, this.maxMP);
    }

    @Override
    public double getMaxMP() {
        return this.maxMP;
    }

    @Override
    public void setMaxMP(double mp) {
        this.maxMP = mp;
    }

    @Override
    public void addMaxMP(double mp) {
        this.maxMP += mp;
        this.setMP(this.getMaxMP());
        this.messages.add("stats.levelUpMP");
    }

    @Override
    public void remMP(double amount) {
        this.mp = this.isAbilityEquipped("kingdomkeys:ability_extra_cast") ? (amount >= this.maxMP ? Math.max(this.mp - amount, 0.0) : (this.mp > 1.0 && this.mp - amount < 1.0 ? 1.0 : Math.max(this.mp - amount, 0.0))) : Math.max(this.mp - amount, 0.0);
    }

    @Override
    public double getFocus() {
        return this.focus;
    }

    @Override
    public void setFocus(double focus) {
        this.focus = focus;
    }

    @Override
    public void addFocus(double focus) {
        this.focus = Math.min(this.focus + focus, this.getMaxFocus());
    }

    @Override
    public void remFocus(double cost) {
        this.focus = Math.max(this.focus - cost, 0.0);
    }

    @Override
    public double getMaxFocus() {
        return this.maxFocus;
    }

    @Override
    public void setMaxFocus(double maxFocus) {
        this.maxFocus = maxFocus;
    }

    @Override
    public void addMaxFocus(double focus) {
        this.focus += focus;
    }

    @Override
    public void setShotlockEnemies(List<Utils.ShotlockPosition> list) {
        this.shotlockEnemies = list;
    }

    @Override
    public List<Utils.ShotlockPosition> getShotlockEnemies() {
        return this.shotlockEnemies;
    }

    @Override
    public void addShotlockEnemy(Utils.ShotlockPosition shotlockPos) {
        this.shotlockEnemies.add(shotlockPos);
    }

    @Override
    public boolean hasShotMaxShotlock() {
        return this.hasShotMaxShotlock;
    }

    @Override
    public void setHasShotMaxShotlock(boolean val) {
        this.hasShotMaxShotlock = val;
    }

    @Override
    public void setRecharge(boolean b) {
        this.recharge = b;
    }

    @Override
    public boolean getRecharge() {
        return this.recharge;
    }

    @Override
    public int getReflectLevel() {
        return this.reflectLevel;
    }

    @Override
    public void setReflectLevel(int level) {
        this.reflectLevel = level;
    }

    @Override
    public void setReflectTicks(int ticks, int level) {
        this.reflectTicks = ticks;
        this.reflectLevel = level;
    }

    @Override
    public void remReflectTicks(int ticks) {
        this.reflectTicks -= ticks;
    }

    @Override
    public int getReflectTicks() {
        return this.reflectTicks;
    }

    @Override
    public void setReflectActive(boolean active) {
        this.reflectActive = active;
    }

    @Override
    public boolean getReflectActive() {
        return this.reflectActive;
    }

    @Override
    public LinkedHashMap<String, int[]> getMagicsMap() {
        return this.magicList;
    }

    @Override
    public void setMagicsMap(LinkedHashMap<String, int[]> map) {
        this.magicList = map;
    }

    @Override
    public int getMagicLevel(ResourceLocation name) {
        return this.magicList.containsKey(name.toString()) ? this.magicList.get(name.toString())[0] : 0;
    }

    @Override
    public void setMagicLevel(ResourceLocation name, int level, boolean notification) {
        Magic magic = (Magic)ModMagic.registry.get().getValue(name);
        if (level == -1) {
            this.magicList.remove(name.toString());
        } else if (level <= magic.getMaxLevel()) {
            int uses = this.magicList.containsKey(name.toString()) ? this.getMagicUses(name) : 0;
            this.magicList.put(name.toString(), new int[]{level, uses});
            if (notification) {
                this.messages.add("M_" + magic.getTranslationKey(level));
            }
        }
    }

    @Override
    public int getMagicUses(ResourceLocation name) {
        return this.magicList.get(name.toString())[1];
    }

    @Override
    public void setMagicUses(ResourceLocation name, int uses) {
        Magic magic = (Magic)ModMagic.registry.get().getValue(name);
        int level = this.getMagicLevel(name);
        if (level <= magic.getMaxLevel()) {
            this.magicList.put(name.toString(), new int[]{level, uses});
        }
    }

    @Override
    public void addMagicUses(ResourceLocation name, int uses) {
        this.setMagicUses(name, this.getMagicUses(name) + uses);
    }

    @Override
    public void remMagicUses(ResourceLocation name, int uses) {
        this.setMagicUses(name, this.getMagicUses(name) - uses);
    }

    @Override
    public List<String> getShotlockList() {
        return this.shotlockList;
    }

    @Override
    public void setShotlockList(List<String> list) {
        this.shotlockList = list;
    }

    @Override
    public void addShotlockToList(String shotlock, boolean notification) {
        Shotlock shotlockthis = (Shotlock)ModShotlocks.registry.get().getValue(new ResourceLocation(shotlock));
        if (notification) {
            this.messages.add("S_" + shotlockthis.getTranslationKey());
        }
        if (!this.shotlockList.contains(shotlock)) {
            this.shotlockList.add(shotlock);
        }
    }

    @Override
    public void removeShotlockFromList(String shotlock) {
        if (this.shotlockList.contains(shotlock)) {
            this.shotlockList.remove(shotlock);
        }
    }

    @Override
    public void setMunny(int amount) {
        this.munny = amount;
    }

    @Override
    public int getMunny() {
        return this.munny;
    }

    @Override
    public Map<ResourceLocation, ItemStack> getEquippedKeychains() {
        return this.equippedKeychains;
    }

    @Override
    public ItemStack equipKeychain(ResourceLocation form, ItemStack stack) {
        if (this.canEquipKeychain(form, stack)) {
            ItemStack previous = this.getEquippedKeychain(form);
            this.equippedKeychains.put(form, stack);
            return previous;
        }
        return null;
    }

    @Override
    public ItemStack getEquippedKeychain(ResourceLocation form) {
        if (this.equippedKeychains.containsKey(form)) {
            return this.equippedKeychains.get(form);
        }
        return null;
    }

    @Override
    public void equipAllKeychains(Map<ResourceLocation, ItemStack> keychains, boolean force) {
        if (!force) {
            keychains.replaceAll((k, v) -> this.canEquipKeychain((ResourceLocation)k, (ItemStack)v) ? v : ItemStack.f_41583_);
        }
        this.equippedKeychains = keychains;
    }

    @Override
    public boolean canEquipKeychain(ResourceLocation form, ItemStack stack) {
        return this.getEquippedKeychain(form) != null && ItemStack.m_41728_((ItemStack)stack, (ItemStack)ItemStack.f_41583_) | stack.m_41720_() instanceof IKeychain && stack.m_41613_() <= 1;
    }

    @Override
    public void setNewKeychain(ResourceLocation form, ItemStack stack) {
        if (!this.equippedKeychains.containsKey(form)) {
            this.equippedKeychains.put(form, stack);
        }
    }

    @Override
    public Map<Integer, ItemStack> getEquippedItems() {
        return this.equippedItems;
    }

    @Override
    public ItemStack equipItem(int slot, ItemStack stack) {
        if (this.canEquipItem(slot, stack)) {
            ItemStack previous = this.getEquippedItem(slot);
            this.equippedItems.put(slot, stack);
            return previous;
        }
        return null;
    }

    @Override
    public ItemStack getEquippedItem(int slot) {
        if (this.equippedItems.containsKey(slot)) {
            return this.equippedItems.get(slot);
        }
        return null;
    }

    @Override
    public void equipAllItems(Map<Integer, ItemStack> Items2, boolean force) {
        if (!force) {
            Items2.replaceAll((k, v) -> this.canEquipItem((int)k, (ItemStack)v) ? v : ItemStack.f_41583_);
        }
        this.equippedItems = Items2;
    }

    @Override
    public boolean canEquipItem(int slot, ItemStack stack) {
        return this.getEquippedItem(slot) != null && (ItemStack.m_41728_((ItemStack)stack, (ItemStack)ItemStack.f_41583_) || stack.m_41720_() instanceof KKPotionItem) && stack.m_41613_() <= 1;
    }

    @Override
    public void setNewItem(int slot, ItemStack stack) {
        if (!this.equippedItems.containsKey(slot)) {
            this.equippedItems.put(slot, stack);
        }
    }

    @Override
    public Map<Integer, ItemStack> getEquippedAccessories() {
        return this.equippedAccessories;
    }

    @Override
    public ItemStack equipAccessory(int slot, ItemStack stack) {
        if (this.canEquipAccessory(slot, stack)) {
            ItemStack previous = this.getEquippedAccessory(slot);
            this.equippedAccessories.put(slot, stack);
            return previous;
        }
        return null;
    }

    @Override
    public ItemStack getEquippedAccessory(int slot) {
        if (this.equippedAccessories.containsKey(slot)) {
            return this.equippedAccessories.get(slot);
        }
        return null;
    }

    @Override
    public void equipAllAccessories(Map<Integer, ItemStack> accessories, boolean force) {
        if (!force) {
            accessories.replaceAll((k, v) -> this.canEquipAccessory((int)k, (ItemStack)v) ? v : ItemStack.f_41583_);
        }
        this.equippedAccessories = accessories;
    }

    @Override
    public boolean canEquipAccessory(int slot, ItemStack stack) {
        return this.getEquippedAccessory(slot) != null && (ItemStack.m_41728_((ItemStack)stack, (ItemStack)ItemStack.f_41583_) || stack.m_41720_() instanceof KKAccessoryItem) && stack.m_41613_() <= 1;
    }

    @Override
    public void setNewAccessory(int slot, ItemStack stack) {
        if (!this.equippedAccessories.containsKey(slot)) {
            this.equippedAccessories.put(slot, stack);
        }
    }

    @Override
    public Map<Integer, ItemStack> getEquippedKBArmors() {
        return this.equippedKBArmors;
    }

    @Override
    public ItemStack equipKBArmor(int slot, ItemStack stack) {
        if (this.canEquipKBArmor(slot, stack)) {
            ItemStack previous = this.getEquippedKBArmor(slot);
            this.equippedKBArmors.put(slot, stack);
            return previous;
        }
        return null;
    }

    @Override
    public ItemStack getEquippedKBArmor(int slot) {
        if (this.equippedKBArmors.containsKey(slot)) {
            return this.equippedKBArmors.get(slot);
        }
        return null;
    }

    @Override
    public void equipAllKBArmor(Map<Integer, ItemStack> KBArmors, boolean force) {
        if (!force) {
            KBArmors.replaceAll((k, v) -> this.canEquipKBArmor((int)k, (ItemStack)v) ? v : ItemStack.f_41583_);
        }
        this.equippedKBArmors = KBArmors;
    }

    @Override
    public boolean canEquipKBArmor(int slot, ItemStack stack) {
        return this.getEquippedKBArmor(slot) != null && (ItemStack.m_41728_((ItemStack)stack, (ItemStack)ItemStack.f_41583_) || stack.m_41720_() instanceof PauldronItem) && stack.m_41613_() <= 1;
    }

    @Override
    public void setNewKBArmor(int slot, ItemStack stack) {
        if (!this.equippedKBArmors.containsKey(slot)) {
            this.equippedKBArmors.put(slot, stack);
        }
    }

    @Override
    public int getNotifColor() {
        return this.notifColor;
    }

    @Override
    public void setNotifColor(int color) {
        this.notifColor = color;
    }

    @Override
    public int getArmorColor() {
        return this.armorColor;
    }

    @Override
    public void setArmorColor(int color) {
        this.armorColor = color;
    }

    @Override
    public boolean getArmorGlint() {
        return this.armorGlint;
    }

    @Override
    public void setArmorGlint(boolean glint) {
        this.armorGlint = glint;
    }

    @Override
    public Map<Integer, ItemStack> getEquippedArmors() {
        return this.equippedArmors;
    }

    @Override
    public ItemStack getEquippedArmor(int slot) {
        if (this.equippedArmors.containsKey(slot)) {
            return this.equippedArmors.get(slot);
        }
        return null;
    }

    @Override
    public ItemStack equipArmor(int slot, ItemStack stack) {
        if (this.canEquipArmor(slot, stack)) {
            ItemStack previous = this.getEquippedArmor(slot);
            this.equippedArmors.put(slot, stack);
            return previous;
        }
        return null;
    }

    @Override
    public boolean canEquipArmor(int slot, ItemStack stack) {
        return this.getEquippedArmor(slot) != null && (ItemStack.m_41728_((ItemStack)stack, (ItemStack)ItemStack.f_41583_) || stack.m_41720_() instanceof KKArmorItem) && stack.m_41613_() <= 1;
    }

    @Override
    public void equipAllArmors(Map<Integer, ItemStack> armors, boolean force) {
        if (!force) {
            armors.replaceAll((k, v) -> this.canEquipArmor((int)k, (ItemStack)v) ? v : ItemStack.f_41583_);
        }
        this.equippedArmors = armors;
    }

    @Override
    public void setNewArmor(int slot, ItemStack stack) {
        if (!this.equippedArmors.containsKey(slot)) {
            this.equippedArmors.put(slot, stack);
        }
    }

    @Override
    public int getHearts() {
        return this.hearts;
    }

    @Override
    public void setHearts(int hearts) {
        this.hearts = Math.max(0, hearts);
    }

    @Override
    public void addHearts(int hearts) {
        this.hearts = Mth.m_14045_((int)(this.hearts + hearts), (int)0, (int)Integer.MAX_VALUE);
    }

    @Override
    public void removeHearts(int hearts) {
        this.addHearts(-hearts);
    }

    @Override
    public Utils.OrgMember getAlignment() {
        return this.alignment;
    }

    @Override
    public int getAlignmentIndex() {
        return this.alignment.ordinal();
    }

    @Override
    public void setAlignment(int index) {
        this.alignment = Utils.OrgMember.values()[index];
    }

    @Override
    public void setAlignment(Utils.OrgMember member) {
        this.alignment = member;
    }

    @Override
    public boolean isWeaponUnlocked(Item weapon) {
        for (ItemStack stack : this.weaponUnlocks) {
            if (stack.m_41720_() != weapon) continue;
            return true;
        }
        return false;
    }

    @Override
    public void unlockWeapon(ItemStack weapon) {
        if (!this.weaponUnlocks.contains(weapon)) {
            this.weaponUnlocks.add(weapon);
        }
    }

    @Override
    public void unlockWeapon(String registryName) {
        ItemStack weaponUnlock;
        Item weapon = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(registryName));
        if (weapon != null && !this.weaponUnlocks.contains(weaponUnlock = new ItemStack((ItemLike)weapon))) {
            this.weaponUnlocks.add(weaponUnlock);
        }
    }

    @Override
    public ItemStack getEquippedWeapon() {
        return this.equippedWeapon;
    }

    @Override
    public void equipWeapon(ItemStack weapon) {
        this.equippedWeapon = weapon;
    }

    @Override
    public Set<ItemStack> getWeaponsUnlocked() {
        return this.weaponUnlocks;
    }

    @Override
    public void setWeaponsUnlocked(Set<ItemStack> unlocks) {
        this.weaponUnlocks = unlocks;
    }

    @Override
    public int getLimitCooldownTicks() {
        return this.limitCooldownTicks;
    }

    @Override
    public void setLimitCooldownTicks(int ticks) {
        this.limitCooldownTicks = ticks;
    }

    @Override
    public boolean getIsGliding() {
        return this.isGliding;
    }

    @Override
    public void setIsGliding(boolean b) {
        this.isGliding = b;
    }

    @Override
    public int getAerialDodgeTicks() {
        return this.aerialDodgeTicks;
    }

    @Override
    public void setAerialDodgeTicks(int ticks) {
        this.aerialDodgeTicks = ticks;
    }

    @Override
    public boolean hasJumpedAerialDodge() {
        return this.hasJumpedAerealDodge;
    }

    @Override
    public void setHasJumpedAerialDodge(boolean b) {
        this.hasJumpedAerealDodge = b;
    }

    @Override
    public LinkedHashMap<String, int[]> getAbilityMap() {
        return this.abilityMap;
    }

    @Override
    public void setAbilityMap(LinkedHashMap<String, int[]> map) {
        this.abilityMap = map;
    }

    @Override
    public void addAbility(String ability, boolean notification) {
        Ability abilitythis = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(ability));
        if (notification) {
            this.messages.add("A_" + abilitythis.getTranslationKey());
        }
        if (this.abilityMap.containsKey(ability)) {
            this.abilityMap.put(ability, new int[]{this.abilityMap.get(ability)[0] + 1, this.abilityMap.get(ability)[1]});
        } else {
            this.abilityMap.put(ability, new int[]{1, 0});
        }
    }

    public void addAbility(String ability, String displayName, boolean dfLevelUp) {
        if (dfLevelUp) {
            this.bfMessages.add("A_" + displayName);
        } else {
            this.messages.add("A_" + displayName);
        }
        if (this.abilityMap.containsKey(ability)) {
            this.abilityMap.put(ability, new int[]{this.abilityMap.get(ability)[0] + 1, this.abilityMap.get(ability)[1]});
        } else {
            this.abilityMap.put(ability, new int[]{1, 0});
        }
    }

    @Override
    public void removeAbility(String ability) {
        if (this.abilityMap.containsKey(ability)) {
            if (this.abilityMap.get(ability)[0] <= 1) {
                this.abilityMap.remove(ability);
            } else {
                this.abilityMap.put(ability, new int[]{this.abilityMap.get(ability)[0] - 1, 0});
            }
        }
    }

    @Override
    public int[] getEquippedAbilityLevel(String string) {
        if (this.abilityMap.containsKey(string)) {
            return this.abilityMap.get(string);
        }
        return new int[]{0, 0};
    }

    @Override
    public boolean isAbilityEquipped(String string) {
        return this.getNumberOfAbilitiesEquipped(string) > 0;
    }

    @Override
    public int getNumberOfAbilitiesEquipped(String ability) {
        List<String> abilities;
        int level;
        IKeychain weapon;
        ItemStack stack;
        int amount = 0;
        if (this.getAlignment() == Utils.OrgMember.NONE) {
            if (this.getEquippedKeychain(DriveForm.NONE) != null && !ItemStack.m_41728_((ItemStack)this.getEquippedKeychain(DriveForm.NONE), (ItemStack)ItemStack.f_41583_)) {
                stack = this.getEquippedKeychain(DriveForm.NONE);
                weapon = (IKeychain)stack.m_41720_();
                level = weapon.toSummon().getKeybladeLevel(stack);
                abilities = Utils.getKeybladeAbilitiesAtLevel((Item)weapon.toSummon(), level);
                amount += Collections.frequency(abilities, ability);
            }
        } else if (this.getEquippedWeapon() != null && !ItemStack.m_41728_((ItemStack)this.getEquippedWeapon(), (ItemStack)ItemStack.f_41583_)) {
            Object[] abilitiesArray;
            if (this.getEquippedWeapon().m_41720_() instanceof KeybladeItem) {
                List<String> abilities2 = Utils.getKeybladeAbilitiesAtLevel(this.getEquippedWeapon().m_41720_(), 0);
                amount += Collections.frequency(abilities2, ability);
            } else if (this.getEquippedWeapon().m_41720_() instanceof IOrgWeapon && (abilitiesArray = ((IOrgWeapon)this.getEquippedWeapon().m_41720_()).getAbilities()) != null) {
                ArrayList a = Lists.newArrayList((Object[])abilitiesArray);
                amount += Collections.frequency(a, ability);
                if (this.abilityMap.containsKey("kingdomkeys:ability_synch_blade") && this.abilityMap.get("kingdomkeys:ability_synch_blade")[1] > 0) {
                    amount *= 2;
                }
            }
        }
        if (this.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
            if (this.abilityMap.containsKey("kingdomkeys:ability_synch_blade") && this.abilityMap.get("kingdomkeys:ability_synch_blade")[1] > 0 && !ItemStack.m_41728_((ItemStack)this.getEquippedKeychain(DriveForm.SYNCH_BLADE), (ItemStack)ItemStack.f_41583_)) {
                stack = this.getEquippedKeychain(DriveForm.SYNCH_BLADE);
                weapon = (IKeychain)this.getEquippedKeychain(DriveForm.SYNCH_BLADE).m_41720_();
                level = weapon.toSummon().getKeybladeLevel(stack);
                abilities = Utils.getKeybladeAbilitiesAtLevel((Item)weapon.toSummon(), level);
                amount += Collections.frequency(abilities, ability);
            }
        } else {
            DriveForm form;
            List<String> list;
            stack = this.getEquippedKeychain(new ResourceLocation(this.getActiveDriveForm()));
            if (stack != null && !ItemStack.m_41728_((ItemStack)stack, (ItemStack)ItemStack.f_41583_)) {
                weapon = (IKeychain)this.getEquippedKeychain(new ResourceLocation(this.getActiveDriveForm())).m_41720_();
                level = weapon.toSummon().getKeybladeLevel(stack);
                abilities = Utils.getKeybladeAbilitiesAtLevel((Item)weapon.toSummon(), level);
                amount += Collections.frequency(abilities, ability);
            }
            if ((list = (form = (DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(this.getActiveDriveForm()))).getDriveFormData().getAbilities()) != null && !list.isEmpty()) {
                amount += Collections.frequency(list, ability);
            }
        }
        amount += Collections.frequency(Utils.getAccessoriesAbilities(this), ability);
        if (((Ability)ModAbilities.registry.get().getValue(new ResourceLocation(ability))).getType() != Ability.AbilityType.GROWTH) {
            return amount + (this.abilityMap.containsKey(ability) ? Integer.bitCount(this.abilityMap.get(ability)[1]) : 0);
        }
        return this.abilityMap.containsKey(ability) ? this.abilityMap.get(ability)[1] : 0;
    }

    @Override
    public boolean isAbilityEquipped(String ability, int index) {
        int indexConvert = (int)Math.pow(2.0, index);
        if (this.abilityMap.containsKey(ability)) {
            if (this.abilityMap.get(ability)[0] < index) {
                return false;
            }
            return (this.abilityMap.get(ability)[1] & indexConvert) == indexConvert;
        }
        return false;
    }

    @Override
    public void equipAbilityToggle(String ability, int index) {
        int indexConvert = (int)Math.pow(2.0, index);
        if (this.abilityMap.containsKey(ability) && this.abilityMap.get(ability)[0] >= index) {
            int[] nArray = this.abilityMap.get(ability);
            nArray[1] = nArray[1] ^ indexConvert;
        }
    }

    @Override
    public void equipAbility(String ability, int index) {
        int indexConvert = (int)Math.pow(2.0, index);
        if (this.abilityMap.containsKey(ability) && this.abilityMap.get(ability)[0] >= index) {
            int[] nArray = this.abilityMap.get(ability);
            nArray[1] = nArray[1] | indexConvert;
        }
    }

    @Override
    public void unequipAbility(String ability, int index) {
        int indexConvert = (int)Math.pow(2.0, index);
        if (this.abilityMap.containsKey(ability) && this.abilityMap.get(ability)[0] >= indexConvert) {
            int[] nArray = this.abilityMap.get(ability);
            nArray[1] = nArray[1] & ~indexConvert;
        }
    }

    @Override
    public void addEquippedAbilityLevel(String ability, int level) {
        this.abilityMap.put(ability, new int[]{this.abilityMap.get(ability)[0], this.abilityMap.get(ability)[1] + level});
    }

    @Override
    public int getAbilityQuantity(String ability) {
        if (((Ability)ModAbilities.registry.get().getValue(new ResourceLocation(ability))).getType() != Ability.AbilityType.GROWTH) {
            return this.abilityMap.get(ability)[0] + 1;
        }
        return 1;
    }

    @Override
    public void clearAbilities() {
        this.abilityMap.clear();
    }

    @Override
    public List<String> getPartiesInvited() {
        return this.partyList;
    }

    @Override
    public void setPartiesInvited(List<String> list) {
        this.partyList = list;
    }

    @Override
    public void addPartiesInvited(String partyName) {
        this.partyList.add(partyName);
    }

    @Override
    public void removePartiesInvited(String partyName) {
        this.partyList.remove(partyName);
    }

    @Override
    public List<ResourceLocation> getKnownRecipeList() {
        return this.recipeList;
    }

    @Override
    public void setKnownRecipeList(List<ResourceLocation> list) {
        this.recipeList = list;
    }

    @Override
    public boolean hasKnownRecipe(ResourceLocation recipe) {
        return this.recipeList.contains(recipe);
    }

    @Override
    public void addKnownRecipe(ResourceLocation recipe) {
        if (!this.recipeList.contains(recipe)) {
            this.recipeList.add(recipe);
            Collections.sort(this.recipeList);
        }
    }

    @Override
    public void removeKnownRecipe(ResourceLocation recipe) {
        if (this.recipeList.contains(recipe)) {
            this.recipeList.remove(recipe);
            Collections.sort(this.recipeList);
        }
    }

    @Override
    public void clearRecipes(String type) {
        switch (type) {
            case "all": {
                this.recipeList.clear();
                break;
            }
            case "keyblade": {
                ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
                for (ResourceLocation rl : this.recipeList) {
                    Recipe r = RecipeRegistry.getInstance().getValue(rl);
                    if (!r.getType().equals("keyblade")) continue;
                    list.add(rl);
                }
                this.recipeList.removeAll(list);
                break;
            }
            case "item": {
                ArrayList<ResourceLocation> list2 = new ArrayList<ResourceLocation>();
                for (ResourceLocation rl : this.recipeList) {
                    Recipe r = RecipeRegistry.getInstance().getValue(rl);
                    if (!r.getType().equals("item")) continue;
                    list2.add(rl);
                }
                this.recipeList.removeAll(list2);
            }
        }
    }

    @Override
    public TreeMap<ResourceLocation, Integer> getMaterialMap() {
        return this.materials;
    }

    @Override
    public void setMaterialMap(TreeMap<ResourceLocation, Integer> materialMap) {
        this.materials = materialMap;
    }

    @Override
    public int getMaterialAmount(Item material) {
        ResourceLocation regName = ForgeRegistries.ITEMS.getKey((Object)material);
        if (this.materials.containsKey(regName)) {
            int currAmount = this.materials.get(regName);
            return currAmount;
        }
        return 0;
    }

    @Override
    public void addMaterial(Item material, int amount) {
        ResourceLocation regName = ForgeRegistries.ITEMS.getKey((Object)material);
        if (this.materials.containsKey(regName)) {
            int currAmount = this.materials.get(regName);
            if (amount <= 0) {
                this.materials.remove(regName);
            } else {
                this.materials.replace(regName, currAmount + amount);
            }
        } else if (amount <= 0) {
            this.materials.remove(regName);
        } else {
            this.materials.put(regName, amount);
        }
    }

    @Override
    public void setMaterial(Item material, int amount) {
        ResourceLocation regName = ForgeRegistries.ITEMS.getKey((Object)material);
        if (this.materials.containsKey(regName)) {
            if (amount <= 0) {
                this.materials.remove(regName);
            } else {
                this.materials.replace(regName, amount);
            }
        } else if (amount <= 0) {
            this.materials.remove(regName);
        } else {
            this.materials.put(regName, amount);
        }
    }

    @Override
    public void removeMaterial(Item material, int amount) {
        ResourceLocation regName = ForgeRegistries.ITEMS.getKey((Object)material);
        if (this.materials.containsKey(regName)) {
            int currAmount = this.materials.get(regName);
            if (amount > currAmount) {
                amount = currAmount;
            }
            this.materials.replace(regName, currAmount - amount);
        }
    }

    @Override
    public void clearMaterials() {
        this.materials.clear();
    }

    @Override
    public Vec3 getReturnLocation() {
        return this.returnPos;
    }

    @Override
    public void setReturnLocation(Player playerEntity) {
        this.setReturnLocation(playerEntity.m_20182_());
    }

    @Override
    public void setReturnLocation(Vec3 location) {
        this.returnPos = location;
    }

    @Override
    public ResourceKey<Level> getReturnDimension() {
        return this.returnDim;
    }

    @Override
    public void setReturnDimension(Player playerEntity) {
        this.setReturnDimension((ResourceKey<Level>)playerEntity.m_9236_().m_46472_());
    }

    @Override
    public void setReturnDimension(ResourceKey<Level> type) {
        this.returnDim = type;
    }

    @Override
    public SoAState getSoAState() {
        return this.soAState;
    }

    @Override
    public void setSoAState(SoAState state) {
        this.soAState = state;
    }

    @Override
    public SoAState getChosen() {
        return this.choice;
    }

    @Override
    public void setChoice(SoAState choice) {
        this.choice = choice;
    }

    @Override
    public SoAState getSacrificed() {
        return this.sacrifice;
    }

    @Override
    public void setSacrifice(SoAState sacrifice) {
        this.sacrifice = sacrifice;
    }

    @Override
    public BlockPos getChoicePedestal() {
        return this.choicePedestal;
    }

    @Override
    public void setChoicePedestal(BlockPos pos) {
        this.choicePedestal = pos;
    }

    @Override
    public BlockPos getSacrificePedestal() {
        return this.sacrificePedestal;
    }

    @Override
    public void setSacrificePedestal(BlockPos pos) {
        this.sacrificePedestal = pos;
    }

    @Override
    public String getEquippedShotlock() {
        return this.equippedShotlock;
    }

    @Override
    public void setEquippedShotlock(String shotlock) {
        this.equippedShotlock = shotlock;
    }

    @Override
    public void setMagicCasttimeTicks(int ticks) {
        this.magicCasttime = ticks;
    }

    @Override
    public void remMagicCasttimeTicks(int ticks) {
        this.magicCasttime = Math.max(this.magicCasttime - ticks, 0);
    }

    @Override
    public int getMagicCasttimeTicks() {
        return this.magicCasttime;
    }

    @Override
    public void setMagicCooldownTicks(int ticks) {
        this.magicCooldown = ticks;
    }

    @Override
    public void remMagicCooldownTicks(int ticks) {
        this.magicCooldown = Math.max(this.magicCooldown - ticks, 0);
    }

    @Override
    public int getMagicCooldownTicks() {
        return this.magicCooldown;
    }

    @Override
    public List<String> getReactionCommands() {
        return this.reactionList;
    }

    @Override
    public void setReactionCommands(List<String> list) {
        this.reactionList = list;
    }

    @Override
    public boolean addReactionCommand(String command, Player player) {
        if (this.reactionList.contains(command)) {
            return false;
        }
        if (((ReactionCommand)ModReactionCommands.registry.get().getValue(new ResourceLocation(command))).conditionsToAppear(player, (LivingEntity)player)) {
            this.reactionList.add(command);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeReactionCommand(String command) {
        if (this.reactionList.contains(command)) {
            this.reactionList.remove(command);
            return true;
        }
        return false;
    }

    @Override
    public LinkedHashMap<Integer, String> getShortcutsMap() {
        return this.shortcutsMap;
    }

    @Override
    public void setShortcutsMap(LinkedHashMap<Integer, String> map) {
        this.shortcutsMap = map;
    }

    @Override
    public void changeShortcut(int position, String name, int level) {
        this.shortcutsMap.put(position, name + "," + level);
    }

    @Override
    public void removeShortcut(int position) {
        this.shortcutsMap.remove(position);
    }

    @Override
    public int getSynthLevel() {
        return this.synthLevel;
    }

    @Override
    public void setSynthLevel(int level) {
        this.synthLevel = level;
    }

    @Override
    public int getSynthExperience() {
        return this.synthExp;
    }

    @Override
    public void setSynthExperience(int exp) {
        this.synthExp = exp;
    }

    @Override
    public void addSynthExperience(int exp) {
        if (this.synthLevel < 7) {
            this.synthExp += exp;
            while (this.getSynthExpNeeded(this.getSynthLevel(), this.synthExp) <= 0 && this.getSynthLevel() <= 7) {
                this.setSynthLevel(this.getSynthLevel() + 1);
            }
        }
    }

    public int getSynthExpNeeded(int level, int currentExp) {
        if (level > 7) {
            return 0;
        }
        double nextLevel = ((double)level + 300.0 * Math.pow(2.0, (double)level / 8.0)) * ((double)level * 0.25);
        this.remainingSynthExp = (int)nextLevel - currentExp;
        return this.remainingSynthExp;
    }

    @Override
    public boolean getRespawnROD() {
        return this.respawnROD;
    }

    @Override
    public void setRespawnROD(boolean respawn) {
        this.respawnROD = respawn;
    }

    @Override
    public SingleChoices getSingleStyle() {
        return this.singleStyle;
    }

    @Override
    public void setSingleStyle(SingleChoices singleStyle) {
        this.singleStyle = singleStyle;
    }

    @Override
    public DualChoices getDualStyle() {
        return this.dualStyle;
    }

    @Override
    public void setDualStyle(DualChoices dualStyle) {
        this.dualStyle = dualStyle;
    }

    @Override
    public int getMaxAccessories() {
        return this.maxAccessories;
    }

    @Override
    public void setMaxAccessories(int num) {
        this.maxAccessories = num;
    }

    @Override
    public void addMaxAccessories(int num) {
        this.maxAccessories += num;
        this.messages.add("C_stats.levelUpMaxAccessories");
    }

    @Override
    public int getMaxArmors() {
        return this.maxArmors;
    }

    @Override
    public void setMaxArmors(int num) {
        this.maxArmors = num;
    }

    @Override
    public void addMaxArmors(int num) {
        this.maxArmors += num;
        this.messages.add("R_stats.levelUpMaxArmors");
    }

    @Override
    public void setCastedMagic(Utils.castMagic castMagic2) {
        this.castMagic = castMagic2;
        if (castMagic2 != null) {
            this.magicCasttime = castMagic2.magic().getCasttimeTicks(castMagic2.level());
        }
    }

    @Override
    public BlockPos getAirStep() {
        return this.airStepPos;
    }

    @Override
    public void setAirStep(BlockPos pos) {
        this.airStepPos = pos;
    }

    @Override
    public Map<UUID, Instant> discoveredSavePoints() {
        return this.discoveredSavePoints;
    }

    @Override
    public void addDiscoveredSavePoint(UUID id, Instant time) {
        this.discoveredSavePoints.put(id, time);
    }

    @Override
    public void setDiscoveredSavePoints(Map<UUID, Instant> list) {
        this.discoveredSavePoints = list;
    }

    @Override
    public Utils.castMagic getCastedMagic() {
        return this.castMagic;
    }
}

