/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements;

import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import online.kingdomkeys.kingdomkeys.api.event.client.CommandMenuEvent;
import online.kingdomkeys.kingdomkeys.client.gui.elements.CommandMenuSubMenu;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.CommandMenuGui;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;

public class CommandMenuItem {
    OnEnter onEnter;
    OnCancel onCancel;
    OnUpdate onUpdate;
    boolean active = true;
    boolean visible = true;
    Component message;
    CommandMenuSubMenu parent;
    int height;
    int width;
    ResourceLocation id;
    Color textColour;
    double sorting;
    Supplier<ResourceLocation> iconTexture;
    int iconU;
    int iconV;
    boolean hasIcon;

    private CommandMenuItem(Builder builder) {
        this.parent = builder.parent;
        this.message = builder.message;
        this.onEnter = builder.onEnter;
        this.onCancel = builder.onCancel;
        this.onUpdate = builder.onUpdate;
        this.height = builder.height;
        this.width = builder.width;
        this.id = builder.id;
        this.textColour = builder.textColour;
        this.active = builder.active;
        this.visible = builder.visible;
        this.sorting = builder.sorting;
        this.iconTexture = builder.iconTexture != null ? builder.iconTexture : () -> this.parent.getTexture();
        this.iconU = builder.iconU;
        this.iconV = builder.iconV;
        this.hasIcon = builder.hasIcon;
    }

    public int getHeight() {
        return this.height;
    }

    public void onEnter() {
        if (!this.active) {
            CommandMenuGui.INSTANCE.playErrorSound();
        }
        if (this.active && this.onEnter != null && !MinecraftForge.EVENT_BUS.post((Event)new CommandMenuEvent.ItemEnter(this.getId(), this, this.onEnter))) {
            this.onEnter.onEnter(this);
        }
    }

    public void onCancel() {
        if (this.onCancel != null && !MinecraftForge.EVENT_BUS.post((Event)new CommandMenuEvent.ItemCancel(this.getId(), this, this.onCancel))) {
            this.onCancel.onCancel(this);
        }
    }

    public void onUpdate(GuiGraphics guiGraphics) {
        if (this.onUpdate != null && !MinecraftForge.EVENT_BUS.post((Event)new CommandMenuEvent.ItemUpdate(this.getId(), this, guiGraphics, this.onUpdate))) {
            this.onUpdate.onUpdate(this, guiGraphics);
        }
    }

    public void setTextColour(Color textColour) {
        this.textColour = textColour;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public Component getMessage() {
        return this.message;
    }

    public void setMessage(Component message) {
        this.message = message;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public double getSorting() {
        return this.sorting;
    }

    public void setSorting(double sorting) {
        this.sorting = sorting;
    }

    public CommandMenuSubMenu getParent() {
        return this.parent;
    }

    public int getX() {
        return this.parent.getSelected().equals(this) ? this.parent.getX() + ModConfigs.cmSelectedXOffset : this.parent.getX();
    }

    public int getY() {
        return this.parent.getChildY(this);
    }

    public void render(GuiGraphics guiGraphics, int x, int y, int screenWidth, int screenHeight, float partialTick) {
        guiGraphics.m_280246_((float)this.parent.getColour().getRed() / 255.0f, (float)this.parent.getColour().getGreen() / 255.0f, (float)this.parent.getColour().getBlue() / 255.0f, 1.0f);
        guiGraphics.m_280218_(this.parent.getTexture(), this.parent.getSelected().equals(this) ? x + ModConfigs.cmSelectedXOffset : x, y, 70, this.parent.getSelected().equals(this) ? 15 : 0, 4, 15);
        guiGraphics.m_280411_(this.parent.getTexture(), this.parent.getSelected().equals(this) ? x + 4 + ModConfigs.cmSelectedXOffset : x + 4, y, this.width - 9, this.height, 74.0f, this.parent.getSelected().equals(this) ? 15.0f : 0.0f, 1, 15, 256, 256);
        guiGraphics.m_280218_(this.parent.getTexture(), this.parent.getSelected().equals(this) ? x + this.width - 5 + ModConfigs.cmSelectedXOffset : x + this.width - 5, y, 135, this.parent.getSelected().equals(this) ? 15 : 0, 5, 15);
        Color textColour = this.parent.isActive() ? this.textColour : this.textColour.darker().darker();
        guiGraphics.m_280246_((float)textColour.getRed() / 255.0f, (float)textColour.getGreen() / 255.0f, (float)textColour.getBlue() / 255.0f, 1.0f);
        guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, this.getMessage(), this.parent.getSelected().equals(this) ? x + 6 + ModConfigs.cmSelectedXOffset : x + 6, y + 4, this.isActive() ? Color.WHITE.getRGB() : Color.WHITE.darker().darker().getRGB());
        if (this.hasIcon && this.getParent().getSelected().equals(this)) {
            Color iconColour = this.parent.isActive() ? Color.WHITE : Color.WHITE.darker().darker();
            guiGraphics.m_280246_((float)iconColour.getRed() / 255.0f, (float)iconColour.getGreen() / 255.0f, (float)iconColour.getBlue() / 255.0f, 1.0f);
            guiGraphics.m_280218_(this.iconTexture.get(), x + ModConfigs.cmSelectedXOffset + this.width - 5 - 10, y + 2, this.iconU, this.iconV, 10, 10);
        }
    }

    public static class Builder {
        private final ResourceLocation id;
        private CommandMenuSubMenu parent;
        private final Component message;
        private final OnEnter onEnter;
        private OnCancel onCancel;
        private OnUpdate onUpdate;
        private boolean active = true;
        private boolean visible = true;
        private int height = 15;
        private int width = 70;
        private Color textColour = Color.WHITE;
        private double sorting;
        private Supplier<ResourceLocation> iconTexture;
        private int iconU;
        private int iconV;
        private boolean hasIcon = false;

        public Builder(ResourceLocation id, Component message, OnEnter onEnter) {
            this.id = id;
            this.message = message;
            this.onEnter = onEnter;
        }

        public Builder onCancel(OnCancel onCancel) {
            this.onCancel = onCancel;
            return this;
        }

        public Builder onUpdate(OnUpdate onUpdate) {
            this.onUpdate = onUpdate;
            return this;
        }

        public Builder inactiveByDefault() {
            this.active = false;
            return this;
        }

        public Builder invisibleByDefault() {
            this.visible = false;
            return this;
        }

        public Builder textColour(Color textColour) {
            this.textColour = textColour;
            return this;
        }

        public Builder height(int height) {
            this.height = height;
            return this;
        }

        public Builder width(int width) {
            this.width = width;
            return this;
        }

        public Builder sorting(double sorting) {
            this.sorting = sorting;
            return this;
        }

        public Builder iconUV(int iconU, int iconV) {
            this.iconU = iconU;
            this.iconV = iconV;
            this.hasIcon = true;
            return this;
        }

        public Builder iconTexture(Supplier<ResourceLocation> iconTexture) {
            this.iconTexture = iconTexture;
            this.hasIcon = true;
            return this;
        }

        public CommandMenuItem build(CommandMenuSubMenu parent) {
            this.parent = parent;
            if (this.onCancel == null && parent.getParent() != null) {
                this.onCancel = item -> {
                    CommandMenuGui.INSTANCE.changeSubmenu(parent.getParent().getId(), false);
                    CommandMenuGui.INSTANCE.playBackSound();
                };
            }
            return new CommandMenuItem(this);
        }
    }

    public static interface OnEnter {
        public void onEnter(CommandMenuItem var1);
    }

    public static interface OnCancel {
        public void onCancel(CommandMenuItem var1);
    }

    public static interface OnUpdate {
        public void onUpdate(CommandMenuItem var1, GuiGraphics var2);
    }
}

