/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements.buttons;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import org.jetbrains.annotations.NotNull;

public class MenuScrollBar
extends Button {
    double clickX;
    double clickY;
    public int startX;
    public int startY;
    public int handleY;
    public int handleYMax;
    public int localHandleY;
    public int localHandleYMax;
    public int visibleHeight;
    float scrollPercent;
    private int contentHeight;
    private int handleHeight;
    public float scrollOffset;
    final int handleEndOffset = 3;
    public static final int WIDTH = 14;
    ResourceLocation texture = new ResourceLocation("kingdomkeys", "textures/gui/menu/menu_button.png");
    final Vec2 barTopUV = new Vec2(26, 29);
    final Vec2 barBottomUV = new Vec2(26, 47);
    final Vec2 handleTopUV = new Vec2(41, 29);
    final Vec2 handleMiddleUV = new Vec2(41, 39);
    final Vec2 handleBottomUV = new Vec2(41, 41);
    final Vec2 barTopBotDims = new Vec2(14, 17);
    final Vec2 handleDims = new Vec2(14, 9);

    public MenuScrollBar(int x, int y, int height, int visibleHeight, int contentHeight) {
        super(new Button.Builder((Component)Component.m_237119_(), button -> {}).m_252987_(x, y, 14, height));
        this.visibleHeight = visibleHeight;
        this.handleYMax = this.m_252907_() + 3 + this.barTopBotDims.Y;
        int handleBottom = height - 3 - this.barTopBotDims.Y;
        this.handleY = this.handleYMax;
        this.localHandleYMax = handleBottom - this.handleYMax + 1;
        this.setContentHeight(contentHeight);
    }

    public void setHandleY(int handleY) {
        this.handleY = handleY < this.handleYMax ? this.handleYMax : handleY;
    }

    public void setHandleHeight(int height) {
        this.handleHeight = height;
        if (this.handleY > this.getHandleBottom()) {
            this.handleY = this.getHandleBottom() + 1;
        } else if (this.handleY < this.handleYMax) {
            this.handleY = this.handleYMax;
        }
    }

    public int getHandleBottom() {
        return this.f_93619_ - 3 - this.barTopBotDims.Y - this.handleHeight;
    }

    public void setContentHeight(int contentHeight) {
        this.contentHeight = contentHeight;
        float visiblePercentage = (float)this.visibleHeight / (float)contentHeight * 100.0f;
        this.setHandleHeight((int)((float)this.localHandleYMax * (visiblePercentage / 100.0f)));
        if (this.visibleHeight > contentHeight) {
            this.scrollOffset = 0.0f;
        }
    }

    public void m_88315_(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93624_ && this.contentHeight > this.visibleHeight) {
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            int backgroundOffset = 7;
            gui.m_280509_(this.m_252754_(), this.m_252907_() + 7, this.m_252754_() + this.f_93618_, this.f_93619_ - 7, new Color(0.0f, 0.0f, 0.0f, 0.5f).hashCode());
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ClientUtils.blitScaled(this.texture, gui, this.m_252754_(), this.m_252907_(), this.barTopUV.X, this.barTopUV.Y, this.barTopBotDims.X, this.barTopBotDims.Y, 1.0f);
            ClientUtils.blitScaled(this.texture, gui, this.m_252754_(), this.handleY - this.handleDims.Y, this.handleTopUV.X, this.handleTopUV.Y, this.handleDims.X, this.handleDims.Y, 1.0f);
            for (int i = 0; i < this.handleHeight; ++i) {
                ClientUtils.blitScaled(this.texture, gui, this.m_252754_(), this.handleY, this.handleMiddleUV.X, this.handleMiddleUV.Y, this.handleDims.X, 1, 1.0f, this.handleHeight);
            }
            ClientUtils.blitScaled(this.texture, gui, this.m_252754_(), this.handleY + this.handleHeight, this.handleBottomUV.X, this.handleBottomUV.Y, this.handleDims.X, this.handleDims.Y, 1.0f);
            ClientUtils.blitScaled(this.texture, gui, this.m_252754_(), this.f_93619_ - this.barTopBotDims.Y, this.barBottomUV.X, this.barBottomUV.Y, this.barTopBotDims.X, this.barTopBotDims.Y, 1.0f);
        }
    }

    public void updateScroll() {
        if (this.f_93624_ && this.contentHeight > this.visibleHeight) {
            this.localHandleY = this.handleY - this.handleYMax;
            this.scrollPercent = (float)this.localHandleY / (float)(this.localHandleYMax - this.handleHeight) * 100.0f;
            int totalScroll = this.contentHeight - this.visibleHeight;
            this.scrollOffset = (float)totalScroll * (this.scrollPercent / 100.0f);
        } else {
            this.scrollOffset = 0.0f;
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0 && this.f_93624_ && this.contentHeight > this.visibleHeight && this.clickX >= (double)this.m_252754_() && this.clickX <= (double)(this.m_252754_() + this.f_93618_)) {
            this.updateScroll();
            if (this.f_93623_) {
                this.handleY = (double)this.startY - (this.clickY - mouseY) >= (double)(this.getHandleBottom() + 1) ? this.getHandleBottom() + 1 : ((double)this.startY - (this.clickY - mouseY) <= (double)this.handleYMax ? this.handleYMax : (int)((double)this.startY - (this.clickY - mouseY)));
            }
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.clickX = mouseX;
            this.clickY = mouseY;
            this.startX = this.m_252754_();
            this.startY = this.handleY;
            if (this.clickY >= (double)this.m_252907_() && this.clickY <= (double)(this.m_252907_() + this.f_93619_) && this.clickX >= (double)this.m_252754_() && this.clickX <= (double)(this.m_252754_() + this.f_93618_) && this.f_93624_) {
                this.m_7435_(Minecraft.m_91087_().m_91106_());
            }
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        if (this.f_93624_ && this.contentHeight > this.visibleHeight) {
            int scrollFactor = 5;
            int oldY = this.handleY;
            if (scrollDelta > 0.0) {
                this.handleY = (int)Math.max((double)this.handleY - scrollDelta * (double)scrollFactor, (double)this.handleYMax);
            }
            if (scrollDelta < 0.0) {
                this.handleY = (int)Math.min((double)this.handleY - scrollDelta * (double)scrollFactor, (double)(this.getHandleBottom() + 1));
            }
            if (oldY != this.handleY) {
                Minecraft.m_91087_().f_91074_.m_5496_((SoundEvent)ModSounds.menu_move.get(), 1.0f, 1.0f);
            }
            this.updateScroll();
        }
        return super.m_6050_(mouseX, mouseY, scrollDelta);
    }

    record Vec2(int X, int Y) {
    }
}

