/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.menu.abilities;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.api.event.AbilityEvent;
import online.kingdomkeys.kingdomkeys.api.item.IKeychain;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.GuiHelper;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBox;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuAbilitiesButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuScrollBar;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSSetEquippedAbilityPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MenuAbilitiesScreen
extends MenuBackground {
    String form = DriveForm.NONE.toString();
    IPlayerCapabilities playerData;
    LinkedHashMap<String, int[]> abilitiesMap;
    List<MenuAbilitiesButton> abilities;
    MenuBox box;
    MenuButton back;
    MenuButton playerButton;
    List<MenuButton> driveSelector;
    int page;
    int itemsPerPage;
    Ability hoveredAbility;
    int hoveredIndex;
    Ability.AbilityType hoveredType;
    MenuScrollBar scrollBar;
    final ResourceLocation texture;
    int scrollTop;
    int scrollBot;

    public MenuAbilitiesScreen() {
        super("gui.menu.main.button.abilities", new Color(0, 0, 255));
        this.playerData = ModCapabilities.getPlayer((Player)this.f_96541_.f_91074_);
        this.abilities = new ArrayList<MenuAbilitiesButton>();
        this.driveSelector = new ArrayList<MenuButton>();
        this.page = 0;
        this.texture = new ResourceLocation("kingdomkeys", "textures/gui/menu/menu_button.png");
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.scrollBar.m_6050_(mouseX, mouseY, delta);
        return false;
    }

    protected void action(String string) {
        switch (string) {
            case "back": {
                GuiHelper.openMenu();
                break;
            }
            default: {
                this.form = string;
                this.m_7856_();
            }
        }
        this.updateButtons();
    }

    private void action(Ability ability, int index) {
        String abilityName = ability.getRegistryName().toString();
        int apCost = ((Ability)ModAbilities.registry.get().getValue(new ResourceLocation(abilityName))).getAPCost();
        if (!this.playerData.isAbilityEquipped(abilityName, index) && Utils.getConsumedAP(this.playerData) + apCost > this.playerData.getMaxAP(true)) {
            return;
        }
        boolean cancelled = this.playerData.isAbilityEquipped(abilityName, index) ? MinecraftForge.EVENT_BUS.post((Event)new AbilityEvent.Unequip((Ability)ModAbilities.registry.get().getValue(new ResourceLocation(abilityName)), index, (Player)Minecraft.m_91087_().f_91074_, true)) : MinecraftForge.EVENT_BUS.post((Event)new AbilityEvent.Equip((Ability)ModAbilities.registry.get().getValue(new ResourceLocation(abilityName)), index, (Player)Minecraft.m_91087_().f_91074_, true));
        if (!cancelled) {
            this.playerData.equipAbilityToggle(abilityName, index);
            PacketHandler.sendToServer(new CSSetEquippedAbilityPacket(abilityName, index));
        }
        this.updateButtons();
    }

    private void updateButtons() {
        for (MenuAbilitiesButton button : this.abilities) {
            button.f_93623_ = true;
        }
        this.playerButton.f_93623_ = !this.form.equals(DriveForm.NONE.toString());
        for (MenuButton menuButton : this.driveSelector) {
            menuButton.f_93623_ = !this.form.equals(menuButton.getData()) && this.playerData.getDriveFormMap().containsKey(menuButton.getData());
            menuButton.setSelected(!menuButton.f_93623_);
        }
    }

    @Override
    public void m_7856_() {
        this.f_96543_ = this.f_96543_;
        this.f_96544_ = this.f_96544_;
        super.m_7856_();
        this.f_169369_.clear();
        this.m_6702_().clear();
        this.abilities.clear();
        float boxPosX = (float)this.f_96543_ * 0.2f;
        float boxWidth = (float)this.f_96543_ * 0.5f;
        this.box = new MenuBox((int)boxPosX, (int)this.topBarHeight, (int)boxWidth, (int)this.middleHeight, new Color(4, 4, 68));
        int buttonPosX = (int)(boxPosX * 1.3f);
        int buttonPosY = (int)this.topBarHeight + 5;
        int buttonWidth = (int)(boxWidth * 0.46f);
        this.scrollTop = (int)this.topBarHeight;
        this.scrollBot = (int)((float)this.scrollTop + this.middleHeight);
        this.abilitiesMap = Utils.getSortedAbilities(this.playerData.getAbilityMap());
        if (this.form.equals(DriveForm.NONE.toString())) {
            List<String> abilitiesList;
            int i = 0;
            for (i = 0; i < this.abilitiesMap.size(); ++i) {
                String abilityName = (String)this.abilitiesMap.keySet().toArray()[i];
                Ability ability = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(abilityName));
                int n = this.abilitiesMap.get(abilityName)[0];
                if (n == 0 || ability.getType() == Ability.AbilityType.GROWTH) {
                    this.abilities.add(new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, abilityName, ability.getType(), e -> this.action((Ability)((Object)ability), 0)));
                } else {
                    int j = 0;
                    while (j < n) {
                        int finalJ = j++;
                        this.abilities.add(new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, abilityName, finalJ, ability.getType(), e -> this.action((Ability)((Object)ability), finalJ)));
                    }
                }
                this.abilities.get((int)i).f_93624_ = false;
            }
            if (this.playerData.getAlignment() == Utils.OrgMember.NONE) {
                if (!ItemStack.m_41728_((ItemStack)this.playerData.getEquippedKeychain(DriveForm.NONE), (ItemStack)ItemStack.f_41583_)) {
                    abilitiesList = Utils.getKeybladeAbilitiesAtLevel(this.playerData.getEquippedKeychain(DriveForm.NONE).m_41720_(), ((IKeychain)this.playerData.getEquippedKeychain(DriveForm.NONE).m_41720_()).toSummon().getKeybladeLevel(this.playerData.getEquippedKeychain(DriveForm.NONE)));
                    for (String string : abilitiesList) {
                        Ability ability = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(string));
                        if (ability == null) continue;
                        MenuAbilitiesButton aa = new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, ability.getRegistryName().toString(), Ability.AbilityType.WEAPON, e -> {});
                        this.abilities.add(aa);
                        aa.f_93624_ = false;
                    }
                }
            } else if (!ItemStack.m_41728_((ItemStack)this.playerData.getEquippedWeapon(), (ItemStack)ItemStack.f_41583_)) {
                abilitiesList = this.playerData.getAlignment() == Utils.OrgMember.ROXAS ? Utils.getKeybladeAbilitiesAtLevel(this.playerData.getEquippedWeapon().m_41720_(), 0) : Utils.getOrgWeaponAbilities(this.playerData.getEquippedWeapon().m_41720_());
                for (String string : abilitiesList) {
                    Ability ability = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(string));
                    if (ability == null) continue;
                    MenuAbilitiesButton aa = new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, ability.getRegistryName().toString(), Ability.AbilityType.WEAPON, e -> {});
                    this.abilities.add(aa);
                    aa.f_93624_ = false;
                    if (!this.playerData.getAbilityMap().containsKey("kingdomkeys:ability_synch_blade") || this.playerData.getAbilityMap().get("kingdomkeys:ability_synch_blade")[1] <= 0) continue;
                    MenuAbilitiesButton aaa = new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, ability.getRegistryName().toString(), Ability.AbilityType.WEAPON, e -> {});
                    this.abilities.add(aaa);
                    aaa.f_93624_ = false;
                }
            }
            if (this.playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                if (this.playerData.getAbilityMap().containsKey("kingdomkeys:ability_synch_blade") && this.playerData.getAbilityMap().get("kingdomkeys:ability_synch_blade")[1] > 0 && !ItemStack.m_41728_((ItemStack)this.playerData.getEquippedKeychain(DriveForm.SYNCH_BLADE), (ItemStack)ItemStack.f_41583_)) {
                    abilitiesList = Utils.getKeybladeAbilitiesAtLevel(this.playerData.getEquippedKeychain(DriveForm.SYNCH_BLADE).m_41720_(), ((IKeychain)this.playerData.getEquippedKeychain(DriveForm.SYNCH_BLADE).m_41720_()).toSummon().getKeybladeLevel(this.playerData.getEquippedKeychain(DriveForm.SYNCH_BLADE)));
                    for (String string : abilitiesList) {
                        Ability ability = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(string));
                        if (ability == null) continue;
                        MenuAbilitiesButton aa = new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, ability.getRegistryName().toString(), Ability.AbilityType.WEAPON, e -> {});
                        this.abilities.add(aa);
                        aa.f_93624_ = false;
                    }
                }
            } else if (ModDriveForms.registry.get().containsKey(new ResourceLocation(this.playerData.getActiveDriveForm())) && ((DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(this.playerData.getActiveDriveForm()))).hasKeychain() && this.playerData.getDriveFormMap().containsKey(this.playerData.getActiveDriveForm()) && this.playerData.getEquippedKeychains().containsKey(new ResourceLocation(this.playerData.getActiveDriveForm())) && !ItemStack.m_41728_((ItemStack)this.playerData.getEquippedKeychain(new ResourceLocation(this.playerData.getActiveDriveForm())), (ItemStack)ItemStack.f_41583_)) {
                ItemStack itemStack = this.playerData.getEquippedKeychain(new ResourceLocation(this.playerData.getActiveDriveForm()));
                List<String> list = Utils.getKeybladeAbilitiesAtLevel(itemStack.m_41720_(), ((IKeychain)itemStack.m_41720_()).toSummon().getKeybladeLevel(itemStack));
                for (String a : list) {
                    Ability ability = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(a));
                    if (ability == null) continue;
                    aa = new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, ability.getRegistryName().toString(), Ability.AbilityType.WEAPON, e -> {});
                    this.abilities.add(aa);
                    aa.f_93624_ = false;
                }
            }
            abilitiesList = Utils.getAccessoriesAbilities(this.playerData);
            for (String string : abilitiesList) {
                Ability ability = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(string));
                if (ability == null) continue;
                MenuAbilitiesButton aa = new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, ability.getRegistryName().toString(), Ability.AbilityType.ACCESSORY, e -> {});
                this.abilities.add(aa);
                aa.f_93624_ = false;
            }
        } else {
            ItemStack itemStack;
            MenuAbilitiesButton aa;
            DriveForm driveForm = (DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(this.form));
            if (driveForm.getBaseGrowthAbilities()) {
                for (int i = 0; i < this.abilitiesMap.size(); ++i) {
                    String string = (String)this.abilitiesMap.keySet().toArray()[i];
                    Ability ability = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(string));
                    int level = this.abilitiesMap.get(string)[0];
                    if (level != 0 && ability.getType() != Ability.AbilityType.GROWTH) continue;
                    aa = new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, string, ability.getType(), e -> {});
                    this.abilities.add(aa);
                    aa.f_93624_ = false;
                    aa.isVisual = true;
                }
            } else if (driveForm.getDriveFormData().getDFLevelUpAbilities() != null) {
                String growth = driveForm.getDFAbilityForLevel(1);
                Ability ability = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(growth));
                if (ability != null) {
                    MenuAbilitiesButton menuAbilitiesButton = new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, growth, ability.getType(), e -> {});
                    this.abilities.add(menuAbilitiesButton);
                    menuAbilitiesButton.f_93624_ = false;
                    menuAbilitiesButton.isVisual = true;
                }
            }
            if (driveForm.getDriveFormData().getAbilities() != null) {
                for (String string : driveForm.getDriveFormData().getAbilities()) {
                    Ability ability = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(string));
                    if (ability == null) continue;
                    MenuAbilitiesButton aa3 = new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, ability.getRegistryName().toString(), ability.getType(), e -> {});
                    this.abilities.add(aa3);
                    aa3.f_93624_ = false;
                    aa3.isVisual = true;
                }
            }
            if (!ItemStack.m_41728_((ItemStack)this.playerData.getEquippedKeychain(DriveForm.NONE), (ItemStack)ItemStack.f_41583_)) {
                List<String> abilitiesList = Utils.getKeybladeAbilitiesAtLevel(this.playerData.getEquippedKeychain(DriveForm.NONE).m_41720_(), ((IKeychain)this.playerData.getEquippedKeychain(DriveForm.NONE).m_41720_()).toSummon().getKeybladeLevel(this.playerData.getEquippedKeychain(DriveForm.NONE)));
                for (String string : abilitiesList) {
                    Ability ability2 = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(string));
                    if (ability2 == null) continue;
                    aa = new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, ability2.getRegistryName().toString(), Ability.AbilityType.WEAPON, e -> {});
                    this.abilities.add(aa);
                    aa.f_93624_ = false;
                }
            }
            if (ModDriveForms.registry.get().containsKey(new ResourceLocation(this.form)) && ((DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(this.form))).hasKeychain() && this.playerData.getDriveFormMap().containsKey(this.form) && this.playerData.getEquippedKeychains().containsKey(new ResourceLocation(this.form)) && !ItemStack.m_41728_((ItemStack)(itemStack = this.playerData.getEquippedKeychain(new ResourceLocation(this.form))), (ItemStack)ItemStack.f_41583_)) {
                List<String> list = Utils.getKeybladeAbilitiesAtLevel(itemStack.m_41720_(), ((IKeychain)itemStack.m_41720_()).toSummon().getKeybladeLevel(itemStack));
                for (String a : list) {
                    Ability ability3 = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(a));
                    if (ability3 == null) continue;
                    aa = new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, ability3.getRegistryName().toString(), Ability.AbilityType.WEAPON, e -> {});
                    this.abilities.add(aa);
                    aa.f_93624_ = false;
                }
            }
        }
        this.abilities.forEach(x$0 -> {
            MenuAbilitiesButton cfr_ignored_0 = (MenuAbilitiesButton)this.m_7787_((GuiEventListener)x$0);
        });
        this.itemsPerPage = (int)(this.middleHeight / 19.0f);
        this.playerButton = new MenuButton((int)this.buttonPosX, this.buttonPosY, (int)this.buttonWidth, this.f_96541_.f_91074_.m_5446_().getString(), MenuButton.ButtonType.BUTTON, b -> this.action(DriveForm.NONE.toString()));
        this.m_142416_((GuiEventListener)this.playerButton);
        ArrayList<String> forms = new ArrayList<String>(Utils.getSortedDriveForms(this.playerData.getDriveFormMap(), this.playerData.getVisibleDriveForms()).keySet());
        forms.remove(DriveForm.NONE.toString());
        forms.remove(DriveForm.SYNCH_BLADE.toString());
        forms.remove("kingdomkeys:form_anti");
        int k = 0;
        for (k = 0; k < forms.size(); ++k) {
            String string = (String)forms.get(k);
            String string2 = ((DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(string))).getTranslationKey();
            MenuButton b2 = new MenuButton((int)this.buttonPosX + 10, this.buttonPosY + (1 + k) * 18, (int)this.buttonWidth - 10, Utils.translateToLocal(string2, new Object[0]), MenuButton.ButtonType.SUBBUTTON, e -> this.action(formName));
            b2.setData(string);
            this.driveSelector.add(b2);
            this.m_142416_((GuiEventListener)b2);
        }
        this.back = new MenuButton((int)this.buttonPosX, this.buttonPosY + (1 + k) * 18, (int)this.buttonWidth, Component.m_237115_((String)"gui.menu.back").getString(), MenuButton.ButtonType.BUTTON, b -> this.action("back"));
        this.m_142416_((GuiEventListener)this.back);
        this.scrollBar = new MenuScrollBar((int)(boxPosX + boxWidth - 17.0f), this.scrollTop, this.scrollBot, (int)this.middleHeight, 0);
        this.m_142416_((GuiEventListener)this.scrollBar);
        this.updateButtons();
    }

    @Override
    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.box.m_87963_(gui, mouseX, mouseY, partialTicks);
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.drawAP(gui);
        for (int i = 0; i < this.abilities.size(); ++i) {
            if (this.abilities.get(i) == null) continue;
            this.abilities.get((int)i).f_93624_ = true;
            this.abilities.get((int)i).f_93623_ = false;
            this.abilities.get(i).m_253211_((int)this.topBarHeight + i * 19 + 2);
        }
        if (this.abilities.isEmpty()) {
            return;
        }
        int listHeight = this.abilities.get(this.abilities.size() - 1).m_252907_() + 20 - this.abilities.get(0).m_252907_() + 3;
        this.scrollBar.setContentHeight(listHeight);
        gui.m_280588_(0, (int)this.topBarHeight, this.f_96543_, (int)(this.topBarHeight + this.middleHeight));
        for (int i = 0; i < this.abilities.size(); ++i) {
            if (this.abilities.get(i) == null) continue;
            this.abilities.get(i).m_253211_((int)((float)this.abilities.get(i).m_252907_() - this.scrollBar.scrollOffset));
            if (this.abilities.get(i).m_252907_() >= this.scrollBot || this.abilities.get(i).m_252907_() < this.scrollTop - 20) continue;
            this.abilities.get((int)i).f_93623_ = true;
            String abilityName = this.abilities.get(i).getText();
            Ability ability = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(abilityName));
            if (ability.getAPCost() > this.playerData.getMaxAP(true) - Utils.getConsumedAP(this.playerData)) {
                this.abilities.get((int)i).f_93623_ = this.abilities.get((int)i).equipped;
            }
            if (this.abilities.get((int)i).abilityType == Ability.AbilityType.WEAPON || this.abilities.get((int)i).abilityType == Ability.AbilityType.ACCESSORY || this.form.equals(DriveForm.NONE.toString()) && this.playerData.isAbilityEquipped(this.abilities.get(i).getText(), this.abilitiesMap.get(this.abilities.get(i).getText())[0])) {
                this.abilities.get((int)i).f_93623_ = true;
            }
            this.abilities.get(i).m_88315_(gui, mouseX, mouseY, partialTicks);
        }
        gui.m_280618_();
        this.playerButton.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.back.m_88315_(gui, mouseX, mouseY, partialTicks);
        if (this.hoveredAbility != null) {
            this.renderSelectedData(gui, mouseX, mouseY, partialTicks);
        }
    }

    protected void renderSelectedData(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        ClientUtils.drawSplitString(gui, Component.m_237115_((String)this.hoveredAbility.getTranslationKey().replace(".name", ".desc")).getString(), (int)tooltipPosX, (int)tooltipPosY, (int)((float)this.f_96543_ * 0.6f), 65535);
    }

    private void drawAP(GuiGraphics gui) {
        int j;
        int percent;
        int requiredAP;
        int j2;
        PoseStack matrixStack = gui.m_280168_();
        int consumedAP = Utils.getConsumedAP(this.playerData);
        int maxAP = this.playerData.getMaxAP(true);
        this.hoveredAbility = null;
        for (int i = 0; i < this.abilities.size(); ++i) {
            String abilityName = this.abilities.get(i).getText();
            Ability ability = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(abilityName));
            Object lvl = "";
            if (ability.getType() == Ability.AbilityType.GROWTH) {
                DriveForm df = (DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(this.playerData.getActiveDriveForm()));
                int level = this.form.equals(DriveForm.NONE.toString()) || df.getBaseGrowthAbilities() ? this.playerData.getEquippedAbilityLevel(abilityName)[0] : this.playerData.getEquippedAbilityLevel(abilityName)[0] + 1;
                lvl = (String)lvl + "_" + level;
            }
            abilityName = ability.getTranslationKey();
            String text = Utils.translateToLocal(new StringBuilder(abilityName).insert(abilityName.lastIndexOf(46), (String)lvl).toString(), new Object[0]);
            if (!(this.abilities.get(i) instanceof MenuAbilitiesButton)) continue;
            MenuAbilitiesButton button = this.abilities.get(i);
            button.m_93666_((Component)Component.m_237115_((String)text));
            button.setAP(ability.getAPCost());
            if (!button.m_274382_()) continue;
            this.hoveredAbility = ability;
            this.hoveredIndex = button.index;
            this.hoveredType = button.abilityType;
        }
        int screenWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        int screenHeight = Minecraft.m_91087_().m_91268_().m_85446_();
        int barWidth = (int)((float)this.f_96543_ * 0.2f);
        int posX = screenWidth - barWidth;
        int posY = screenHeight - 100;
        float scale = 1.0f;
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)(posX - 2) * scale - 20.0f, (float)posY * scale - 10.0f, 0.0f);
        matrixStack.m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.m_280218_(this.texture, 0, 0, 143, 67, 7, 25);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (j2 = 0; j2 < barWidth; ++j2) {
            gui.m_280218_(this.texture, 7 + j2, 0, 151, 67, 1, 25);
        }
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.m_280218_(this.texture, 7 + barWidth, 0, 153, 67, 7, 25);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (j2 = 0; j2 < barWidth; ++j2) {
            gui.m_280218_(this.texture, j2 + 7, 17, 161, 67, 1, 25);
        }
        matrixStack.m_85849_();
        int n = requiredAP = this.hoveredAbility != null ? this.hoveredAbility.getAPCost() : 0;
        if (this.hoveredType != Ability.AbilityType.WEAPON && this.hoveredType != Ability.AbilityType.ACCESSORY) {
            if (this.hoveredAbility != null && this.playerData.isAbilityEquipped(this.hoveredAbility.getRegistryName().toString(), this.hoveredIndex)) {
                requiredAP *= -1;
                matrixStack.m_85836_();
                percent = consumedAP * barWidth / maxAP;
                matrixStack.m_85836_();
                for (j = 0; j < percent; ++j) {
                    gui.m_280218_(this.texture, j + 7, 17, 165, 67, 1, 5);
                }
                matrixStack.m_85849_();
                matrixStack.m_85849_();
            } else if (consumedAP + requiredAP <= this.playerData.getMaxAP(true)) {
                matrixStack.m_85836_();
                percent = (consumedAP + requiredAP) * barWidth / maxAP;
                matrixStack.m_85836_();
                for (j = 0; j < percent; ++j) {
                    gui.m_280218_(this.texture, j + 7, 17, 167, 67, 1, 5);
                }
                matrixStack.m_85849_();
                matrixStack.m_85849_();
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.m_85836_();
        percent = consumedAP * barWidth / maxAP;
        if (requiredAP < 0) {
            percent = (consumedAP + requiredAP) * barWidth / maxAP;
        }
        for (j = 0; j < percent; ++j) {
            gui.m_280218_(this.texture, j + 7, 17, 163, 67, 1, 5);
        }
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85841_(scale * 1.3f, scale * 1.1f, 0.0f);
        gui.m_280488_(this.f_96541_.f_91062_, Utils.translateToLocal("gui.menu.status.ap", new Object[0]) + ": " + consumedAP + "/" + maxAP, 16, 5, 0xFFFFFF);
        matrixStack.m_85849_();
        matrixStack.m_85849_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        this.scrollBar.m_6375_(mouseX, mouseY, mouseButton);
        if (mouseButton == 1) {
            GuiHelper.openMenu();
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        this.scrollBar.m_6348_(pMouseX, pMouseY, pButton);
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        this.scrollBar.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }
}

