/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.menu.customize;

import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBox;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuScrollBar;
import online.kingdomkeys.kingdomkeys.client.gui.menu.customize.MenuCustomizeScreen;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.CommandMenuGui;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MenuCustomizeMagicScreen
extends MenuBackground {
    MenuBox boxLeft;
    MenuBox boxRight;
    LinkedHashMap<ResourceLocation, MagicButton> displayedMagic;
    LinkedHashMap<ResourceLocation, MagicButton> allMagic;
    MenuButton back;
    MenuScrollBar leftScroll;
    MenuScrollBar rightScroll;
    int buttonsX = 0;
    float boxLeftPosX;
    float boxRightPosX;
    float topBarHeight;
    float boxWidth;
    int rightListHeight = 0;
    int leftListHeight = 0;

    public MenuCustomizeMagicScreen(LinkedHashMap<String, int[]> knownMagic) {
        super("gui.menu.customize.magic", new Color(0, 0, 255));
        this.drawPlayerInfo = false;
        this.displayedMagic = new LinkedHashMap();
        this.allMagic = new LinkedHashMap();
        knownMagic.forEach((s, ints) -> {
            if (ModMagic.registry.get().containsKey(new ResourceLocation(s))) {
                this.allMagic.put(new ResourceLocation(s), new MagicButton(new MenuButton(0, 0, 100, ((Magic)ModMagic.registry.get().getValue(new ResourceLocation(s))).getTranslationKey(ints[0]), MenuButton.ButtonType.BUTTON, pButton -> this.magicAction(new ResourceLocation(s))), ints[0], false));
            }
        });
        ModConfigs.magicDisplayedInCommandMenu.forEach(magic -> {
            ResourceLocation magicKey = new ResourceLocation(magic);
            if (this.allMagic.containsKey(magicKey)) {
                MagicButton magicButton = this.allMagic.get(magicKey);
                magicButton.setDisplay(true);
                this.displayedMagic.put(magicKey, magicButton);
                this.allMagic.remove(magicKey);
            }
        });
    }

    protected void magicAction(ResourceLocation magic) {
        MagicButton magicButton = this.allMagic.containsKey(magic) ? this.allMagic.get(magic) : this.displayedMagic.get(magic);
        if (!magicButton.display) {
            magicButton.setDisplay(true);
            this.displayedMagic.put(magic, magicButton);
            this.allMagic.remove(magic);
        } else {
            magicButton.setDisplay(false);
            this.allMagic.put(magic, magicButton);
            this.displayedMagic.remove(magic);
        }
        this.updateMagicButtons(false);
        ModConfigs.setMagicDisplayedInCommandMenu(this.displayedMagic.keySet().stream().map(ResourceLocation::toString).toList());
        if (this.displayedMagic.isEmpty() && CommandMenuGui.INSTANCE.currentSubmenu.equals((Object)CommandMenuGui.INSTANCE.magic)) {
            CommandMenuGui.INSTANCE.changeSubmenu(CommandMenuGui.INSTANCE.root, true);
        }
    }

    protected void action(String string) {
        switch (string) {
            case "back": {
                Minecraft.m_91087_().m_91152_((Screen)new MenuCustomizeScreen());
            }
        }
    }

    @Override
    public void m_7856_() {
        this.boxLeftPosX = (float)this.f_96543_ * 0.25f;
        this.boxRightPosX = (float)this.f_96543_ * 0.5f;
        this.topBarHeight = (float)this.f_96544_ * 0.17f;
        this.boxWidth = (float)this.f_96543_ * 0.25f;
        float middleHeight = (float)this.f_96544_ * 0.6f;
        this.boxLeft = new MenuBox((int)this.boxLeftPosX, (int)this.topBarHeight, (int)this.boxWidth, (int)middleHeight, new Color(4, 4, 68));
        this.boxRight = new MenuBox((int)this.boxRightPosX, (int)this.topBarHeight, (int)this.boxWidth, (int)middleHeight, new Color(4, 4, 68));
        this.buttonsX = this.boxLeft.m_252754_() + 10;
        this.buttonPosY = (int)(this.topBarHeight + 5.0f);
        super.m_7856_();
        int n = (int)(this.boxRightPosX + this.boxWidth - 14.0f);
        int n2 = (int)this.topBarHeight;
        int n3 = (int)(this.topBarHeight + middleHeight);
        int n4 = (int)middleHeight - 3;
        Objects.requireNonNull(this.f_96547_);
        this.rightScroll = new MenuScrollBar(n, n2, n3, n4 - 9, 0);
        this.m_142416_((GuiEventListener)this.rightScroll);
        int n5 = (int)(this.boxLeftPosX + this.boxWidth - 14.0f);
        int n6 = (int)this.topBarHeight;
        int n7 = (int)(this.topBarHeight + middleHeight);
        int n8 = (int)middleHeight - 3;
        Objects.requireNonNull(this.f_96547_);
        this.leftScroll = new MenuScrollBar(n5, n6, n7, n8 - 9, 0);
        this.m_142416_((GuiEventListener)this.leftScroll);
        this.updateMagicButtons(true);
        this.back = new MenuButton((int)this.buttonPosX, this.buttonPosY, (int)this.buttonWidth, Utils.translateToLocal("gui.menu.back", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("back"));
        this.m_142416_((GuiEventListener)this.back);
    }

    public void updateMagicButtons(boolean init) {
        MenuButton button;
        ResourceLocation key;
        int i;
        this.f_169369_.clear();
        this.m_6702_().clear();
        for (i = 0; i < this.displayedMagic.size(); ++i) {
            key = (ResourceLocation)this.displayedMagic.keySet().stream().toList().get(i);
            button = this.displayedMagic.get((Object)key).button;
            button.m_252865_((int)this.boxRightPosX);
            button.m_253211_((int)(this.topBarHeight - this.rightScroll.scrollOffset + 15.0f + (float)(i * 20)));
            button.m_93674_((int)this.boxWidth - 22 - 14);
            this.m_142416_((GuiEventListener)button);
        }
        for (i = 0; i < this.allMagic.size(); ++i) {
            key = (ResourceLocation)this.allMagic.keySet().stream().toList().get(i);
            button = this.allMagic.get((Object)key).button;
            button.m_252865_((int)this.boxLeftPosX);
            button.m_253211_((int)(this.topBarHeight - this.leftScroll.scrollOffset + 15.0f + (float)(i * 20)));
            button.m_93674_((int)this.boxWidth - 22 - 14);
            this.m_142416_((GuiEventListener)button);
        }
        if (!init) {
            this.m_142416_((GuiEventListener)this.rightScroll);
            this.m_142416_((GuiEventListener)this.leftScroll);
            this.m_142416_((GuiEventListener)this.back);
        }
        if (!this.displayedMagic.isEmpty()) {
            this.rightListHeight = this.displayedMagic.get((Object)((ResourceLocation)this.displayedMagic.keySet().toArray()[this.displayedMagic.size() - 1])).button.m_252907_() + 20 - this.displayedMagic.get((Object)((ResourceLocation)this.displayedMagic.keySet().toArray()[0])).button.m_252907_() + 5;
        }
        if (!this.allMagic.isEmpty()) {
            this.leftListHeight = this.allMagic.get((Object)((ResourceLocation)this.allMagic.keySet().toArray()[this.allMagic.size() - 1])).button.m_252907_() + 20 - this.allMagic.get((Object)((ResourceLocation)this.allMagic.keySet().toArray()[0])).button.m_252907_() + 5;
        }
        this.rightScroll.setContentHeight(this.rightListHeight);
        this.leftScroll.setContentHeight(this.leftListHeight);
    }

    @Override
    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.drawMenuBackground(gui, mouseX, mouseY, partialTicks);
        this.boxLeft.m_87963_(gui, mouseX, mouseY, partialTicks);
        this.boxRight.m_87963_(gui, mouseX, mouseY, partialTicks);
        this.updateMagicButtons(false);
        this.drawSeparately = true;
        gui.m_280137_(Minecraft.m_91087_().f_91062_, Utils.translateToLocal("gui.menu.customize.magic.hidden", new Object[0]), (int)(this.boxLeftPosX + this.boxWidth / 2.0f), (int)this.topBarHeight + 3, 0xFFFFFF);
        gui.m_280137_(Minecraft.m_91087_().f_91062_, Utils.translateToLocal("gui.menu.customize.magic.active", new Object[0]), (int)(this.boxRightPosX + this.boxWidth / 2.0f), (int)this.topBarHeight + 3, 0xFFFFFF);
        int n = (int)this.boxLeftPosX;
        int n2 = (int)this.topBarHeight + 3;
        Objects.requireNonNull(this.f_96547_);
        gui.m_280588_(n, n2 + 9, this.boxLeft.m_5711_() * 4, (int)(this.topBarHeight + this.middleHeight));
        for (Renderable renderable : this.f_169369_) {
            Button button;
            if (!(renderable instanceof Button) || !((float)(button = (Button)renderable).m_252754_() >= this.boxLeftPosX - 1.0f)) continue;
            renderable.m_88315_(gui, mouseX, mouseY, partialTicks);
        }
        gui.m_280618_();
        this.back.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.rightScroll.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.leftScroll.m_88315_(gui, mouseX, mouseY, partialTicks);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        this.rightScroll.m_6375_(pMouseX, pMouseY, pButton);
        this.leftScroll.m_6375_(pMouseX, pMouseY, pButton);
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        this.rightScroll.m_6348_(pMouseX, pMouseY, pButton);
        this.leftScroll.m_6348_(pMouseX, pMouseY, pButton);
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        this.rightScroll.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
        this.leftScroll.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (pMouseX >= (double)((float)Minecraft.m_91087_().f_91080_.f_96543_ / 2.0f)) {
            this.rightScroll.m_6050_(pMouseX, pMouseY, pDelta);
        } else {
            this.leftScroll.m_6050_(pMouseX, pMouseY, pDelta);
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    static class MagicButton {
        MenuButton button;
        int level;
        boolean display;

        public MagicButton(MenuButton button, int level, boolean display) {
            this.button = button;
            this.level = level;
            this.display = display;
        }

        public MenuButton getButton() {
            return this.button;
        }

        public void setButton(MenuButton button) {
            this.button = button;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public boolean isDisplay() {
            return this.display;
        }

        public void setDisplay(boolean display) {
            this.display = display;
        }
    }
}

