/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.gui.elements.CommandMenuItem;
import online.kingdomkeys.kingdomkeys.client.gui.elements.CommandMenuSubMenu;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.OverlayBase;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.handler.EntityEvents;
import online.kingdomkeys.kingdomkeys.handler.InputHandler;
import online.kingdomkeys.kingdomkeys.item.KKPotionItem;
import online.kingdomkeys.kingdomkeys.item.organization.ArrowgunItem;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.lib.PortalData;
import online.kingdomkeys.kingdomkeys.limit.Limit;
import online.kingdomkeys.kingdomkeys.limit.ModLimits;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSSpawnOrgPortalPacket;
import online.kingdomkeys.kingdomkeys.network.cts.CSSummonKeyblade;
import online.kingdomkeys.kingdomkeys.network.cts.CSUseDriveFormPacket;
import online.kingdomkeys.kingdomkeys.network.cts.CSUseItemPacket;
import online.kingdomkeys.kingdomkeys.network.cts.CSUseLimitPacket;
import online.kingdomkeys.kingdomkeys.network.cts.CSUseMagicPacket;
import online.kingdomkeys.kingdomkeys.reactioncommands.ModReactionCommands;
import online.kingdomkeys.kingdomkeys.reactioncommands.ReactionCommand;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class CommandMenuGui
extends OverlayBase {
    public static final CommandMenuGui INSTANCE = new CommandMenuGui();
    public static final int TOP = 5;
    public static final int ATTACK = 4;
    public static final int MAGIC = 3;
    public static final int ITEMS = 2;
    public static final int DRIVE = 1;
    public static Map<ResourceLocation, CommandMenuSubMenu> commandMenuElements;
    int TOP_WIDTH = 70;
    int TOP_HEIGHT = 15;
    public static int reactionSelected;
    public final ResourceLocation root = new ResourceLocation("kingdomkeys", "root");
    public final ResourceLocation attack = new ResourceLocation("kingdomkeys", "attack");
    public final ResourceLocation magic = new ResourceLocation("kingdomkeys", "magic");
    public final ResourceLocation items = new ResourceLocation("kingdomkeys", "items");
    public final ResourceLocation drive = new ResourceLocation("kingdomkeys", "drive");
    public final ResourceLocation portals = new ResourceLocation("kingdomkeys", "portals");
    public final ResourceLocation target = new ResourceLocation("kingdomkeys", "target");
    public final ResourceLocation limit = new ResourceLocation("kingdomkeys", "limit");
    public final ResourceLocation revert = new ResourceLocation("kingdomkeys", "revert");
    public ResourceLocation currentSubmenu;

    public void initCommandMenu() {
        this.currentSubmenu = this.root;
        commandMenuElements = new HashMap<ResourceLocation, CommandMenuSubMenu>();
        CommandMenuSubMenu rootSubmenu = new CommandMenuSubMenu.Builder(this.root, (Component)Component.m_237115_((String)"gui.commandmenu.command")).position(ModConfigs.cmXPos, Minecraft.m_91087_().m_91268_().m_85446_()).openByDefault().changesColour().colour(new Color(10, 51, 255)).onUpdate((subMenu, guiGraphics) -> subMenu.updatePosition(ModConfigs.cmXPos, Minecraft.m_91087_().m_91268_().m_85446_())).withChildren(new CommandMenuItem.Builder(this.attack, (Component)Component.m_237115_((String)"gui.commandmenu.attack"), null).onUpdate((item, guiGraphics) -> this.updateRootItem(item, null, guiGraphics)).iconUV(170, 18), new CommandMenuItem.Builder(this.portals, (Component)Component.m_237115_((String)"gui.commandmenu.portal"), this.opensSubmenu(this.portals, true)).invisibleByDefault().onUpdate((item, guiGraphics) -> this.updateRootItem(item, this.portals, guiGraphics)).iconUV(180, 18), new CommandMenuItem.Builder(this.magic, (Component)Component.m_237115_((String)"gui.commandmenu.magic"), this.opensSubmenu(this.magic, false)).onUpdate((item, guiGraphics) -> this.updateRootItem(item, this.magic, guiGraphics)).iconUV(160, 18), new CommandMenuItem.Builder(this.items, (Component)Component.m_237115_((String)"gui.commandmenu.items"), this.opensSubmenu(this.items, true)).onUpdate((item, guiGraphics) -> this.updateRootItem(item, this.items, guiGraphics)).iconUV(150, 18), new CommandMenuItem.Builder(this.drive, (Component)Component.m_237115_((String)"gui.commandmenu.drive"), this.opensSubmenu(this.drive, false)).onUpdate((item, guiGraphics) -> this.updateRootItem(item, this.drive, guiGraphics)).iconUV(140, 18), new CommandMenuItem.Builder(this.revert, (Component)Component.m_237115_((String)"gui.commandmenu.revert"), item -> {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)this.minecraft.f_91074_);
            if (playerData.getActiveDriveForm().equals("kingdomkeys:form_anti") && !playerData.isAbilityEquipped("kingdomkeys:ability_dark_domination") && EntityEvents.isHostiles) {
                this.playErrorSound();
            } else {
                PacketHandler.sendToServer(new CSUseDriveFormPacket(DriveForm.NONE.toString()));
                this.playSound((SoundEvent)ModSounds.unsummon.get());
            }
        }).invisibleByDefault().onUpdate((item, guiGraphics) -> {
            if (item.isVisible() && ModCapabilities.getPlayer((Player)this.minecraft.f_91074_).getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                item.setVisible(false);
                item.getParent().getChild(this.drive).setVisible(true);
            }
        }).iconUV(140, 18), new CommandMenuItem.Builder(this.limit, (Component)Component.m_237115_((String)"gui.commandmenu.limit"), this.opensSubmenu(this.limit, false)).invisibleByDefault().onUpdate((item, guiGraphics) -> this.updateRootItem(item, this.limit, guiGraphics)).iconUV(140, 18)).build();
        CommandMenuSubMenu magicSubmenu = new CommandMenuSubMenu.Builder(this.magic, (Component)Component.m_237115_((String)"gui.commandmenu.magic.title")).colour(new Color(102, 0, 255)).onUpdate(this.updateMagic()).withChildren(this.createMagicFromRegistry()).autoResizes().buildWithParent(rootSubmenu);
        CommandMenuSubMenu itemsSubmenu = new CommandMenuSubMenu.Builder(this.items, (Component)Component.m_237115_((String)"gui.commandmenu.items.title")).colour(new Color(77, 255, 77)).onOpen(this::createItems).autoResizes().buildWithParent(rootSubmenu);
        CommandMenuSubMenu targetSubmenu = new CommandMenuSubMenu.Builder(this.target, (Component)Component.m_237115_((String)"gui.commandmenu.target")).colour(new Color(10, 51, 255)).onOpen(this::createTargets).autoResizes().build();
        CommandMenuSubMenu portalsSubmenu = new CommandMenuSubMenu.Builder(this.portals, (Component)Component.m_237115_((String)"gui.commandmenu.portal.title")).colour(new Color(204, 204, 204)).onOpen(this::createPortals).autoResizes().buildWithParent(rootSubmenu);
        CommandMenuSubMenu limitSubmenu = new CommandMenuSubMenu.Builder(this.limit, (Component)Component.m_237115_((String)"gui.commandmenu.limit.title")).colour(new Color(255, 255, 0)).onUpdate(this.updateLimits()).withChildren(this.createLimitsFromRegistry()).autoResizes().buildWithParent(rootSubmenu);
        CommandMenuSubMenu driveSubmenu = new CommandMenuSubMenu.Builder(this.drive, (Component)Component.m_237115_((String)"gui.commandmenu.drive.title")).colour(new Color(0, 255, 255)).onUpdate(this.updateDriveForms()).withChildren(this.createDriveFormsFromRegistry()).autoResizes().buildWithParent(rootSubmenu);
    }

    private CommandMenuGui() {
    }

    private CommandMenuItem.OnEnter opensSubmenu(ResourceLocation subMenu, boolean ignoreMemory) {
        return item -> {
            this.changeSubmenu(subMenu, ignoreMemory || !ModConfigs.cmCursorMemory);
            this.playInSound();
        };
    }

    public CommandMenuSubMenu.OnUpdate updateMagic() {
        return (subMenu, guiGraphics) -> {
            AtomicInteger i = new AtomicInteger(0);
            HashMap magicList = new HashMap();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)this.minecraft.f_91074_);
            ModConfigs.magicDisplayedInCommandMenu.stream().filter(m -> playerData.getMagicsMap().containsKey(m)).toList().forEach(s -> magicList.put(s, i.getAndIncrement()));
            subMenu.getChildren().forEach(item -> {
                item.setSorting(0.0);
                if (magicList.containsKey(item.getId().toString())) {
                    item.setSorting(((Integer)magicList.get(item.getId().toString())).intValue());
                    item.setMessage((Component)Component.m_237115_((String)((Magic)ModMagic.registry.get().getValue(item.getId())).getTranslationKey(playerData.getMagicLevel(item.getId()))));
                    item.setVisible(true);
                } else {
                    item.setVisible(false);
                }
            });
        };
    }

    public CommandMenuSubMenu.OnUpdate updateLimits() {
        return (subMenu, guiGraphics) -> {
            AtomicInteger i = new AtomicInteger(0);
            HashMap limits = new HashMap();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)this.minecraft.f_91074_);
            Utils.getSortedLimits(Utils.getPlayerLimitAttacks((Player)this.minecraft.f_91074_)).forEach(limit -> limits.put(limit.getRegistryName().toString(), i.getAndIncrement()));
            subMenu.getChildren().forEach(item -> {
                item.setSorting(0.0);
                if (limits.containsKey(item.getId().toString())) {
                    item.setSorting(((Integer)limits.get(item.getId().toString())).intValue());
                    item.setVisible(true);
                } else {
                    item.setVisible(false);
                }
            });
        };
    }

    public CommandMenuSubMenu.OnUpdate updateDriveForms() {
        return (subMenu, guiGraphics) -> {
            AtomicInteger i = new AtomicInteger(0);
            HashMap formList = new HashMap();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)this.minecraft.f_91074_);
            playerData.getDriveFormMap().forEach((s, ints) -> formList.put(s, ((DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(s))).getOrder()));
            subMenu.getChildren().forEach(item -> {
                item.setSorting(0.0);
                if (formList.containsKey(item.getId().toString())) {
                    item.setSorting(((Integer)formList.get(item.getId().toString())).intValue());
                    item.setVisible(true);
                } else {
                    item.setVisible(false);
                }
            });
        };
    }

    public CommandMenuItem.Builder[] createMagicFromRegistry() {
        ArrayList magic = new ArrayList();
        ModMagic.registry.get().forEach(magicRegistryObject -> magic.add(new CommandMenuItem.Builder(magicRegistryObject.getRegistryName(), (Component)Component.m_237115_((String)magicRegistryObject.getTranslationKey()), item -> {
            block4: {
                IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)this.minecraft.f_91074_);
                IWorldCapabilities worldData = ModCapabilities.getWorld((Level)this.minecraft.f_91073_);
                int[] mag = playerData.getMagicsMap().get(magicRegistryObject.getRegistryName().toString());
                double cost = magicRegistryObject.getCost(mag[0], (Player)this.minecraft.f_91074_);
                if (playerData.getMaxMP() == 0.0 || playerData.getRecharge() || cost > playerData.getMaxMP() && cost < 300.0) {
                    this.playErrorSound();
                    this.changeSubmenu(this.root, true);
                    return;
                }
                if (worldData.getPartyFromMember(this.minecraft.f_91074_.m_20148_()) != null && ((Magic)ModMagic.registry.get().getValue(magicRegistryObject.getRegistryName())).getHasToSelect()) {
                    if (this.currentSubmenu.equals((Object)this.target) && commandMenuElements.get(this.currentSubmenu).getSelected() != null) {
                        String target = commandMenuElements.get(this.currentSubmenu).getSelected().getId().m_135815_();
                        int level = playerData.getMagicLevel(magicRegistryObject.getRegistryName());
                        PacketHandler.sendToServer(new CSUseMagicPacket(magicRegistryObject.getRegistryName().toString(), target, level));
                        this.changeSubmenu(this.root, true);
                        break block4;
                    } else {
                        this.changeSubmenu(this.target, true);
                        this.playInSound();
                        return;
                    }
                }
                int level = playerData.getMagicLevel(magicRegistryObject.getRegistryName());
                PacketHandler.sendToServer(new CSUseMagicPacket(magicRegistryObject.getRegistryName().toString(), level, InputHandler.lockOn));
                this.changeSubmenu(this.root, true);
            }
            this.playSelectSound();
        }).onUpdate((item, guiGraphics) -> {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)this.minecraft.f_91074_);
            Magic magicInst = (Magic)ModMagic.registry.get().getValue(item.getId());
            if (playerData.getMP() > 0.0 && !playerData.getRecharge()) {
                item.setActive(true);
                item.setTextColour(Color.WHITE);
                if (playerData.getMP() <= magicInst.getCost(playerData.getMagicLevel(item.getId()), (Player)Minecraft.m_91087_().f_91074_)) {
                    item.setTextColour(Color.ORANGE);
                }
            } else {
                item.setTextColour(Color.WHITE);
                item.setActive(false);
            }
        }).iconUV(160, 18)));
        return magic.toArray(new CommandMenuItem.Builder[0]);
    }

    public CommandMenuItem.Builder[] createDriveFormsFromRegistry() {
        ArrayList forms = new ArrayList();
        ModDriveForms.registry.get().getEntries().stream().filter(driveFormRegistryObject -> ((DriveForm)driveFormRegistryObject.getValue()).displayInCommandMenu((Player)this.minecraft.f_91074_)).forEach(driveFormEntry -> {
            DriveForm driveFormRegistryObject = (DriveForm)driveFormEntry.getValue();
            forms.add(new CommandMenuItem.Builder(driveFormRegistryObject.getRegistryName(), (Component)Component.m_237115_((String)driveFormRegistryObject.getTranslationKey()), item -> {
                IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)this.minecraft.f_91074_);
                if (playerData.getDP() >= (double)driveFormRegistryObject.getDriveCost()) {
                    if (!this.antiFormCheck(playerData, driveFormRegistryObject)) {
                        PacketHandler.sendToServer(new CSUseDriveFormPacket(driveFormRegistryObject.getRegistryName().toString()));
                    }
                    this.changeSubmenu(this.root, true);
                    this.playInSound();
                } else {
                    this.playErrorSound();
                }
            }).onUpdate((item, guiGraphics) -> {
                IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)this.minecraft.f_91074_);
                DriveForm form = (DriveForm)ModDriveForms.registry.get().getValue(item.getId());
                if (playerData.getDP() >= (double)form.getDriveCost()) {
                    item.setActive(true);
                } else {
                    item.setActive(false);
                }
            }).iconUV(140, 18));
        });
        return forms.toArray(new CommandMenuItem.Builder[0]);
    }

    public CommandMenuItem.Builder[] createLimitsFromRegistry() {
        ArrayList limits = new ArrayList();
        ModLimits.registry.get().forEach(limitRegistryObject -> limits.add(new CommandMenuItem.Builder(limitRegistryObject.getRegistryName(), (Component)Component.m_237115_((String)limitRegistryObject.getTranslationKey()), item -> {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)this.minecraft.f_91074_);
            if (playerData.getDP() < (double)limitRegistryObject.getCost()) {
                this.playErrorSound();
            } else {
                if (InputHandler.lockOn != null) {
                    PacketHandler.sendToServer(new CSUseLimitPacket(InputHandler.lockOn, limitRegistryObject.getRegistryName()));
                } else {
                    PacketHandler.sendToServer(new CSUseLimitPacket(limitRegistryObject.getRegistryName()));
                }
                this.changeSubmenu(this.root, true);
                this.playInSound();
            }
        }).onUpdate((item, guiGraphics) -> {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)this.minecraft.f_91074_);
            Limit limit = (Limit)ModLimits.registry.get().getValue(item.getId());
            item.setMessage((Component)Component.m_237113_((String)(Component.m_237115_((String)limit.getTranslationKey()).getString() + ":  ")));
            if (playerData.getDP() >= (double)limit.getCost()) {
                item.setActive(true);
            } else {
                item.setActive(false);
            }
            if (item.getParent().isVisible()) {
                this.drawString(guiGraphics, this.font, String.valueOf(((Limit)ModLimits.registry.get().getValue(item.getId())).getCost() / 100), item.getX() + this.font.m_92895_(item.getMessage().getString()), item.getY() + 4, item.isActive() ? new Color(0, 255, 255).getRGB() : new Color(0, 255, 255).darker().darker().getRGB());
            }
        }).iconUV(140, 18)));
        return limits.toArray(new CommandMenuItem.Builder[0]);
    }

    public boolean isOrgMode() {
        return ModCapabilities.getPlayer((Player)this.minecraft.f_91074_).getAlignment() != Utils.OrgMember.NONE;
    }

    public void updateRootItem(CommandMenuItem item, ResourceLocation submenu, GuiGraphics guiGraphics) {
        ItemStack weapon;
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)this.minecraft.f_91074_);
        if (item.getId().equals((Object)this.portals) && this.isOrgMode() && item.getParent().getSelected().equals(item) && this.minecraft.f_91074_.m_21205_() != null && this.minecraft.f_91074_.m_21205_().m_41720_() instanceof ArrowgunItem && (weapon = this.minecraft.f_91074_.m_21205_()).m_41782_() && weapon.m_41783_().m_128441_("ammo")) {
            int ammo = weapon.m_41783_().m_128451_("ammo");
            this.drawString(guiGraphics, this.minecraft.f_91062_, "" + ammo, item.getX() + 8 + (int)((double)item.getParent().getWidth() * ((double)ModConfigs.cmXScale / 100.0)), item.getY() + 4, 0xFFFFFF);
        }
        if (item.getId().equals((Object)this.attack) || item.getId().equals((Object)this.drive)) {
            item.setVisible(!this.isOrgMode());
        } else if (item.getId().equals((Object)this.portals) || item.getId().equals((Object)this.limit)) {
            item.setVisible(this.isOrgMode());
        }
        if (submenu == null) {
            item.setActive(true);
            return;
        }
        if (item.getId().equals((Object)this.drive) && !playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
            item.setVisible(false);
            item.getParent().getChild(this.revert).setVisible(true);
        }
        if (commandMenuElements.containsKey(submenu)) {
            if (submenu.equals((Object)this.items)) {
                item.setActive(false);
                playerData.getEquippedItems().forEach((integer, stack) -> {
                    if (!stack.m_41619_()) {
                        item.setActive(true);
                    }
                });
                return;
            }
            if (submenu.equals((Object)this.portals)) {
                item.setActive(!ModCapabilities.getWorld((Level)this.minecraft.f_91073_).getAllPortalsFromOwnerID(this.minecraft.f_91074_.m_20148_()).isEmpty());
                return;
            }
            if (!commandMenuElements.get(submenu).getVisibleChildren().isEmpty()) {
                item.setActive(true);
                return;
            }
        }
        item.setActive(false);
    }

    public void createTargets(CommandMenuSubMenu subMenu) {
        subMenu.getChildren().clear();
        IWorldCapabilities worldData = ModCapabilities.getWorld((Level)this.minecraft.f_91073_);
        if (worldData.getPartyFromMember(this.minecraft.f_91074_.m_20148_()) != null) {
            subMenu.addChild(new CommandMenuItem.Builder(new ResourceLocation("kingdomkeys", this.minecraft.f_91074_.m_5446_().getString().toLowerCase()), (Component)Component.m_237115_((String)this.minecraft.f_91074_.m_5446_().getString()), item -> subMenu.getParent().getSelected().onEnter()).build(subMenu));
            List<Party.Member> targets = worldData.getPartyFromMember(this.minecraft.f_91074_.m_20148_()).getMembers();
            targets.stream().filter(member -> !member.getUsername().equals(this.minecraft.f_91074_.m_5446_().getString())).forEach(member -> subMenu.addChild(new CommandMenuItem.Builder(new ResourceLocation("kingdomkeys", member.getUsername().toLowerCase()), (Component)Component.m_237115_((String)member.getUsername()), item -> subMenu.getParent().getSelected().onEnter()).build(subMenu)));
        }
    }

    public void createPortals(CommandMenuSubMenu subMenu) {
        subMenu.getChildren().clear();
        IWorldCapabilities worldData = ModCapabilities.getWorld((Level)this.minecraft.f_91073_);
        worldData.getAllPortalsFromOwnerID(this.minecraft.f_91074_.m_20148_()).forEach(uuid -> {
            PortalData portalData = worldData.getPortalFromUUID((UUID)uuid);
            String rlUUID = uuid.toString().replaceAll("-", "_");
            subMenu.addChild(new CommandMenuItem.Builder(new ResourceLocation(rlUUID), (Component)Component.m_237115_((String)portalData.getName()), item -> {
                PortalData portal = worldData.getPortalFromUUID(UUID.fromString(item.getId().m_135815_().replaceAll("_", "-")));
                if (!portal.getPos().equals((Object)new BlockPos(0, 0, 0))) {
                    this.summonPortal(portal);
                } else {
                    this.minecraft.f_91074_.m_213846_((Component)Component.m_237115_((String)(String.valueOf(ChatFormatting.RED) + "You don't have any portal destinations")));
                }
                this.changeSubmenu(this.root, true);
                this.playInSound();
            }).iconUV(180, 18).build(subMenu));
        });
    }

    public void summonPortal(PortalData coords) {
        BlockPos destination = coords.getPos();
        if (this.minecraft.f_91074_.m_6144_()) {
            PacketHandler.sendToServer(new CSSpawnOrgPortalPacket(this.minecraft.f_91074_.m_20183_(), destination, coords.getDimID()));
        } else {
            HitResult rtr = InputHandler.getMouseOverExtended(100.0f);
            if (rtr != null) {
                EntityHitResult ertr;
                double distanceSq;
                double reachSq;
                if (rtr instanceof BlockHitResult) {
                    double reachSq2 = 10000.0;
                    BlockHitResult brtr = (BlockHitResult)rtr;
                    double distanceSq2 = this.minecraft.f_91074_.m_20275_((double)brtr.m_82425_().m_123341_(), (double)brtr.m_82425_().m_123342_(), (double)brtr.m_82425_().m_123343_());
                    if (reachSq2 >= distanceSq2) {
                        PacketHandler.sendToServer(new CSSpawnOrgPortalPacket(brtr.m_82425_().m_7494_(), destination, coords.getDimID()));
                    }
                } else if (rtr instanceof EntityHitResult && (reachSq = 10000.0) >= (distanceSq = this.minecraft.f_91074_.m_20275_((ertr = (EntityHitResult)rtr).m_82443_().m_20185_(), ertr.m_82443_().m_20186_(), ertr.m_82443_().m_20189_()))) {
                    PacketHandler.sendToServer(new CSSpawnOrgPortalPacket(ertr.m_82443_().m_20183_(), destination, coords.getDimID()));
                }
            }
        }
    }

    public void createItems(CommandMenuSubMenu subMenu) {
        subMenu.getChildren().clear();
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)this.minecraft.f_91074_);
        IWorldCapabilities worldData = ModCapabilities.getWorld((Level)this.minecraft.f_91073_);
        playerData.getEquippedItems().forEach((integer, stack) -> {
            if (!stack.m_41619_()) {
                subMenu.addChild(new CommandMenuItem.Builder(new ResourceLocation("kingdomkeys", integer.toString()), (Component)Component.m_237113_((String)stack.m_41611_().getString().substring(1, stack.m_41611_().getString().length() - 1)), item -> {
                    if (stack.m_41720_() instanceof KKPotionItem) {
                        KKPotionItem potion = (KKPotionItem)stack.m_41720_();
                        Party party = worldData.getPartyFromMember(this.minecraft.f_91074_.m_20148_());
                        if (potion.isGlobal() || party == null) {
                            PacketHandler.sendToServer(new CSUseItemPacket((int)integer));
                        } else if (this.currentSubmenu.equals((Object)this.target) && commandMenuElements.get(this.currentSubmenu).getSelected() != null) {
                            String target = commandMenuElements.get(this.currentSubmenu).getSelected().getId().m_135815_();
                            PacketHandler.sendToServer(new CSUseItemPacket((int)integer, target));
                        } else {
                            this.changeSubmenu(this.target, true);
                            this.playInSound();
                            return;
                        }
                        this.changeSubmenu(this.root, true);
                        this.playSelectSound();
                    } else {
                        this.playErrorSound();
                    }
                }).iconUV(150, 18).build(subMenu));
            }
        });
    }

    public void playSelectSound() {
        this.playSound((SoundEvent)ModSounds.menu_select.get());
    }

    public void playMoveSound() {
        this.playSound((SoundEvent)ModSounds.menu_move.get());
    }

    public void playBackSound() {
        this.playSound((SoundEvent)ModSounds.menu_back.get());
    }

    public void playInSound() {
        this.playSound((SoundEvent)ModSounds.menu_in.get());
    }

    public void playErrorSound() {
        this.playSound((SoundEvent)ModSounds.error.get());
    }

    public void playSound(SoundEvent sound) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Minecraft.m_91087_().f_91073_.m_6263_((Player)player, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), sound, SoundSource.MASTER, 1.0f, 1.0f);
    }

    public void changeSubmenu(ResourceLocation submenu, boolean resetSelected) {
        commandMenuElements.forEach((resourceLocation, subMenu) -> subMenu.setActive(false));
        CommandMenuSubMenu newSubmenu = commandMenuElements.get(submenu);
        CommandMenuSubMenu currentSubMenu = commandMenuElements.get(this.currentSubmenu);
        if (submenu.equals((Object)this.root)) {
            commandMenuElements.forEach((resourceLocation, subMenu) -> {
                if (!resourceLocation.equals((Object)this.root)) {
                    subMenu.setVisible(false);
                }
            });
        }
        if (submenu.equals((Object)this.target)) {
            commandMenuElements.get(submenu).setParent(commandMenuElements.get(this.currentSubmenu));
        }
        if (currentSubMenu.getParent() != null && currentSubMenu.getParent().getId().equals((Object)submenu)) {
            currentSubMenu.setVisible(false);
        }
        if (newSubmenu != null) {
            newSubmenu.close();
            newSubmenu.setActive(true);
            newSubmenu.onOpen();
            if (newSubmenu.visibleSize() > 0) {
                if (!this.currentSubmenu.equals((Object)this.root)) {
                    newSubmenu.setVisible(false);
                }
                if (resetSelected) {
                    newSubmenu.setSelected(newSubmenu.getFirst());
                }
                newSubmenu.setVisible(true);
                this.currentSubmenu = submenu;
            } else {
                newSubmenu.setActive(false);
            }
        }
    }

    public boolean antiFormCheck(IPlayerCapabilities playerData, DriveForm driveForm) {
        if (!driveForm.canGoAnti()) {
            return false;
        }
        if (playerData.isAbilityEquipped("kingdomkeys:ability_dark_domination")) {
            return false;
        }
        if (playerData.isAbilityEquipped("kingdomkeys:ability_light_and_darkness")) {
            PacketHandler.sendToServer(new CSSummonKeyblade(true));
            PacketHandler.sendToServer(new CSUseDriveFormPacket("kingdomkeys:form_anti"));
            this.playSound((SoundEvent)ModSounds.antidrive.get());
            this.changeSubmenu(this.root, true);
            this.playSelectSound();
            return true;
        }
        double random = Math.random();
        int ap = playerData.getAntiPoints();
        int prob = 0;
        if (ap > 0 && ap <= 4) {
            prob = 0;
        } else if (ap > 4 && ap <= 9) {
            prob = 10;
        } else if (ap >= 10) {
            prob = 25;
        }
        if (random * 100.0 < (double)prob) {
            PacketHandler.sendToServer(new CSUseDriveFormPacket("kingdomkeys:form_anti"));
            this.playSound((SoundEvent)ModSounds.antidrive.get());
            this.changeSubmenu(this.root, true);
            this.playSelectSound();
            return true;
        }
        return false;
    }

    @Override
    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int width, int height) {
        super.render(gui, guiGraphics, partialTick, width, height);
        if (this.minecraft.f_91074_ != null && ModCapabilities.getPlayer((Player)this.minecraft.f_91074_) != null) {
            this.drawReactionCommands(guiGraphics, width, height);
            List<CommandMenuSubMenu> submenus = commandMenuElements.values().stream().sorted(Comparator.comparingInt(CommandMenuSubMenu::getZ)).toList();
            submenus.forEach(submenu -> {
                submenu.render(guiGraphics, width, height, partialTick);
                submenu.onUpdate(guiGraphics);
            });
        }
    }

    public static void down() {
        INSTANCE.playMoveSound();
        commandMenuElements.get(CommandMenuGui.INSTANCE.currentSubmenu).next();
    }

    public static void up() {
        INSTANCE.playMoveSound();
        commandMenuElements.get(CommandMenuGui.INSTANCE.currentSubmenu).prev();
    }

    public static void enter() {
        commandMenuElements.get(CommandMenuGui.INSTANCE.currentSubmenu).getSelected().onEnter();
    }

    public static void cancel() {
        commandMenuElements.get(CommandMenuGui.INSTANCE.currentSubmenu).getSelected().onCancel();
    }

    public void drawReactionCommands(GuiGraphics gui, int width, int height) {
        float alpha = 1.0f;
        float scale = 1.05f;
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)this.minecraft.f_91074_);
        List<String> list = playerData.getReactionCommands();
        for (int i = 0; i < list.size(); ++i) {
            gui.m_280168_().m_85836_();
            float shade = i == reactionSelected ? 1.0f : 0.4f;
            RenderSystem.setShaderColor((float)shade, (float)shade, (float)shade, (float)alpha);
            gui.m_280168_().m_252880_(0.0f, (float)(commandMenuElements.get(this.currentSubmenu).getY() - 20 - 16 * i), 0.5f);
            gui.m_280168_().m_85841_(scale, scale, scale);
            gui.m_280168_().m_85836_();
            ReactionCommand command = (ReactionCommand)ModReactionCommands.registry.get().getValue(new ResourceLocation(list.get(i)));
            this.drawString(gui, this.minecraft.f_91062_, Utils.translateToLocal(command.getTranslationKey(), new Object[0]), (int)((double)(5 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset, 4, 0xFFFFFF);
            gui.m_280168_().m_85841_((float)ModConfigs.cmXScale / 75.0f, 1.0f, 1.0f);
            this.blit(gui, commandMenuElements.get(this.currentSubmenu).getTexture(), 0, 0, 0, 15, this.TOP_WIDTH, this.TOP_HEIGHT);
            gui.m_280168_().m_85849_();
            gui.m_280168_().m_85849_();
        }
    }

    static {
        reactionSelected = 0;
    }
}

