/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.OverlayBase;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.lib.Party;

public class PartyHUDGui
extends OverlayBase {
    public static final PartyHUDGui INSTANCE = new PartyHUDGui();
    int hpBarWidth;
    int guiHeight = 10;
    int counter = 0;

    private PartyHUDGui() {
    }

    public ResourceLocation getLocationSkin(Player player) {
        PlayerInfo networkplayerinfo = Minecraft.m_91087_().m_91403_().m_104949_(player.m_20148_());
        return networkplayerinfo == null ? DefaultPlayerSkin.m_118627_((UUID)player.m_20148_()) : networkplayerinfo.m_105337_();
    }

    @Override
    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int width, int height) {
        super.render(gui, guiGraphics, partialTick, width, height);
        LocalPlayer player = this.minecraft.f_91074_;
        int screenWidth = this.minecraft.m_91268_().m_85445_();
        int screenHeight = this.minecraft.m_91268_().m_85446_();
        float scale = 0.5f;
        IWorldCapabilities worldData = ModCapabilities.getWorld((Level)this.minecraft.f_91073_);
        Party p = worldData.getPartyFromMember(player.m_20148_());
        if (p == null) {
            return;
        }
        ArrayList<Party.Member> allies = new ArrayList<Party.Member>();
        allies.clear();
        for (Party.Member m : p.getMembers()) {
            if (m.getUUID().equals(player.m_20148_())) continue;
            allies.add(m);
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)ModConfigs.partyXPos, (float)(ModConfigs.partyYPos - 100), 0.0f);
        for (int i = 0; i < allies.size(); ++i) {
            Party.Member member = (Party.Member)allies.get(i);
            Player playerAlly = player.m_9236_().m_46003_(member.getUUID());
            this.renderFace(guiGraphics, playerAlly, screenWidth, screenHeight, scale, i);
        }
        poseStack.m_85849_();
    }

    public void renderFace(GuiGraphics gui, Player playerAlly, float screenWidth, float screenHeight, float scale, int i) {
        String name;
        ResourceLocation skin = playerAlly != null ? this.getLocationSkin(playerAlly) : new ResourceLocation("minecraft", "textures/entity/player/wide/steve.png");
        PoseStack matrixStack = gui.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(-16.0f, -screenHeight / 4.0f * ((float)(i * ModConfigs.partyYDistance) / 100.0f), 0.0f);
        int headWidth = 32;
        int headHeight = 32;
        float headPosX = 0.0f;
        float headPosY = 0.0f;
        float scaledHeadPosX = headPosX * scale;
        float scaledHeadPosY = headPosY * scale;
        matrixStack.m_85836_();
        matrixStack.m_252880_(screenWidth - (float)headWidth * scale - scaledHeadPosX, screenHeight - (float)headHeight * scale - scaledHeadPosY, 0.0f);
        matrixStack.m_85841_(scale, scale, scale);
        if (playerAlly == null) {
            RenderSystem.setShaderColor((float)0.2f, (float)0.2f, (float)0.2f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.blit(gui, skin, 0, 0, 32, 32, headWidth, headHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.m_85849_();
        int hatWidth = 32;
        int hatHeight = 32;
        float hatPosX = 0.0f;
        float hatPosY = 0.0f;
        float scaledHatPosX = hatPosX * scale;
        float scaledHatPosY = hatPosY * scale;
        matrixStack.m_85836_();
        matrixStack.m_252880_(screenWidth - (float)hatWidth * scale - scaledHatPosX, screenHeight - (float)hatHeight * scale - scaledHatPosY, 0.0f);
        matrixStack.m_85841_(scale, scale, scale);
        this.blit(gui, skin, 0, 0, 160, 32, hatWidth, hatHeight);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(screenWidth - (float)hatWidth * scale - scaledHatPosX, screenHeight - (float)hatHeight * scale - scaledHatPosY, 0.0f);
        matrixStack.m_85841_(scale, scale, scale);
        String string = name = playerAlly == null ? "Out of range" : playerAlly.m_5446_().getString();
        if (playerAlly != null && this.minecraft.f_91074_.m_20270_((Entity)playerAlly) >= (float)ModConfigs.partyRangeLimit) {
            this.drawCenteredString(gui, this.minecraft.f_91062_, "Out of range", 16, -20, 0xFFFFFF);
        }
        this.drawCenteredString(gui, this.minecraft.f_91062_, name, 16, -10, 0xFFFFFF);
        matrixStack.m_85849_();
        if (playerAlly != null) {
            matrixStack.m_252880_(screenWidth - (float)headWidth * scale - scaledHeadPosX, screenHeight - (float)headHeight * scale - scaledHeadPosY, 0.0f);
            float val = playerAlly.m_21223_();
            float max = playerAlly.m_21233_();
            ResourceLocation hptexture = new ResourceLocation("kingdomkeys", "textures/gui/hpbar.png");
            matrixStack.m_252880_(-4.0f, 0.0f, 1.0f);
            matrixStack.m_85836_();
            matrixStack.m_85841_(scale / 3.0f * 2.0f, scale, 1.0f);
            this.blit(gui, hptexture, 0, 0, 0, 72, 12, 2);
            matrixStack.m_85849_();
            matrixStack.m_85836_();
            matrixStack.m_252880_(0.0f, 1.0f, 1.0f);
            matrixStack.m_85841_(scale / 3.0f * 2.0f, scale * 28.0f, 1.0f);
            this.blit(gui, hptexture, 0, 0, 0, 74, 12, 1);
            matrixStack.m_85849_();
            matrixStack.m_85836_();
            matrixStack.m_252880_(0.0f, 30.0f, 1.0f);
            matrixStack.m_85841_(scale / 3.0f * 2.0f, scale, 1.0f);
            this.blit(gui, hptexture, 0, -30, 0, 72, 12, 2);
            matrixStack.m_85849_();
            matrixStack.m_85836_();
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            matrixStack.m_252880_(-4.0f, -15.0f, 1.0f);
            matrixStack.m_85841_(scale * 0.66f, scale * 28.0f * val / max, 1.0f);
            this.blit(gui, hptexture, 0, 0, 0, 78, 12, 1);
            matrixStack.m_85849_();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(playerAlly);
            if (playerData != null) {
                val = (float)playerData.getMP();
                max = (float)playerData.getMaxMP();
                ResourceLocation mptexture = new ResourceLocation("kingdomkeys", "textures/gui/mpbar.png");
                matrixStack.m_252880_(20.0f, 0.0f, 1.0f);
                matrixStack.m_85836_();
                matrixStack.m_85841_(scale / 3.0f * 2.0f, scale, 1.0f);
                this.blit(gui, mptexture, 0, 0, 0, 58, 12, 2);
                matrixStack.m_85849_();
                matrixStack.m_85836_();
                matrixStack.m_252880_(0.0f, 1.0f, 1.0f);
                matrixStack.m_85841_(scale / 3.0f * 2.0f, scale * 28.0f, 1.0f);
                this.blit(gui, mptexture, 0, 0, 0, 60, 12, 1);
                matrixStack.m_85849_();
                matrixStack.m_85836_();
                matrixStack.m_252880_(0.0f, 30.0f, 1.0f);
                matrixStack.m_85841_(scale / 3.0f * 2.0f, scale, 1.0f);
                this.blit(gui, mptexture, 0, -30, 0, 58, 12, 2);
                matrixStack.m_85849_();
                matrixStack.m_85836_();
                matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                matrixStack.m_252880_(-4.0f, -15.0f, 1.0f);
                matrixStack.m_85841_(scale / 3.0f * 2.0f, scale * 28.0f * val / max, 1.0f);
                this.blit(gui, mptexture, 0, 0, 0, 64, 12, 1);
                matrixStack.m_85849_();
            }
        }
        matrixStack.m_85849_();
    }
}

