/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class AbilityCommand
extends BaseCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_ABILITIES = (p_198296_0_, p_198296_1_) -> {
        ArrayList<String> list = new ArrayList<String>();
        for (ResourceLocation actual : ModAbilities.registry.get().getKeys()) {
            list.add(actual.toString());
        }
        return SharedSuggestionProvider.m_82981_(list.stream().map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)p_198296_1_);
    };

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"ability").requires(source -> source.m_6761_(2));
        builder.then(Commands.m_82127_((String)"give").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"ability", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_ABILITIES).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(AbilityCommand::addAbility))).executes(AbilityCommand::addAbility)));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"take").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"ability", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_ABILITIES).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(AbilityCommand::removeAbility))).executes(AbilityCommand::removeAbility))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"all").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(AbilityCommand::removeAllAbilities))).executes(AbilityCommand::removeAllAbilities)));
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
        return builder;
    }

    private static int addAbility(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = AbilityCommand.getPlayers(context, 4);
        String abilityName = StringArgumentType.getString(context, (String)"ability");
        for (ServerPlayer player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            Ability a = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(abilityName));
            playerData.addAbility(abilityName, true);
            if (player != ((CommandSourceStack)context.getSource()).m_81375_()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Added '" + Utils.translateToLocal(a.getTranslationKey(), new Object[0]) + "' ability to " + player.m_5446_().getString())), true);
            }
            player.m_213846_((Component)Component.m_237115_((String)("You have been given the ability '" + Utils.translateToLocal(a.getTranslationKey(), new Object[0]) + "'")));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }

    private static int removeAbility(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = AbilityCommand.getPlayers(context, 4);
        String ability = StringArgumentType.getString(context, (String)"ability");
        for (ServerPlayer player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            playerData.removeAbility(ability);
            if (player != ((CommandSourceStack)context.getSource()).m_81375_()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Removed ability '" + Utils.translateToLocal(ability, new Object[0]) + "' from " + player.m_5446_().getString())), true);
            }
            Ability a = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(ability));
            player.m_213846_((Component)Component.m_237115_((String)("Your ability '" + Utils.translateToLocal(a.getTranslationKey(), new Object[0]) + "' has been taken away")));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }

    private static int removeAllAbilities(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = AbilityCommand.getPlayers(context, 4);
        for (ServerPlayer player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            playerData.clearAbilities();
            if (player != ((CommandSourceStack)context.getSource()).m_81375_()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Removed all abilities from " + player.m_5446_().getString())), true);
            }
            player.m_213846_((Component)Component.m_237115_((String)"Your abilities have been taken away"));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }
}

