/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MagicLevelCommand
extends BaseCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_MAGICS = (p_198296_0_, p_198296_1_) -> {
        ArrayList<String> list = new ArrayList<String>();
        for (ResourceLocation location : ModMagic.registry.get().getKeys()) {
            list.add(location.toString());
        }
        return SharedSuggestionProvider.m_82981_(list.stream().map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)p_198296_1_);
    };

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"magiclevel").requires(source -> source.m_6761_(2));
        builder.then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"magic", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_MAGICS).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)-1, (int)10)).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(MagicLevelCommand::setValue))).executes(MagicLevelCommand::setValue))));
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
        return builder;
    }

    private static int setValue(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = MagicLevelCommand.getPlayers(context, 5);
        int level = IntegerArgumentType.getInteger(context, (String)"level");
        String magic = StringArgumentType.getString(context, (String)"magic");
        Magic magicInstance = (Magic)ModMagic.registry.get().getValue(new ResourceLocation(magic));
        if (magicInstance == null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Unknown magic '" + magic + "'")), true);
            return 1;
        }
        for (ServerPlayer player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            if (level > magicInstance.getMaxLevel()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Level too high, max is '" + magicInstance.getMaxLevel() + "'")), true);
                return 1;
            }
            playerData.setMagicLevel(new ResourceLocation(magic), level, false);
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
            String magicName = level > -1 ? Utils.translateToLocal(magicInstance.getTranslationKey(level), new Object[0]) : "N/A";
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Set " + Utils.translateToLocal(magicInstance.getTranslationKey(), new Object[0]) + " magic for " + player.m_5446_().getString() + " to level " + level + " (" + magicName + ")")), true);
            player.m_213846_((Component)Component.m_237115_((String)("Your " + Utils.translateToLocal(magicInstance.getTranslationKey(), new Object[0]) + " magic level is now " + level + " (" + magicName + ")")));
        }
        return 1;
    }
}

