/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeRegistry;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class RecipeCommand
extends BaseCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_RECIPES = (p_198296_0_, p_198296_1_) -> {
        ArrayList<String> list = new ArrayList<String>();
        for (Recipe actual : RecipeRegistry.getInstance().getValues()) {
            list.add(actual.getRegistryName().toString());
        }
        return SharedSuggestionProvider.m_82981_(list.stream().map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)p_198296_1_);
    };

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"recipe").requires(source -> source.m_6761_(2));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"give").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"recipe", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_RECIPES).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(RecipeCommand::addRecipe))).executes(RecipeCommand::addRecipe))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"all").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(RecipeCommand::addAllRecipes))).executes(RecipeCommand::addAllRecipes))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"keyblades").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(RecipeCommand::addAllKeybladeRecipes))).executes(RecipeCommand::addAllKeybladeRecipes))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"items").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(RecipeCommand::addAllItemRecipes))).executes(RecipeCommand::addAllItemRecipes)));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"take").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"recipe", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_RECIPES).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(RecipeCommand::removeRecipe))).executes(RecipeCommand::removeRecipe))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"all").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(RecipeCommand::removeAllRecipes))).executes(RecipeCommand::removeAllRecipes))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"keyblades").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(RecipeCommand::removeAllKeybladeRecipes))).executes(RecipeCommand::removeAllKeybladeRecipes))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"items").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(RecipeCommand::removeAllItemRecipes))).executes(RecipeCommand::removeAllItemRecipes)));
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
        return builder;
    }

    private static int addRecipe(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = RecipeCommand.getPlayers(context, 4);
        String recipe = StringArgumentType.getString(context, (String)"recipe");
        for (ServerPlayer player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            playerData.addKnownRecipe(new ResourceLocation(recipe));
            if (player != ((CommandSourceStack)context.getSource()).m_81375_()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Added '" + Utils.translateToLocal(recipe, new Object[0]) + "' recipe to " + player.m_5446_().getString())), true);
            }
            player.m_213846_((Component)Component.m_237115_((String)("You have been given '" + Utils.translateToLocal(recipe, new Object[0]) + "' recipe")));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }

    private static int removeRecipe(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = RecipeCommand.getPlayers(context, 4);
        String recipe = StringArgumentType.getString(context, (String)"recipe");
        for (ServerPlayer player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            playerData.removeKnownRecipe(new ResourceLocation(recipe));
            if (player != ((CommandSourceStack)context.getSource()).m_81375_()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Removed recipe '" + Utils.translateToLocal(recipe, new Object[0]) + "' from " + player.m_5446_().getString())), true);
            }
            player.m_213846_((Component)Component.m_237115_((String)("Your recipe '" + Utils.translateToLocal(recipe, new Object[0]) + "' has been taken away")));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }

    private static int addAllRecipes(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = RecipeCommand.getPlayers(context, 4);
        for (ServerPlayer player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            for (Recipe actual : RecipeRegistry.getInstance().getValues()) {
                playerData.addKnownRecipe(actual.getRegistryName());
            }
            if (player != ((CommandSourceStack)context.getSource()).m_81375_()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Added all recipes to " + player.m_5446_().getString())), true);
            }
            player.m_213846_((Component)Component.m_237115_((String)"You have been given all the recipes"));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }

    private static int addAllKeybladeRecipes(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = RecipeCommand.getPlayers(context, 4);
        for (ServerPlayer player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            for (Recipe actual : RecipeRegistry.getInstance().getValues()) {
                if (!actual.getType().equals("keyblade")) continue;
                playerData.addKnownRecipe(actual.getRegistryName());
            }
            if (player != ((CommandSourceStack)context.getSource()).m_81375_()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Added all keyblade recipes to " + player.m_5446_().getString())), true);
            }
            player.m_213846_((Component)Component.m_237115_((String)"You have been given all the keyblade recipes"));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }

    private static int addAllItemRecipes(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = RecipeCommand.getPlayers(context, 4);
        for (ServerPlayer player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            for (Recipe actual : RecipeRegistry.getInstance().getValues()) {
                if (!actual.getType().equals("item")) continue;
                playerData.addKnownRecipe(actual.getRegistryName());
            }
            if (player != ((CommandSourceStack)context.getSource()).m_81375_()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Added all item recipes to " + player.m_5446_().getString())), true);
            }
            player.m_213846_((Component)Component.m_237115_((String)"You have been given all the item recipes"));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }

    private static int removeAllRecipes(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = RecipeCommand.getPlayers(context, 4);
        for (ServerPlayer player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            playerData.clearRecipes("all");
            if (player != ((CommandSourceStack)context.getSource()).m_81375_()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Removed all recipes from " + player.m_5446_().getString())), true);
            }
            player.m_213846_((Component)Component.m_237115_((String)"Your recipes have been taken away"));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }

    private static int removeAllKeybladeRecipes(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = RecipeCommand.getPlayers(context, 4);
        for (ServerPlayer player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            playerData.clearRecipes("keyblade");
            if (player != ((CommandSourceStack)context.getSource()).m_81375_()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Removed all keyblade recipes from " + player.m_5446_().getString())), true);
            }
            player.m_213846_((Component)Component.m_237115_((String)"Your keyblade recipes have been taken away"));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }

    private static int removeAllItemRecipes(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = RecipeCommand.getPlayers(context, 4);
        for (ServerPlayer player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            playerData.clearRecipes("item");
            if (player != ((CommandSourceStack)context.getSource()).m_81375_()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Removed all item recipes from " + player.m_5446_().getString())), true);
            }
            player.m_213846_((Component)Component.m_237115_((String)"Your item recipes have been taken away"));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }
}

