/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.config;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;

public class ClientConfig {
    public ForgeConfigSpec.BooleanValue corsairKeyboardLighting;
    public ForgeConfigSpec.BooleanValue cmHeaderTextVisible;
    public ForgeConfigSpec.BooleanValue cmClassicColors;
    public ForgeConfigSpec.IntValue cmTextXOffset;
    public ForgeConfigSpec.IntValue cmXScale;
    public ForgeConfigSpec.IntValue cmXPos;
    public ForgeConfigSpec.IntValue cmSelectedXOffset;
    public ForgeConfigSpec.IntValue cmSubXOffset;
    public ForgeConfigSpec.BooleanValue hpShowHearts;
    public ForgeConfigSpec.IntValue hpAlarm;
    public ForgeConfigSpec.IntValue hpXPos;
    public ForgeConfigSpec.IntValue hpYPos;
    public ForgeConfigSpec.IntValue hpXScale;
    public ForgeConfigSpec.IntValue mpXPos;
    public ForgeConfigSpec.IntValue mpYPos;
    public ForgeConfigSpec.IntValue mpXScale;
    public ForgeConfigSpec.IntValue dpXPos;
    public ForgeConfigSpec.IntValue dpYPos;
    public ForgeConfigSpec.IntValue dpXScale;
    public ForgeConfigSpec.IntValue dpYScale;
    public ForgeConfigSpec.IntValue playerSkinXPos;
    public ForgeConfigSpec.IntValue playerSkinYPos;
    public ForgeConfigSpec.IntValue lockOnXPos;
    public ForgeConfigSpec.IntValue lockOnYPos;
    public ForgeConfigSpec.IntValue lockOnHPScale;
    public ForgeConfigSpec.IntValue lockOnIconScale;
    public ForgeConfigSpec.IntValue lockOnIconRotation;
    public ForgeConfigSpec.IntValue lockOnHpPerBar;
    public ForgeConfigSpec.IntValue partyXPos;
    public ForgeConfigSpec.IntValue partyYPos;
    public ForgeConfigSpec.IntValue partyYDistance;
    public ForgeConfigSpec.IntValue focusXPos;
    public ForgeConfigSpec.IntValue focusYPos;
    public ForgeConfigSpec.IntValue focusXScale;
    public ForgeConfigSpec.IntValue focusYScale;
    public ForgeConfigSpec.BooleanValue showDriveForms;
    public ForgeConfigSpec.BooleanValue summonTogether;
    public ForgeConfigSpec.EnumValue<ModConfigs.ShowType> showGuiToggle;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> magicDisplayedInCommandMenu;
    public ForgeConfigSpec.BooleanValue cmCursorMemory;

    ClientConfig(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        this.summonTogether = builder.comment("Summon both Keyblade and Armor with Summon Keyblade key").translation("kingdomkeys.config.summon_together").define("summonTogether", false);
        builder.push("gui");
        this.showGuiToggle = builder.comment("Toggle HUD visibility, weapon option will show only while holding a Keyblade or Organization weapon").translation("kingdomkeys.config.show_gui_toggle").defineEnum("showGuiToggle", (Enum)ModConfigs.ShowType.SHOW);
        this.showDriveForms = builder.comment("Drive Forms Visibility").translation("kingdomkeys.config.show_drive_forms").define("showDriveForms", true);
        builder.push("command_menu");
        this.magicDisplayedInCommandMenu = builder.comment("The Magic to display in the Magic menu within the Command Menu").translation("kingdomkeys.config.cm_magic_display").defineList("magicDisplayedInCommandMenu", (List)Lists.newArrayList((Object[])new String[]{"kingdomkeys:magic_fire", "kingdomkeys:magic_blizzard", "kingdomkeys:magic_water", "kingdomkeys:magic_thunder", "kingdomkeys:magic_cure", "kingdomkeys:magic_aero", "kingdomkeys:magic_magnet", "kingdomkeys:magic_reflect", "kingdomkeys:magic_gravity", "kingdomkeys:magic_stop"}), o -> o instanceof String);
        this.cmTextXOffset = builder.comment("Command Menu Text X Offset").translation("kingdomkeys.config.cm_text_x_offset").defineInRange("cmTextXOffset", 0, -1000, 1000);
        this.cmHeaderTextVisible = builder.comment("Command Menu Header Text Visibility").translation("kingdomkeys.config.cm_header_text_visibility").define("cmHeaderTextVisibility", true);
        this.cmClassicColors = builder.comment("Command Menu classic color scheme").translation("kingdomkeys.config.cm_classic_colors").define("cmClassicColors", false);
        this.cmXScale = builder.comment("Command Menu X Scale %").translation("kingdomkeys.config.cm_x_scale").defineInRange("cmXScale", 100, -1000, 1000);
        this.cmXPos = builder.comment("Command Menu X Pos").translation("kingdomkeys.config.cm_x_pos").defineInRange("cmXPos", 0, -1000, 1000);
        this.cmSelectedXOffset = builder.comment("Command Menu Selected X Offset").translation("kingdomkeys.config.cm_selected_x_offset").defineInRange("cmSelectedXOffset", 5, -1000, 1000);
        this.cmSubXOffset = builder.comment("Command Menu Submenu X Offset %").translation("kingdomkeys.config.cm_sub_x_offset").defineInRange("cmSubXOffset", 100, -1000, 1000);
        this.cmCursorMemory = builder.comment("Keep the cursor position in the submenus").translation("kingdomkeysconfig.cm_cursor_memory").define("cmCursorMemory", true);
        builder.pop();
        builder.push("hp_bar");
        this.hpXPos = builder.comment("Health Bar X Pos").translation("kingdomkeys.config.hp_x_pos").defineInRange("hpXPos", 0, -1000, 1000);
        this.hpYPos = builder.comment("Health Bar Y Pos").translation("kingdomkeys.config.hp_y_pos").defineInRange("hpYPos", 0, -1000, 1000);
        this.hpShowHearts = builder.comment("Show Hearts").translation("kingdomkeys.config.hp_hearts").define("hpShowHearts", true);
        this.hpAlarm = builder.comment("Low HP Alarm Volume").translation("kingdomkeys.config.hp_alarm").defineInRange("hpAlarmVolume", 10, 0, 10);
        this.hpXScale = builder.comment("Health Bar X Scale").translation("kingdomkeys.config.hp_x_scale").defineInRange("hpXScale", 100, -1000, 1000);
        builder.pop();
        builder.push("mp_bar");
        this.mpXPos = builder.comment("Magic Bar X Pos").translation("kingdomkeys.config.mp_x_pos").defineInRange("mpXPos", 0, -1000, 1000);
        this.mpYPos = builder.comment("Magic Bar Y Pos").translation("kingdomkeys.config.mp_y_pos").defineInRange("mpYPos", 0, -1000, 1000);
        this.mpXScale = builder.comment("Magic Bar X Scale").translation("kingdomkeys.config.mp_x_scale").defineInRange("mpXScale", 100, -1000, 1000);
        builder.pop();
        builder.push("dp_bar");
        this.dpXPos = builder.comment("Drive Bar X Pos").translation("kingdomkeys.config.dp_x_pos").defineInRange("dpXPos", 0, -1000, 1000);
        this.dpYPos = builder.comment("Drive Bar Y Pos").translation("kingdomkeys.config.dp_y_pos").defineInRange("dpYPos", 0, -1000, 1000);
        this.dpXScale = builder.comment("Drive Bar X Scale").translation("kingdomkeys.config.dp_x_scale").defineInRange("dpXScale", 100, -1000, 1000);
        this.dpYScale = builder.comment("Drive Bar Y Scale").translation("kingdomkeys.config.dp_y_scale").defineInRange("dpYScale", 100, -1000, 1000);
        builder.pop();
        builder.push("player_skin");
        this.playerSkinXPos = builder.comment("Player Skin X Pos").translation("kingdomkeys.config.player_skin_x_pos").defineInRange("playerSkinXPos", 0, -1000, 1000);
        this.playerSkinYPos = builder.comment("Player Skin Y Pos").translation("kingdomkeys.config.player_skin_y_pos").defineInRange("playerSkinYPos", 0, -1000, 1000);
        builder.pop();
        builder.push("lock_on");
        this.lockOnXPos = builder.comment("Lock On HP X Pos").translation("kingdomkeys.config.lock_on_x_pos").defineInRange("lockOnXPos", 0, -1000, 1000);
        this.lockOnYPos = builder.comment("Lock On HP Y Pos").translation("kingdomkeys.config.lock_on_y_pos").defineInRange("lockOnYPos", 0, -1000, 1000);
        this.lockOnHPScale = builder.comment("Lock On HP Bar Scale").translation("kingdomkeys.config.lock_on_hp_scale").defineInRange("lockOnHPScale", 70, -1000, 1000);
        this.lockOnIconScale = builder.comment("Lock On Icon Scale").translation("kingdomkeys.config.lock_on_icon_scale").defineInRange("lockOnIconScale", 75, -1000, 1000);
        this.lockOnIconRotation = builder.comment("Lock On Icon Rotation Speed").translation("kingdomkeys.config.lock_on_icon_rotation").defineInRange("lockOnIconRotation", 16, -1000, 1000);
        this.lockOnHpPerBar = builder.comment("Lock On HP per bar").translation("kingdomkeys.config.lock_on_hp_per_bar").defineInRange("lockOnHpPerBar", 40, 10, 100);
        builder.pop();
        builder.push("party");
        this.partyXPos = builder.comment("Party HUD X Pos").translation("kingdomkeys.config.party_x_pos").defineInRange("partyXPos", 0, -1000, 1000);
        this.partyYPos = builder.comment("Party HUD Y Pos").translation("kingdomkeys.config.party_y_pos").defineInRange("partyYPos", 0, -1000, 1000);
        this.partyYDistance = builder.comment("Party HUD Y Offset").translation("kingdomkeys.config.party_y_offset").defineInRange("partyYOffset", 60, -1000, 1000);
        builder.pop();
        builder.push("focus");
        this.focusXPos = builder.comment("Focus HUD X Pos").translation("kingdomkeys.config.focus_x_pos").defineInRange("focusXPos", 0, -1000, 1000);
        this.focusYPos = builder.comment("Focus HUD Y Pos").translation("kingdomkeys.config.focus_y_pos").defineInRange("focusYPos", 0, -1000, 1000);
        this.focusXScale = builder.comment("Focus Bar X Scale").translation("kingdomkeys.config.focus_x_scale").defineInRange("focusXScale", 100, -1000, 1000);
        this.focusYScale = builder.comment("Focus Bar Y Scale").translation("kingdomkeys.config.focus_y_scale").defineInRange("focusYScale", 100, -1000, 1000);
        builder.pop();
        builder.pop();
    }
}

