/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.config;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    public ForgeConfigSpec.IntValue recipeDropChance;
    public ForgeConfigSpec.IntValue partyRangeLimit;
    public ForgeConfigSpec.IntValue partyMembersLimit;
    public ForgeConfigSpec.IntValue shotlockMaxDist;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> driveFormXPMultiplier;
    public ForgeConfigSpec.ConfigValue<List<? extends Integer>> statsMultiplier;
    public ForgeConfigSpec.DoubleValue xpMultiplier;
    public ForgeConfigSpec.DoubleValue heartMultiplier;
    public ForgeConfigSpec.DoubleValue partyXPShare;
    public ForgeConfigSpec.BooleanValue requireSynthTier;
    public ForgeConfigSpec.BooleanValue projectorHasShop;
    public ForgeConfigSpec.BooleanValue getExpFromShop;
    public ForgeConfigSpec.BooleanValue orgEnabled;
    public ForgeConfigSpec.BooleanValue allowBoosts;
    public ForgeConfigSpec.BooleanValue allowPartyKO;
    public ForgeConfigSpec.BooleanValue wayfinderParty;
    public ForgeConfigSpec.BooleanValue hostileMobsLevel;

    ServerConfig(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        this.recipeDropChance = builder.comment("Recipe drop chance").translation("kingdomkeys.config.recipe_drop_chance").defineInRange("recipeDropChance", 2, 0, 100);
        this.partyRangeLimit = builder.comment("Party range limit").translation("kingdomkeys.config.party_range_limit").defineInRange("partyRangeLimit", 50, 1, 150);
        this.partyMembersLimit = builder.comment("Party members limit").translation("kingdomkeys.config.party_members_limit").defineInRange("partyMembersLimit", 5, 1, 20);
        this.requireSynthTier = builder.comment("If true players will only be able to synthesis items from their tier or lower, if false they can synthesise all regardless of their tier").translation("kingdomkeys.config.require_synth_tier").define("requireSynthTier", false);
        this.projectorHasShop = builder.comment("If true moogle projectors will have the default shop available, if false only the moogles will").translation("kingdomkeys.config.projector_has_shop").define("projectorHasShop", false);
        this.getExpFromShop = builder.comment("If true both synthesis and moogle shop will give EXP for recipes, if false only synthesis").translation("kingdomkeys.config.get_exp_from_shop").define("getExpFromShop", false);
        this.orgEnabled = builder.comment("If true the organization system will be enabled, if false will be disabled").translation("kingdomkeys.config.org_enabled").define("orgEnabled", true);
        this.allowBoosts = builder.comment("If true then boosts like Power Boost, Magic Boost and Defense Boost will be enabled, if false they won't add stats").translation("kingdomkeys.config.allow_boosts").define("allowBoosts", true);
        this.allowPartyKO = builder.comment("If true then when a player in a party (with more party members online) dies, they will be put in a KO state allowing to cast cure or potions to be revived").translation("kingdomkeys.config.allow_party_ko").define("allowPartyKO", false);
        this.wayfinderParty = builder.comment("If true then players will only be able to use the Wayfinder with other party members, if false with anyone").translation("kingdomkeys.config.wayfinder_party").define("wayfinderParty", true);
        this.hostileMobsLevel = builder.comment("If true other hostile mobs will level up alongside the player level the same way heartless do").translation("kingdomkeys.config.hostile_mobs_level").define("hostileMobsLevel", true);
        this.shotlockMaxDist = builder.comment("Shotlock max distance for locking").translation("kingdomkeys.config.shotlock_max_dist").defineInRange("shotlockMaxDist", 100, 1, 1000);
        builder.pop();
        builder.push("leveling");
        this.xpMultiplier = builder.comment("XP Multiplier").translation("kingdomkeys.config.xp_multiplier").defineInRange("xpMultiplier", 1.0, 0.0, 1000.0);
        this.heartMultiplier = builder.comment("Hearts Multiplier").translation("kingdomkeys.config.heart_multiplier").defineInRange("heartMultiplier", 1.0, 0.0, 1000.0);
        this.partyXPShare = builder.comment("XP Share in party (killer gets 100%, the rest of party members the % specified here)").translation("kingdomkeys.config.party_xp_share").defineInRange("partyXPShare", 0.0, 0.0, 100.0);
        this.driveFormXPMultiplier = builder.comment("Drive Form XP Multiplier").translation("kingdomkeys.config.drive_form_xp_multiplier").defineList("driveFormXPMultiplier", (List)Lists.newArrayList((Object[])new String[]{"Valor,1", "Wisdom,1", "Limit,1", "Master,1", "Final,1"}), o -> o instanceof String);
        this.statsMultiplier = builder.comment("Strength, Magic and Defense multiplier in % for players").translation("kingdomkeys.config.stats_multiplier").defineList("statsMultiplier", (List)Lists.newArrayList((Object[])new Integer[]{100, 100, 100}), o -> o instanceof Integer);
        builder.pop();
    }
}

