/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity;

import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.AABB;

public class EntityHelper {
    public static final EntityDataAccessor<Integer> ANIMATION = SynchedEntityData.m_135353_(Mob.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(Mob.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public static void setState(Entity e, int i) {
        e.m_20088_().m_135381_(STATE, (Object)i);
    }

    public static double percentage(double i, double j) {
        return i * 100.0 / j;
    }

    public static int getState(Entity e) {
        return (Integer)e.m_20088_().m_135370_(STATE);
    }

    public static void setAnimation(Entity e, int i) {
        e.m_20088_().m_135381_(ANIMATION, (Object)i);
    }

    public static int getAnimation(Entity e) {
        return (Integer)e.m_20088_().m_135370_(ANIMATION);
    }

    public static Dir get8Directions(Entity e) {
        switch (Mth.m_14107_((double)((double)(e.m_146908_() * 8.0f / 360.0f) + 0.5)) & 7) {
            case 0: {
                return Dir.SOUTH;
            }
            case 1: {
                return Dir.SOUTH_WEST;
            }
            case 2: {
                return Dir.WEST;
            }
            case 3: {
                return Dir.NORTH_WEST;
            }
            case 4: {
                return Dir.NORTH;
            }
            case 5: {
                return Dir.NORTH_EAST;
            }
            case 6: {
                return Dir.EAST;
            }
            case 7: {
                return Dir.SOUTH_EAST;
            }
        }
        return null;
    }

    public static double[] generateAnimationArray(double startPos, double minPos, double maxPos, double frameSkip, int framesPerSlot) {
        double i;
        int framesCount = 0;
        double currentFrame = startPos;
        boolean hasReachedMaxPos = false;
        boolean hasReachedMinPos = false;
        for (i = startPos; i <= maxPos; i += frameSkip) {
            ++framesCount;
        }
        for (i = maxPos; i > minPos; i -= frameSkip) {
            ++framesCount;
        }
        for (i = minPos; i <= startPos; i += frameSkip) {
            ++framesCount;
        }
        framesCount *= framesPerSlot;
        double[] animation = new double[framesCount -= 1 * framesPerSlot];
        for (int j = 0; j < framesCount; ++j) {
            for (int i2 = 0; i2 < framesPerSlot; ++i2) {
                if (j + 1 >= framesCount) continue;
                if (i2 > 0) {
                    ++j;
                }
                animation[j] = currentFrame;
            }
            if (!hasReachedMaxPos && currentFrame < maxPos) {
                currentFrame += frameSkip;
            } else if (!hasReachedMinPos && hasReachedMaxPos && currentFrame > minPos) {
                currentFrame -= frameSkip;
            } else if (hasReachedMinPos && currentFrame < startPos) {
                currentFrame += frameSkip;
            }
            if (currentFrame >= maxPos) {
                hasReachedMaxPos = true;
            }
            if (!(currentFrame <= minPos)) continue;
            hasReachedMinPos = true;
        }
        return animation;
    }

    public static List<LivingEntity> getEntitiesNear(Entity e, double radius) {
        AABB aabb = new AABB(e.m_20185_(), e.m_20186_(), e.m_20189_(), e.m_20185_() + 1.0, e.m_20186_() + 1.0, e.m_20189_() + 1.0).m_82377_(radius, radius, radius);
        List list = e.m_9236_().m_45976_(LivingEntity.class, aabb);
        list.remove(e);
        return list;
    }

    public static enum Dir {
        SOUTH,
        SOUTH_EAST,
        EAST,
        NORTH,
        NORTH_EAST,
        NORTH_WEST,
        WEST,
        SOUTH_WEST;

    }

    public static enum MobType {
        HEARTLESS_PUREBLOOD,
        HEARTLESS_EMBLEM,
        NOBODY,
        NPC,
        BOSS;

    }
}

