/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import online.kingdomkeys.kingdomkeys.block.CardDoorBlock;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.DoorData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomDirection;

public class CardDoorTileEntity
extends BlockEntity {
    boolean open = false;
    BlockPos destination;
    RoomData parent;
    RoomData destinationRoom;
    RoomDirection direction;
    DoorData data;

    public CardDoorTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)ModEntities.TYPE_CARD_DOOR.get(), pWorldPosition, pBlockState);
    }

    public void openDoor(boolean setBlock) {
        this.open = true;
        if (setBlock) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)CardDoorBlock.OPEN, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setParent(RoomData room) {
        this.parent = room;
    }

    public RoomData getParentRoom() {
        return this.parent;
    }

    public RoomData getDestinationRoom() {
        return this.destinationRoom;
    }

    public void setDestinationRoom(RoomData destinationRoom) {
        this.destinationRoom = destinationRoom;
    }

    public void setDirection(RoomDirection direction) {
        this.direction = direction;
    }

    public RoomDirection getDirection() {
        return this.direction;
    }

    public DoorData getData() {
        return this.data;
    }

    public void setData(DoorData data) {
        this.data = data;
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("parent")) {
            this.parent = new RoomData(pTag.m_128469_("parent"));
            this.direction = RoomDirection.values()[pTag.m_128451_("direction")];
        }
        if (pTag.m_128441_("destination_room")) {
            this.destinationRoom = new RoomData(pTag.m_128469_("destination_room"));
        }
        this.open = pTag.m_128471_("open");
        this.destination = this.open && pTag.m_128441_("destination") ? NbtUtils.m_129239_((CompoundTag)pTag.m_128469_("destination")) : null;
        if (pTag.m_128441_("door_data")) {
            this.data = new DoorData(pTag.m_128469_("door_data"));
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        if (this.parent != null) {
            pTag.m_128365_("parent", (Tag)this.parent.serializeNBT());
            pTag.m_128405_("direction", this.direction.ordinal());
        }
        if (this.destinationRoom != null) {
            pTag.m_128365_("destination_room", (Tag)this.destinationRoom.serializeNBT());
        }
        pTag.m_128379_("open", this.open);
        if (this.open && this.destination != null) {
            pTag.m_128365_("destination", (Tag)NbtUtils.m_129224_((BlockPos)this.destination));
        }
        if (this.data != null) {
            pTag.m_128365_("door_data", (Tag)this.data.serializeNBT());
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public CompoundTag m_5995_() {
        return this.serializeNBT();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }
}

